/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.collections.CallChain;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceFix;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "callChainLength", "", "value", "", "callChainLengthText", "getCallChainLengthText", "()Ljava/lang/String;", "setCallChainLengthText", "(Ljava/lang/String;)V", "defaultCallChainLength", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createOptionsPanel", "Ljavax/swing/JPanel;", "OptionsPanel", "kotlin.idea"})
public final class ConvertCallChainIntoSequenceInspection
extends AbstractKotlinInspection {
    private final int defaultCallChainLength;
    private int callChainLength;
    @NotNull
    private String callChainLengthText;

    public ConvertCallChainIntoSequenceInspection() {
        this.callChainLength = this.defaultCallChainLength = 5;
        this.callChainLengthText = String.valueOf(this.defaultCallChainLength);
    }

    @NotNull
    public final String getCallChainLengthText() {
        return this.callChainLengthText;
    }

    public final void setCallChainLengthText(@NotNull String value2) {
        this.callChainLengthText = value2;
        Integer n = StringsKt.toIntOrNull((String)value2);
        this.callChainLength = n != null ? n : this.defaultCallChainLength;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return VisitorWrappersKt.qualifiedExpressionVisitor((Function1)((Function1)new Function1<KtQualifiedExpression, Unit>(this, holder, isOnTheFly){
            final /* synthetic */ ConvertCallChainIntoSequenceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
                super(1);
            }

            public final void invoke(@NotNull KtQualifiedExpression expression2) {
                CallChain callChain = ConvertCallChainIntoSequenceInspectionKt.access$findCallChain(expression2);
                if (callChain == null) {
                    return;
                }
                CallChain callChain2 = callChain;
                KtQualifiedExpression qualified = callChain2.component1();
                KtCallExpression firstCall = callChain2.component2();
                int callChainLength = callChain2.component3();
                KtExpression ktExpression = firstCall.getCalleeExpression();
                if (ktExpression == null || (ktExpression = ktExpression.getTextRange()) == null || (ktExpression = ktExpression.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)qualified)))) == null) {
                    return;
                }
                KtExpression rangeInElement = ktExpression;
                ProblemHighlightType highlightType = callChainLength >= ConvertCallChainIntoSequenceInspection.access$getCallChainLength$p(this.this$0) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertCallChainIntoSequenceFix()};
                this.this$0.registerProblemWithoutOfflineInformation(this.$holder, (PsiElement)qualified, KotlinBundle.message("call.chain.on.collection.could.be.converted.into.sequence.to.improve.performance", new Object[0]), this.$isOnTheFly, highlightType, (TextRange)rangeInElement, localQuickFixArray);
            }
        }));
    }

    @NotNull
    public JPanel createOptionsPanel() {
        return new OptionsPanel(this);
    }

    public static final /* synthetic */ int access$getCallChainLength$p(ConvertCallChainIntoSequenceInspection $this) {
        return $this.callChainLength;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspection$OptionsPanel;", "Ljavax/swing/JPanel;", "owner", "Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspection;", "(Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspection;)V", "kotlin.idea"})
    private static final class OptionsPanel
    extends JPanel {
        public OptionsPanel(final @NotNull ConvertCallChainIntoSequenceInspection owner) {
            EditorTextField editorTextField;
            this.setLayout(new BorderLayout());
            EditorTextField $this$_init__u24lambda_u240 = editorTextField = new EditorTextField(owner.getCallChainLengthText());
            boolean bl = false;
            $this$_init__u24lambda_u240.setOneLineMode(true);
            final EditorTextField regexField = editorTextField;
            regexField.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    owner.setCallChainLengthText(regexField.getText());
                }
            });
            LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)regexField), (String)KotlinBundle.message("call.chain.length.to.transform", new Object[0]), (String)"West");
            this.add((Component)labeledComponent, "North");
        }
    }
}

