/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceIndexLoopWithCollectionLoopQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallsInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.RangeKtExpressionType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractRangeInspection;", "()V", "visitRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "type", "Lorg/jetbrains/kotlin/idea/util/RangeKtExpressionType;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "kotlin.idea"})
public final class ReplaceManualRangeWithIndicesCallsInspection
extends AbstractRangeInspection {
    @Override
    public void visitRange(@NotNull KtExpression range2, @NotNull Lazy<? extends BindingContext> context2, @NotNull RangeKtExpressionType type2, @NotNull ProblemsHolder holder) {
        KtExpression collection;
        KtExpression sizeOrLengthCall;
        Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(range2);
        if (pair == null) {
            return;
        }
        Pair<KtExpression, KtExpression> pair2 = pair;
        KtExpression left = (KtExpression)pair2.component1();
        KtExpression right2 = (KtExpression)pair2.component2();
        if (left == null) {
            return;
        }
        if (right2 == null) {
            return;
        }
        Integer n = ReplaceManualRangeWithIndicesCallsInspectionKt.access$toIntConstant(left);
        if (n == null || n != 0) {
            return;
        }
        KtExpression ktExpression = ReplaceManualRangeWithIndicesCallsInspectionKt.access$sizeOrLengthCall(right2, type2);
        if (ktExpression == null) {
            return;
        }
        KtExpression $this$safeAs$iv = sizeOrLengthCall = ktExpression;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression2 = $this$safeAs$iv;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        Object object = collection = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (collection != null && !(collection instanceof KtSimpleNameExpression) && !(collection instanceof KtThisExpression)) {
            return;
        }
        PsiElement parent2 = range2.getParent().getParent();
        if (parent2 instanceof KtForExpression) {
            PsiElement arrayAccessParent;
            KtExpression ktExpression3;
            LocalQuickFix[] localQuickFixArray;
            KtSimpleNameExpression ktSimpleNameExpression;
            KtArrayAccessExpression arrayAccess;
            KtParameter ktParameter = ((KtForExpression)parent2).getLoopParameter();
            if (ktParameter == null || (ktParameter = ktParameter.getOriginalElement()) == null) {
                return;
            }
            KtParameter paramElement = ktParameter;
            PsiReference psiReference = (PsiReference)CollectionsKt.singleOrNull((Iterable)((Iterable)ReferencesSearch.search((PsiElement)paramElement)));
            Object usageElement = psiReference != null ? psiReference.getElement() : null;
            PsiElement psiElement2 = usageElement;
            PsiElement psiElement3 = psiElement2 != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getParent() : null;
            KtArrayAccessExpression ktArrayAccessExpression = arrayAccess = psiElement3 instanceof KtArrayAccessExpression ? (KtArrayAccessExpression)psiElement3 : null;
            if (!(arrayAccess == null || !Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)arrayAccess.getIndexExpressions()), (Object)usageElement) || !Intrinsics.areEqual((Object)((ktSimpleNameExpression = (localQuickFixArray = arrayAccess.getArrayExpression()) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)localQuickFixArray : null) != null && (ktSimpleNameExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression)) != null ? ktSimpleNameExpression.resolve() : null), (ktExpression3 = collection) != null && (ktExpression3 = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression3))) != null ? ktExpression3.resolve() : null) || (arrayAccessParent = arrayAccess.getParent()) instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)arrayAccessParent).getLeft(), (Object)arrayAccess) && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)arrayAccessParent).getOperationToken()))) {
                localQuickFixArray = new LocalQuickFix[]{new ReplaceIndexLoopWithCollectionLoopQuickFix(type2)};
                holder.registerProblem((PsiElement)range2, KotlinBundle.message("for.loop.over.indices.could.be.replaced.with.loop.over.elements", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
                return;
            }
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceManualRangeWithIndicesCallQuickFix()};
        holder.registerProblem((PsiElement)range2, KotlinBundle.message("range.could.be.replaced.with.indices.call", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
    }
}

