/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameQuickFix$applyFix$;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantQualifierNameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
public final class RemoveRedundantQualifierNameQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("remove.redundant.qualifier.name.quick.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        IntRange intRange;
        PsiFile psiFile2 = descriptor2.getPsiElement().getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile file2 = (KtFile)psiFile2;
        PsiElement element3 = descriptor2.getPsiElement();
        if (element3 instanceof KtUserType) {
            intRange = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)element3), PsiUtilsKt.getEndOffset((PsiElement)element3));
        } else if (element3 instanceof KtDotQualifiedExpression) {
            int n;
            DeclarationDescriptor selectorReference;
            KtExpression ktExpression = ((KtDotQualifiedExpression)element3).getSelectorExpression();
            DeclarationDescriptor declarationDescriptor = selectorReference = ktExpression != null ? RemoveRedundantQualifierNameInspectionKt.access$declarationDescriptor((KtElement)ktExpression, ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)element3, BodyResolveMode.FULL)) : null;
            if (RemoveRedundantQualifierNameInspectionKt.access$isEnumClass(selectorReference) || RemoveRedundantQualifierNameInspectionKt.access$isEnumCompanionObject(selectorReference)) {
                n = PsiUtilsKt.getEndOffset((PsiElement)element3);
            } else {
                KtDotQualifiedExpression ktDotQualifiedExpression;
                PsiElement $this$getLastParentOfTypeInRowWithSelf$iv = element3;
                boolean $i$f$getLastParentOfTypeInRowWithSelf = false;
                Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)$this$getLastParentOfTypeInRowWithSelf$iv), (Function1)applyFix$$inlined$getLastParentOfTypeInRowWithSelf$1.INSTANCE));
                if (!(object instanceof KtDotQualifiedExpression)) {
                    object = null;
                }
                if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)((KtDotQualifiedExpression)object))) != null && (ktDotQualifiedExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktDotQualifiedExpression))) != null) {
                    n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktDotQualifiedExpression));
                } else {
                    return;
                }
            }
            int endOffset2 = n;
            intRange = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)element3), endOffset2);
        } else {
            intRange = IntRange.Companion.getEMPTY();
        }
        IntRange range2 = intRange;
        String string2 = file2.getText().substring(range2.getFirst(), range2.getLast());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String substring = string2;
        KtImportList ktImportList = file2.getImportList();
        Iterable $this$forEach$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)Regex.Companion.fromLiteral(substring).findAll((CharSequence)file2.getText(), ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, file2, it.getRange().getFirst(), it.getRange().getLast() + 1, null, false, 24, null);
        }
    }
}

