/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantQualifierNameQuickFix;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a.\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\r*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u001aT\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0005*\u0002H\u00142\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u0002H\u0014\u0012\u0006\u0012\u0004\u0018\u0001H\u00140\u0016\u00a2\u0006\u0002\b\u00172\u0019\u0010\u0018\u001a\u0015\u0012\u0004\u0012\u0002H\u0014\u0012\u0006\u0012\u0004\u0018\u0001H\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0082\u0010\u00a2\u0006\u0002\u0010\u0019\u001a\u000f\u0010\u001a\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0082\u0010\u001a\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\u001c\u001a\u00020\u000f*\u0004\u0018\u00010\rH\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u000f*\u0004\u0018\u00010\rH\u0002\u001a\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0005*\u00020\tH\u0002\u00a8\u0006\u001f"}, d2={"reportProblem", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "applicableExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "originalExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "oldContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "unwrapFakeOverrides", "", "Lorg/jetbrains/kotlin/psi/KtUserType;", "context", "declarationDescriptor", "firstApplicableExpression", "T", "validator", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "generator", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtElement;", "firstExpressionWithoutReceiver", "isApplicableReceiver", "isEnumClass", "isEnumCompanionObject", "selector", "kotlin.idea"})
public final class RemoveRedundantQualifierNameInspectionKt {
    private static final DeclarationDescriptor declarationDescriptor(KtElement $this$declarationDescriptor, BindingContext context2) {
        KtQualifiedExpression ktQualifiedExpression;
        Object object;
        KtElement $this$safeAs$iv = $this$declarationDescriptor;
        boolean $i$f$safeAs = false;
        KtElement ktElement = $this$safeAs$iv;
        if (!(ktElement instanceof KtQualifiedExpression)) {
            ktElement = null;
        }
        return (object = ReferenceUtilsKt.getMainReference((KtElement)((ktQualifiedExpression = (KtQualifiedExpression)ktElement) != null && (ktQualifiedExpression = ktQualifiedExpression.getSelectorExpression()) != null ? (KtElement)ktQualifiedExpression : $this$declarationDescriptor))) != null && (object = KtReferenceKt.resolveToDescriptors(object, context2)) != null ? (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)((Iterable)object)) : null;
    }

    private static final boolean isEnumClass(DeclarationDescriptor $this$isEnumClass) {
        DeclarationDescriptor $this$safeAs$iv = $this$isEnumClass;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        return (classDescriptor != null ? classDescriptor.getKind() : null) == ClassKind.ENUM_CLASS;
    }

    private static final boolean isEnumCompanionObject(DeclarationDescriptor $this$isEnumCompanionObject) {
        DeclarationDescriptor declarationDescriptor = $this$isEnumCompanionObject;
        return (declarationDescriptor != null ? DescriptorUtilsKt.isCompanionObject((DeclarationDescriptor)declarationDescriptor) : false) && RemoveRedundantQualifierNameInspectionKt.isEnumClass($this$isEnumCompanionObject.getContainingDeclaration());
    }

    private static final KtDotQualifiedExpression firstExpressionWithoutReceiver(KtDotQualifiedExpression $this$firstExpressionWithoutReceiver) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        block2: {
            while (true) {
                if (ExpressionExtKt.hasNotReceiver($this$firstExpressionWithoutReceiver)) {
                    ktDotQualifiedExpression = $this$firstExpressionWithoutReceiver;
                    break block2;
                }
                KtExpression ktExpression = $this$firstExpressionWithoutReceiver.getReceiverExpression();
                if ((ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null) == null) break;
                $this$firstExpressionWithoutReceiver = $this$firstExpressionWithoutReceiver;
            }
            ktDotQualifiedExpression = null;
        }
        return ktDotQualifiedExpression;
    }

    private static final <T extends KtElement> T firstApplicableExpression(T $this$firstApplicableExpression, Function1<? super T, ? extends T> validator2, Function1<? super T, ? extends T> generator) {
        KtElement ktElement;
        block1: {
            while (true) {
                ProgressManager.checkCanceled();
                ktElement = (KtElement)validator2.invoke($this$firstApplicableExpression);
                if (ktElement != null) break block1;
                KtElement ktElement2 = (KtElement)generator.invoke($this$firstApplicableExpression);
                if (ktElement2 == null) break;
                Function1<? super T, ? extends T> function1 = validator2;
                Function1<? super T, ? extends T> function12 = generator;
                $this$firstApplicableExpression = ktElement2;
                validator2 = function1;
                generator = function12;
            }
            ktElement = null;
        }
        return (T)ktElement;
    }

    private static final KtDotQualifiedExpression applicableExpression(KtDotQualifiedExpression $this$applicableExpression, KtExpression originalExpression, BindingContext oldContext, DeclarationDescriptor originalDescriptor, boolean unwrapFakeOverrides) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        FqName newDescriptorFqName;
        if (!RemoveRedundantQualifierNameInspectionKt.isApplicableReceiver($this$applicableExpression.getReceiverExpression(), oldContext) || !ShortenReferences.Companion.canBePossibleToDropReceiver($this$applicableExpression, oldContext)) {
            return null;
        }
        String string2 = originalExpression.getText().substring(PsiUtilsKt.getStartOffset((PsiElement)$this$applicableExpression.getLastChild()) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)originalExpression)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String expressionText2 = string2;
        KtExpression ktExpression = new KtPsiFactory((KtElement)originalExpression, false, 2, null).createExpressionIfPossible(expressionText2);
        if (ktExpression == null) {
            return null;
        }
        KtExpression newExpression2 = ktExpression;
        BindingContext newContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(newExpression2, originalExpression, oldContext, null, null, null, 28, null);
        KtElement ktElement = RemoveRedundantQualifierNameInspectionKt.selector(newExpression2);
        if (ktElement == null || (ktElement = RemoveRedundantQualifierNameInspectionKt.declarationDescriptor(ktElement, newContext)) == null) {
            return null;
        }
        KtElement newDescriptor2 = ktElement;
        FqName originalDescriptorFqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)RemoveRedundantQualifierNameInspectionKt.applicableExpression$unwrapFakeOverrideIfNecessary(originalDescriptor, unwrapFakeOverrides));
        if (!Intrinsics.areEqual((Object)originalDescriptorFqName, (Object)(newDescriptorFqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)RemoveRedundantQualifierNameInspectionKt.applicableExpression$unwrapFakeOverrideIfNecessary((DeclarationDescriptor)newDescriptor2, unwrapFakeOverrides))))) {
            return null;
        }
        KtDotQualifiedExpression it = ktDotQualifiedExpression = $this$applicableExpression;
        boolean bl = false;
        return (newDescriptor2 instanceof ImportedFromObjectCallableDescriptor ? org.jetbrains.kotlin.idea.core.DescriptorUtilsKt.compareDescriptors($this$applicableExpression.getProject(), (DeclarationDescriptor)((ImportedFromObjectCallableDescriptor)newDescriptor2).getCallableFromObject(), originalDescriptor) : org.jetbrains.kotlin.idea.core.DescriptorUtilsKt.compareDescriptors($this$applicableExpression.getProject(), (DeclarationDescriptor)newDescriptor2, originalDescriptor)) ? ktDotQualifiedExpression : null;
    }

    private static final KtElement selector(KtExpression $this$selector) {
        Object object;
        if ($this$selector instanceof KtClassLiteralExpression) {
            KtExpression ktExpression = ((KtClassLiteralExpression)$this$selector).getReceiverExpression();
            object = ktExpression != null ? KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression)) : null;
        } else {
            object = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)$this$selector));
        }
        return object;
    }

    private static final boolean isApplicableReceiver(KtExpression $this$isApplicableReceiver, BindingContext context2) {
        if ($this$isApplicableReceiver instanceof KtInstanceExpressionWithLabel) {
            return false;
        }
        KtElement reference2 = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)$this$isApplicableReceiver));
        KtElement ktElement = reference2;
        if (ktElement == null || (ktElement = RemoveRedundantQualifierNameInspectionKt.declarationDescriptor(ktElement, context2)) == null) {
            return false;
        }
        KtElement descriptor2 = ktElement;
        return !DescriptorUtilsKt.isCompanionObject((DeclarationDescriptor)descriptor2) ? true : !Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)reference2.getText());
    }

    private static final KtUserType applicableExpression(KtUserType $this$applicableExpression, BindingContext context2) {
        FqName fqName2;
        DeclarationDescriptor declarationDescriptor;
        KtNameReferenceExpression referenceExpression;
        block12: {
            block11: {
                ClassConstructorDescriptor classConstructorDescriptor;
                if (!($this$applicableExpression.getFirstChild() instanceof KtUserType)) {
                    return null;
                }
                KtSimpleNameExpression ktSimpleNameExpression = $this$applicableExpression.getReferenceExpression();
                KtNameReferenceExpression ktNameReferenceExpression = ktSimpleNameExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktSimpleNameExpression : null;
                if (ktNameReferenceExpression == null) {
                    return null;
                }
                referenceExpression = ktNameReferenceExpression;
                declarationDescriptor = RemoveRedundantQualifierNameInspectionKt.declarationDescriptor((KtElement)referenceExpression, context2);
                if (declarationDescriptor == null) break block11;
                DeclarationDescriptor it = declarationDescriptor;
                boolean bl = false;
                DeclarationDescriptor $this$safeAs$iv = it;
                boolean $i$f$safeAs = false;
                DeclarationDescriptor declarationDescriptor2 = $this$safeAs$iv;
                if (!(declarationDescriptor2 instanceof ClassConstructorDescriptor)) {
                    declarationDescriptor2 = null;
                }
                DeclarationDescriptor declarationDescriptor3 = (classConstructorDescriptor = (ClassConstructorDescriptor)declarationDescriptor2) != null && (classConstructorDescriptor = classConstructorDescriptor.getContainingDeclaration()) != null ? (DeclarationDescriptor)classConstructorDescriptor : it;
                declarationDescriptor = declarationDescriptor3;
                if (declarationDescriptor3 != null) break block12;
            }
            return null;
        }
        DeclarationDescriptor originalDescriptor = declarationDescriptor;
        if (originalDescriptor instanceof ClassDescriptor && ((ClassDescriptor)originalDescriptor).isInner()) {
            DeclarationDescriptor declarationDescriptor4 = ((ClassDescriptor)originalDescriptor).getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor4 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor4 : null;
            if ((classDescriptor != null ? classDescriptor.getTypeConstructor() : null) != null) {
                return null;
            }
        }
        if ((fqName2 = ImportsUtils.getImportableFqName(originalDescriptor)) == null || (fqName2 = fqName2.shortName()) == null) {
            return null;
        }
        FqName shortName = fqName2;
        LexicalScope lexicalScope = ScopeUtils.getResolutionScope((PsiElement)referenceExpression, context2);
        if (lexicalScope == null) {
            return null;
        }
        LexicalScope scope2 = lexicalScope;
        DescriptorWithDeprecation descriptorWithDeprecation = ScopeUtilsKt.findFirstClassifierWithDeprecationStatus((HierarchicalScope)((HierarchicalScope)scope2), (Name)shortName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
        if (descriptorWithDeprecation == null || (descriptorWithDeprecation = (ClassifierDescriptor)descriptorWithDeprecation.getDescriptor()) == null) {
            return null;
        }
        DescriptorWithDeprecation descriptor2 = descriptorWithDeprecation;
        return Intrinsics.areEqual((Object)descriptor2, (Object)originalDescriptor) ? $this$applicableExpression : null;
    }

    private static final void reportProblem(ProblemsHolder holder, KtElement element3) {
        PsiElement firstChild = element3.getFirstChild();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveRedundantQualifierNameQuickFix()};
        holder.registerProblem((PsiElement)element3, KotlinBundle.message("redundant.qualifier.name", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, TextRange.from((int)firstChild.getStartOffsetInParent(), (int)(firstChild.getTextLength() + 1)), localQuickFixArray);
    }

    private static final DeclarationDescriptor applicableExpression$unwrapFakeOverrideIfNecessary(DeclarationDescriptor $this$applicableExpression_u24unwrapFakeOverrideIfNecessary, boolean $unwrapFakeOverrides) {
        return $unwrapFakeOverrides ? org.jetbrains.kotlin.idea.core.DescriptorUtilsKt.unwrapIfFakeOverride($this$applicableExpression_u24unwrapFakeOverrideIfNecessary) : $this$applicableExpression_u24unwrapFakeOverrideIfNecessary;
    }

    public static final /* synthetic */ KtDotQualifiedExpression access$firstExpressionWithoutReceiver(KtDotQualifiedExpression $receiver) {
        return RemoveRedundantQualifierNameInspectionKt.firstExpressionWithoutReceiver($receiver);
    }

    public static final /* synthetic */ DeclarationDescriptor access$declarationDescriptor(KtElement $receiver, BindingContext context2) {
        return RemoveRedundantQualifierNameInspectionKt.declarationDescriptor($receiver, context2);
    }

    public static final /* synthetic */ boolean access$isEnumCompanionObject(DeclarationDescriptor $receiver) {
        return RemoveRedundantQualifierNameInspectionKt.isEnumCompanionObject($receiver);
    }

    public static final /* synthetic */ boolean access$isEnumClass(DeclarationDescriptor $receiver) {
        return RemoveRedundantQualifierNameInspectionKt.isEnumClass($receiver);
    }

    public static final /* synthetic */ KtElement access$firstApplicableExpression(KtElement $receiver, Function1 validator2, Function1 generator) {
        return RemoveRedundantQualifierNameInspectionKt.firstApplicableExpression($receiver, validator2, generator);
    }

    public static final /* synthetic */ KtDotQualifiedExpression access$applicableExpression(KtDotQualifiedExpression $receiver, KtExpression originalExpression, BindingContext oldContext, DeclarationDescriptor originalDescriptor, boolean unwrapFakeOverrides) {
        return RemoveRedundantQualifierNameInspectionKt.applicableExpression($receiver, originalExpression, oldContext, originalDescriptor, unwrapFakeOverrides);
    }

    public static final /* synthetic */ void access$reportProblem(ProblemsHolder holder, KtElement element3) {
        RemoveRedundantQualifierNameInspectionKt.reportProblem(holder, element3);
    }

    public static final /* synthetic */ KtUserType access$applicableExpression(KtUserType $receiver, BindingContext context2) {
        return RemoveRedundantQualifierNameInspectionKt.applicableExpression($receiver, context2);
    }
}

