/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuspendCallLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.SuspendCallKind;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u00020\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantSuspendModifierInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "hasAnyUnresolvedCalls", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasSuspendCalls", "bindingContext", "kotlin.idea"})
public final class RedundantSuspendModifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ RedundantSuspendModifierInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtNamedFunction function2) {
                if (!LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function2).supportsFeature(LanguageFeature.Coroutines)) {
                    return;
                }
                KtModifierList ktModifierList = function2.getModifierList();
                if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
                    return;
                }
                KtModifierList suspendModifier = ktModifierList;
                if (!function2.hasBody()) {
                    return;
                }
                if (function2.hasModifier(KtTokens.OVERRIDE_KEYWORD) || function2.hasModifier(KtTokens.ACTUAL_KEYWORD)) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyzeWithContent((KtDeclaration)function2);
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)function2);
                if (simpleFunctionDescriptor == null) {
                    return;
                }
                SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
                if (descriptor2.getModality() == Modality.OPEN) {
                    return;
                }
                if (RedundantSuspendModifierInspection.access$hasSuspendCalls(this.this$0, function2, context2)) {
                    return;
                }
                if (RedundantSuspendModifierInspection.access$hasAnyUnresolvedCalls(this.this$0, function2, context2)) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new RemoveModifierFixBase((KtModifierListOwner)function2, KtTokens.SUSPEND_KEYWORD, true))};
                this.$holder.registerProblem((PsiElement)suspendModifier, KotlinBundle.message("redundant.suspend.modifier", new Object[0]), localQuickFixArray);
            }
        }));
    }

    private final boolean hasAnyUnresolvedCalls(KtNamedFunction $this$hasAnyUnresolvedCalls, BindingContext context2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)context2.getDiagnostics();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.UNRESOLVED_REFERENCE) && PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)$this$hasAnyUnresolvedCalls), (PsiElement)it.getPsiElement(), (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasSuspendCalls(KtNamedFunction $this$hasSuspendCalls, BindingContext bindingContext2) {
        void $this$anyDescendantOfType$iv;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$hasSuspendCalls);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor selfDescriptor = declarationDescriptor;
        PsiElement psiElement2 = (PsiElement)$this$hasSuspendCalls;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>(bindingContext2, selfDescriptor){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ DeclarationDescriptor $selfDescriptor;
            {
                this.$bindingContext = $bindingContext;
                this.$selfDescriptor = $selfDescriptor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtExpression expression2) {
                ResolvedCall resolvedCall2;
                SuspendCallKind<?> suspendCallKind = KotlinSuspendCallLineMarkerProviderKt.getSuspendCallKind(expression2, this.$bindingContext);
                if (suspendCallKind == null) {
                    return false;
                }
                SuspendCallKind<?> kind2 = suspendCallKind;
                if (kind2 instanceof SuspendCallKind.FunctionCall && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)((SuspendCallKind.FunctionCall)kind2).getElement()), (BindingContext)this.$bindingContext)) != null) {
                    boolean isRecursiveCall;
                    boolean bl = isRecursiveCall = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? Intrinsics.areEqual((Object)this.$selfDescriptor, (Object)((VariableAsFunctionResolvedCall)resolvedCall2).getFunctionCall().getCandidateDescriptor()) : Intrinsics.areEqual((Object)this.$selfDescriptor, (Object)resolvedCall2.getCandidateDescriptor());
                    if (isRecursiveCall) {
                        return false;
                    }
                }
                return true;
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    public static final /* synthetic */ boolean access$hasSuspendCalls(RedundantSuspendModifierInspection $this, KtNamedFunction $receiver, BindingContext bindingContext2) {
        return $this.hasSuspendCalls($receiver, bindingContext2);
    }

    public static final /* synthetic */ boolean access$hasAnyUnresolvedCalls(RedundantSuspendModifierInspection $this, KtNamedFunction $receiver, BindingContext context2) {
        return $this.hasAnyUnresolvedCalls($receiver, context2);
    }
}

