/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantLetInspectionKt;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H$R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLetInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "bodyExpression", "Lcom/intellij/psi/PsiElement;", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "parameterName", "kotlin.idea"})
public abstract class RedundantLetInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    public RedundantLetInspection() {
        super(KtCallExpression.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        return KotlinBundle.message("redundant.let.call.could.be.removed", new Object[0]);
    }

    @Override
    @Nullable
    public final TextRange inspectionHighlightRangeInElement(@NotNull KtCallExpression element3) {
        KtExpression ktExpression = element3.getCalleeExpression();
        return ktExpression != null ? TextRangeUtilsKt.textRangeIn((PsiElement)ktExpression, (PsiElement)element3) : null;
    }

    @Override
    @NotNull
    public final String getDefaultFixText() {
        return KotlinBundle.message("remove.let.call", new Object[0]);
    }

    @Override
    public final boolean isApplicable(@NotNull KtCallExpression element3) {
        if (!FunctionUtilsKt.isCalling$default(element3, RedundantLetInspectionKt.access$getKOTLIN_LET_FQ_NAME$p(), null, 2, null)) {
            return false;
        }
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)element3.getLambdaArguments());
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return false;
        }
        KtLambdaArgument lambdaExpression2 = ktLambdaArgument;
        String string2 = RedundantLetInspectionKt.access$getParameterName((KtLambdaExpression)lambdaExpression2);
        if (string2 == null) {
            return false;
        }
        String parameterName2 = string2;
        PsiElement psiElement2 = lambdaExpression2.getBodyExpression();
        if (psiElement2 == null || (psiElement2 = psiElement2.getChildren()) == null || (psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])psiElement2)) == null) {
            return false;
        }
        return this.isApplicable(element3, psiElement2, (KtLambdaExpression)lambdaExpression2, parameterName2);
    }

    protected abstract boolean isApplicable(@NotNull KtCallExpression var1, @NotNull PsiElement var2, @NotNull KtLambdaExpression var3, @NotNull String var4);

    @Override
    public final void applyTo(@NotNull KtCallExpression element3, @NotNull Project project, @Nullable Editor editor2) {
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)element3.getLambdaArguments());
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return;
        }
        KtLambdaArgument lambdaExpression2 = ktLambdaArgument;
        PsiElement psiElement2 = lambdaExpression2.getBodyExpression();
        if (psiElement2 == null || (psiElement2 = psiElement2.getChildren()) == null || (psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])psiElement2)) == null) {
            return;
        }
        PsiElement bodyExpression = psiElement2;
        if (bodyExpression instanceof KtDotQualifiedExpression) {
            RedundantLetInspectionKt.access$applyTo((KtDotQualifiedExpression)bodyExpression, element3);
        } else if (bodyExpression instanceof KtBinaryExpression) {
            RedundantLetInspectionKt.access$applyTo((KtBinaryExpression)bodyExpression, element3);
        } else if (bodyExpression instanceof KtCallExpression) {
            RedundantLetInspectionKt.access$applyTo((KtCallExpression)bodyExpression, element3, lambdaExpression2.getFunctionLiteral(), editor2);
        } else if (bodyExpression instanceof KtSimpleNameExpression) {
            RedundantLetInspectionKt.access$deleteCall(element3);
        }
    }
}

