/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.CheckResult;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a'\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"NO_BAD_CHARACTERS", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "NO_BAD_CHARACTERS_OR_UNDERSCORE", "NO_MIDDLE_UNDERSCORES", "NO_START_UNDERSCORE", "NO_START_UPPER", "NO_UNDERSCORES", "PART_RULES", "", "[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "START_LOWER", "START_UPPER", "checkPackageDirective", "Lorg/jetbrains/kotlin/idea/inspections/CheckResult;", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "namingSettings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "checkQualifiedName", "qualifiedName", "", "findRuleMessage", "checkString", "rules", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;)Ljava/lang/String;", "kotlin.idea"})
public final class NamingConventionInspectionsKt {
    @NotNull
    private static final NamingRule START_UPPER = new NamingRule(KotlinBundle.message("should.start.with.an.uppercase.letter", new Object[0]), (Function1<? super String, Boolean>)((Function1)START_UPPER.1.INSTANCE));
    @NotNull
    private static final NamingRule START_LOWER = new NamingRule(KotlinBundle.message("should.start.with.a.lowercase.letter", new Object[0]), (Function1<? super String, Boolean>)((Function1)START_LOWER.1.INSTANCE));
    @NotNull
    private static final NamingRule NO_UNDERSCORES = new NamingRule(KotlinBundle.message("should.not.contain.underscores", new Object[0]), (Function1<? super String, Boolean>)((Function1)NO_UNDERSCORES.1.INSTANCE));
    @NotNull
    private static final NamingRule NO_START_UPPER = new NamingRule(KotlinBundle.message("should.not.start.with.an.uppercase.letter", new Object[0]), (Function1<? super String, Boolean>)((Function1)NO_START_UPPER.1.INSTANCE));
    @NotNull
    private static final NamingRule NO_START_UNDERSCORE = new NamingRule(KotlinBundle.message("should.not.start.with.an.underscore", new Object[0]), (Function1<? super String, Boolean>)((Function1)NO_START_UNDERSCORE.1.INSTANCE));
    @NotNull
    private static final NamingRule NO_MIDDLE_UNDERSCORES = new NamingRule(KotlinBundle.message("should.not.contain.underscores.in.the.middle.or.the.end", new Object[0]), (Function1<? super String, Boolean>)((Function1)NO_MIDDLE_UNDERSCORES.1.INSTANCE));
    @NotNull
    private static final NamingRule NO_BAD_CHARACTERS = new NamingRule(KotlinBundle.message("may.contain.only.letters.and.digits", new Object[0]), (Function1<? super String, Boolean>)((Function1)NO_BAD_CHARACTERS.1.INSTANCE));
    @NotNull
    private static final NamingRule NO_BAD_CHARACTERS_OR_UNDERSCORE = new NamingRule(KotlinBundle.message("may.contain.only.letters.digits.or.underscores", new Object[0]), (Function1<? super String, Boolean>)((Function1)NO_BAD_CHARACTERS_OR_UNDERSCORE.1.INSTANCE));
    @NotNull
    private static final NamingRule[] PART_RULES;

    private static final String findRuleMessage(String checkString, NamingRule[] rules2) {
        for (NamingRule rule : rules2) {
            if (!((Boolean)rule.getMatcher().invoke((Object)checkString)).booleanValue()) continue;
            return rule.getMessage();
        }
        return null;
    }

    private static final CheckResult checkPackageDirective(KtPackageDirective directive, NamingConventionInspectionSettings namingSettings2) {
        return NamingConventionInspectionsKt.checkQualifiedName(directive.getQualifiedName(), namingSettings2);
    }

    private static final CheckResult checkQualifiedName(String qualifiedName2, NamingConventionInspectionSettings namingSettings2) {
        String string2;
        block6: {
            block5: {
                if (((CharSequence)qualifiedName2).length() == 0) break block5;
                Regex regex = namingSettings2.getNameRegex();
                if (regex != null ? !regex.matches((CharSequence)qualifiedName2) : false) break block6;
            }
            return null;
        }
        if (Intrinsics.areEqual((Object)namingSettings2.getNamePattern(), (Object)namingSettings2.getDefaultNamePattern())) {
            char[] cArray = new char[]{'.'};
            string2 = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)qualifiedName2, (char[])cArray, (boolean)false, (int)0, (int)6, null)), (Function1)checkQualifiedName.partErrorMessage.1.INSTANCE));
        } else {
            string2 = null;
        }
        String partErrorMessage2 = string2;
        return partErrorMessage2 != null ? new CheckResult(partErrorMessage2, true) : new CheckResult(namingSettings2.getDefaultErrorMessage(), false);
    }

    public static final /* synthetic */ String access$findRuleMessage(String checkString, NamingRule[] rules2) {
        return NamingConventionInspectionsKt.findRuleMessage(checkString, rules2);
    }

    public static final /* synthetic */ NamingRule access$getSTART_UPPER$p() {
        return START_UPPER;
    }

    public static final /* synthetic */ NamingRule access$getNO_UNDERSCORES$p() {
        return NO_UNDERSCORES;
    }

    public static final /* synthetic */ NamingRule access$getNO_BAD_CHARACTERS$p() {
        return NO_BAD_CHARACTERS;
    }

    public static final /* synthetic */ NamingRule access$getNO_BAD_CHARACTERS_OR_UNDERSCORE$p() {
        return NO_BAD_CHARACTERS_OR_UNDERSCORE;
    }

    public static final /* synthetic */ NamingRule access$getSTART_LOWER$p() {
        return START_LOWER;
    }

    public static final /* synthetic */ NamingRule access$getNO_START_UNDERSCORE$p() {
        return NO_START_UNDERSCORE;
    }

    public static final /* synthetic */ NamingRule access$getNO_MIDDLE_UNDERSCORES$p() {
        return NO_MIDDLE_UNDERSCORES;
    }

    public static final /* synthetic */ CheckResult access$checkPackageDirective(KtPackageDirective directive, NamingConventionInspectionSettings namingSettings2) {
        return NamingConventionInspectionsKt.checkPackageDirective(directive, namingSettings2);
    }

    public static final /* synthetic */ CheckResult access$checkQualifiedName(String qualifiedName2, NamingConventionInspectionSettings namingSettings2) {
        return NamingConventionInspectionsKt.checkQualifiedName(qualifiedName2, namingSettings2);
    }

    public static final /* synthetic */ NamingRule[] access$getPART_RULES$p() {
        return PART_RULES;
    }

    static {
        NamingRule[] namingRuleArray = new NamingRule[]{NO_BAD_CHARACTERS_OR_UNDERSCORE, NO_START_UPPER};
        PART_RULES = namingRuleArray;
    }
}

