/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001)B:\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0003J!\u0010\u001b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\u0010\u001fJ7\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\u0010(R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "", "entityName", "", "defaultNamePattern", "setNamePatternCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDefaultNamePattern", "()Ljava/lang/String;", "namePattern", "getNamePattern", "setNamePattern", "(Ljava/lang/String;)V", "nameRegex", "Lkotlin/text/Regex;", "getNameRegex", "()Lkotlin/text/Regex;", "setNameRegex", "(Lkotlin/text/Regex;)V", "createOptionsPanel", "Ljavax/swing/JPanel;", "getDefaultErrorMessage", "getNameMismatchMessage", "rules", "", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;)Ljava/lang/String;", "verifyName", "element", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "additionalCheck", "Lkotlin/Function0;", "", "(Lcom/intellij/psi/PsiNameIdentifierOwner;Lcom/intellij/codeInspection/ProblemsHolder;Lkotlin/jvm/functions/Function0;[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;)V", "NamingConventionOptionsPanel", "kotlin.idea"})
public final class NamingConventionInspectionSettings {
    @NotNull
    private final String entityName;
    @NotNull
    private final String defaultNamePattern;
    @NotNull
    private final Function1<String, Unit> setNamePatternCallback;
    @Nullable
    private Regex nameRegex;
    @NotNull
    private String namePattern;

    public NamingConventionInspectionSettings(@NotNull String entityName, @Language(value="RegExp") @NotNull String defaultNamePattern, @NotNull Function1<? super String, Unit> setNamePatternCallback) {
        this.entityName = entityName;
        this.defaultNamePattern = defaultNamePattern;
        this.setNamePatternCallback = setNamePatternCallback;
        this.nameRegex = new Regex(this.defaultNamePattern);
        this.namePattern = this.defaultNamePattern;
    }

    @NotNull
    public final String getDefaultNamePattern() {
        return this.defaultNamePattern;
    }

    @Nullable
    public final Regex getNameRegex() {
        return this.nameRegex;
    }

    public final void setNameRegex(@Nullable Regex regex) {
        this.nameRegex = regex;
    }

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String value2) {
        Regex regex;
        NamingConventionInspectionSettings namingConventionInspectionSettings;
        this.namePattern = value2;
        this.setNamePatternCallback.invoke((Object)value2);
        NamingConventionInspectionSettings namingConventionInspectionSettings2 = this;
        try {
            namingConventionInspectionSettings = namingConventionInspectionSettings2;
            regex = new Regex(value2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            namingConventionInspectionSettings = namingConventionInspectionSettings2;
            regex = null;
        }
        namingConventionInspectionSettings.nameRegex = regex;
    }

    public final void verifyName(@NotNull PsiNameIdentifierOwner element3, @NotNull ProblemsHolder holder, @NotNull Function0<Boolean> additionalCheck, @NotNull NamingRule[] rules2) {
        String name2 = element3.getName();
        PsiElement nameIdentifier = element3.getNameIdentifier();
        if (name2 != null && nameIdentifier != null) {
            Regex regex = this.nameRegex;
            boolean bl = regex != null ? !regex.matches((CharSequence)name2) : false;
            if (bl && ((Boolean)additionalCheck.invoke()).booleanValue()) {
                String message2 = this.getNameMismatchMessage(name2, rules2);
                String descriptionTemplate = this.entityName + " " + KotlinBundle.message("text.name", new Object[0]) + " <code>#ref</code> " + message2 + " #loc";
                PsiElement psiElement2 = element3.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement2);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RenameIdentifierFix()};
                holder.registerProblem(psiElement2, descriptionTemplate, localQuickFixArray);
            }
        }
    }

    @NotNull
    public final String getNameMismatchMessage(@NotNull String name2, @NotNull NamingRule[] rules2) {
        if (!Intrinsics.areEqual((Object)this.namePattern, (Object)this.defaultNamePattern)) {
            return this.getDefaultErrorMessage();
        }
        String string2 = NamingConventionInspectionsKt.access$findRuleMessage(name2, rules2);
        if (string2 == null) {
            string2 = this.getDefaultErrorMessage();
        }
        return string2;
    }

    @NotNull
    public final String getDefaultErrorMessage() {
        Object[] objectArray = new Object[]{this.namePattern};
        return KotlinBundle.message("doesn.t.match.regex.0", objectArray);
    }

    @NotNull
    public final JPanel createOptionsPanel() {
        return new NamingConventionOptionsPanel(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings$NamingConventionOptionsPanel;", "Ljavax/swing/JPanel;", "settings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "(Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;)V", "kotlin.idea"})
    private static final class NamingConventionOptionsPanel
    extends JPanel {
        public NamingConventionOptionsPanel(final @NotNull NamingConventionInspectionSettings settings2) {
            EditorTextField editorTextField;
            this.setLayout(new BorderLayout());
            EditorTextField $this$_init__u24lambda_u240 = editorTextField = new EditorTextField(settings2.getNamePattern(), null, (FileType)RegExpFileType.INSTANCE);
            boolean bl = false;
            $this$_init__u24lambda_u240.setOneLineMode(true);
            final EditorTextField regexField = editorTextField;
            regexField.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    settings2.setNamePattern(regexField.getText());
                }
            });
            LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)regexField), (String)KotlinBundle.message("text.pattern", new Object[0]), (String)"West");
            this.add((Component)labeledComponent, "North");
        }
    }
}

