/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MigrateDiagnosticSuppressionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Holder", "ReplaceDiagnosticNameFix", "kotlin.idea"})
public final class MigrateDiagnosticSuppressionInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return (PsiElementVisitor)VisitorWrappersKt.annotationEntryVisitor((Function1)((Function1)new Function1<KtAnnotationEntry, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtAnnotationEntry annotationEntry2) {
                KtConstructorCalleeExpression ktConstructorCalleeExpression = annotationEntry2.getCalleeExpression();
                if (!Intrinsics.areEqual((Object)(ktConstructorCalleeExpression != null ? ktConstructorCalleeExpression.getText() : null), (Object)"Suppress")) {
                    return;
                }
                BindingContext context2 = ResolutionUtils.analyze((KtElement)annotationEntry2, BodyResolveMode.PARTIAL);
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry2);
                if (annotationDescriptor == null) {
                    return;
                }
                AnnotationDescriptor descriptor2 = annotationDescriptor;
                if (!Intrinsics.areEqual((Object)descriptor2.getFqName(), (Object)StandardNames.FqNames.suppress)) {
                    return;
                }
                for (ValueArgument argument2 : annotationEntry2.getValueArguments()) {
                    DiagnosticFactoryWithPsiElement<? extends KtElement, ? extends AbstractDiagnostic<? extends KtElement>> newDiagnosticFactory;
                    KtStringTemplateExpression expression2;
                    KtExpression ktExpression = argument2.getArgumentExpression();
                    if ((ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null) == null) continue;
                    expression2 = expression2;
                    String text2 = expression2.getText();
                    Character c = StringsKt.firstOrNull((CharSequence)text2);
                    char c2 = '\"';
                    if (c == null || c.charValue() != c2) continue;
                    Character c3 = StringsKt.lastOrNull((CharSequence)text2);
                    c2 = '\"';
                    if (c3 == null || c3.charValue() != c2 || Holder.INSTANCE.getMIGRATION_MAP().get(StringUtil.unquoteString((String)text2)) == null) continue;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceDiagnosticNameFix(newDiagnosticFactory.getName())};
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("diagnostic.name.should.be.replaced.by.the.new.one", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
                }
            }
        }));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MigrateDiagnosticSuppressionInspection$ReplaceDiagnosticNameFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "diagnosticFactoryName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    public static final class ReplaceDiagnosticNameFix
    implements LocalQuickFix {
        @NotNull
        private final String diagnosticFactoryName;

        public ReplaceDiagnosticNameFix(@NotNull String diagnosticFactoryName) {
            this.diagnosticFactoryName = diagnosticFactoryName;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.getFamilyName(), this.diagnosticFactoryName};
            return KotlinBundle.message("replace.diagnostic.name.fix.text", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("replace.diagnostic.name.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtStringTemplateExpression ktStringTemplateExpression = psiElement2 instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)psiElement2 : null;
            if (ktStringTemplateExpression == null) {
                return;
            }
            KtStringTemplateExpression expression2 = ktStringTemplateExpression;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)expression2)) {
                return;
            }
            KtPsiFactory psiFactory = new KtPsiFactory((KtElement)expression2, false, 2, null);
            expression2.replace((PsiElement)psiFactory.createExpression("\"" + this.diagnosticFactoryName + "\""));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u00a8\u0001\u0010\u0003\u001a\u0098\u0001\u0012\u0004\u0012\u00020\u0005\u0012\u008d\u0001\u0012\u008a\u0001\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t \b*D\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t\u0018\u00010\u00060\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MigrateDiagnosticSuppressionInspection$Holder;", "", "()V", "MIGRATION_MAP", "", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/diagnostics/AbstractDiagnostic;", "getMIGRATION_MAP", "()Ljava/util/Map;", "kotlin.idea"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final Map<String, DiagnosticFactoryWithPsiElement<? extends KtElement, ? extends AbstractDiagnostic<? extends KtElement>>> MIGRATION_MAP;

        private Holder() {
        }

        @NotNull
        public final Map<String, DiagnosticFactoryWithPsiElement<? extends KtElement, ? extends AbstractDiagnostic<? extends KtElement>>> getMIGRATION_MAP() {
            return MIGRATION_MAP;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"HEADER_DECLARATION_WITH_BODY", (Object)Errors.EXPECTED_DECLARATION_WITH_BODY), TuplesKt.to((Object)"HEADER_CLASS_CONSTRUCTOR_DELEGATION_CALL", (Object)Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL), TuplesKt.to((Object)"HEADER_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER", (Object)Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER), TuplesKt.to((Object)"HEADER_ENUM_CONSTRUCTOR", (Object)Errors.EXPECTED_ENUM_CONSTRUCTOR), TuplesKt.to((Object)"HEADER_ENUM_ENTRY_WITH_BODY", (Object)Errors.EXPECTED_ENUM_ENTRY_WITH_BODY), TuplesKt.to((Object)"HEADER_PROPERTY_INITIALIZER", (Object)Errors.EXPECTED_PROPERTY_INITIALIZER), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_NOT_TO_CLASS", (Object)Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE", (Object)Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE", (Object)Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE), TuplesKt.to((Object)"IMPL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION", (Object)Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION), TuplesKt.to((Object)"HEADER_WITHOUT_IMPLEMENTATION", (Object)Errors.NO_ACTUAL_FOR_EXPECT), TuplesKt.to((Object)"IMPLEMENTATION_WITHOUT_HEADER", (Object)Errors.ACTUAL_WITHOUT_EXPECT), TuplesKt.to((Object)"HEADER_CLASS_MEMBERS_ARE_NOT_IMPLEMENTED", (Object)Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS), TuplesKt.to((Object)"IMPL_MISSING", (Object)Errors.ACTUAL_MISSING)};
            MIGRATION_MAP = MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

