/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.imports.OptimizedImportsBuilder;
import org.jetbrains.kotlin.idea.inspections.KotlinOptimizeImportsQuickFix;
import org.jetbrains.kotlin.idea.inspections.KotlinUnusedImportInspection;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0002J \u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "optimizeImportsOnTheFly", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "optimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "scheduleOptimizeImportsOnTheFly", "data", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "scheduleOptimizeOnDaemonFinished", "action", "Lkotlin/Function0;", "timeToOptimizeImportsOnTheFly", "Companion", "EnableOptimizeImportsOnTheFlyFix", "ImportData", "kotlin.idea"})
public final class KotlinUnusedImportInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$mapTo$iv$iv;
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        ImportData importData = Companion.analyzeImports((KtFile)file2);
        if (importData == null) {
            return null;
        }
        ImportData data2 = importData;
        Iterable $this$map$iv = data2.getUnusedImports();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ArrayList<LocalQuickFixOnPsiElement> fixes = new ArrayList<LocalQuickFixOnPsiElement>();
            fixes.add(new KotlinOptimizeImportsQuickFix((KtFile)file2));
            if (!KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)((KtFile)file2).getProject()).optimizeImportsOnTheFly) {
                fixes.add(new EnableOptimizeImportsOnTheFlyFix((KtFile)file2));
            }
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            collection.add(manager.createProblemDescriptor((PsiElement)it, KotlinBundle.message("unused.import.directive", new Object[0]), isOnTheFly, thisCollection$iv.toArray(new LocalQuickFix[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        List problems = (List)destination$iv$iv;
        if (isOnTheFly) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.scheduleOptimizeImportsOnTheFly((KtFile)file2, data2.getOptimizerData());
            }
        }
        Collection $this$toTypedArray$iv = problems;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    private final void scheduleOptimizeImportsOnTheFly(KtFile file2, OptimizedImportsBuilder.InputData data2) {
        if (!KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)file2.getProject()).optimizeImportsOnTheFly) {
            return;
        }
        List<ImportPath> list2 = KotlinImportOptimizer.Companion.prepareOptimizedImports(file2, data2);
        if (list2 == null) {
            return;
        }
        List<ImportPath> optimizedImports = list2;
        Project project = file2.getProject();
        long modificationCount = PsiModificationTracker.getInstance((Project)project).getModificationCount();
        this.scheduleOptimizeOnDaemonFinished(file2, (Function0<Unit>)((Function0)new Function0<Unit>(file2, project, modificationCount, this, optimizedImports){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ long $modificationCount;
            final /* synthetic */ KotlinUnusedImportInspection this$0;
            final /* synthetic */ List<ImportPath> $optimizedImports;
            {
                this.$file = $file;
                this.$project = $project;
                this.$modificationCount = $modificationCount;
                this.this$0 = $receiver;
                this.$optimizedImports = $optimizedImports;
                super(0);
            }

            public final void invoke() {
                Editor editor2 = PsiEditorUtil.findEditor((PsiElement)((PsiElement)this.$file));
                long currentModificationCount = PsiModificationTracker.getInstance((Project)this.$project).getModificationCount();
                if (editor2 != null && currentModificationCount == this.$modificationCount && KotlinUnusedImportInspection.access$timeToOptimizeImportsOnTheFly(this.this$0, this.$file, editor2, this.$project)) {
                    KotlinUnusedImportInspection.access$optimizeImportsOnTheFly(this.this$0, this.$file, this.$optimizedImports, editor2, this.$project);
                }
            }
        }));
    }

    private final void scheduleOptimizeOnDaemonFinished(KtFile file2, Function0<Unit> action2) {
        Disposable daemonDisposable = Disposer.newDisposable();
        Project myProject = file2.getProject();
        myProject.getMessageBus().connect(daemonDisposable).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(daemonDisposable, myProject, file2, this, action2){
            final /* synthetic */ Disposable $daemonDisposable;
            final /* synthetic */ Project $myProject;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ KotlinUnusedImportInspection this$0;
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$daemonDisposable = $daemonDisposable;
                this.$myProject = $myProject;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$action = $action;
            }

            public void daemonFinished(@NotNull Collection<? extends FileEditor> incomingFileEditors) {
                Disposer.dispose((Disposable)this.$daemonDisposable);
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.$myProject);
                Intrinsics.checkNotNull((Object)daemonCodeAnalyzer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx");
                if (((DaemonCodeAnalyzerEx)daemonCodeAnalyzer).isErrorAnalyzingFinished((PsiFile)this.$file)) {
                    ((AppUIExecutor)AppUIExecutor.onUiThread().later().expireWith((Disposable)this.$myProject)).withDocumentsCommitted(this.$myProject).execute(() -> scheduleOptimizeOnDaemonFinished.1.daemonFinished$lambda$0(this.$file, this.$action));
                } else {
                    KotlinUnusedImportInspection.access$scheduleOptimizeOnDaemonFinished(this.this$0, this.$file, this.$action);
                }
            }

            private static final void daemonFinished$lambda$0(KtFile $file, Function0 $action) {
                if ($file.isValid() && $file.isWritable()) {
                    $action.invoke();
                }
            }
        });
    }

    private final boolean timeToOptimizeImportsOnTheFly(KtFile file2, Editor editor2, Project project) {
        if (project.isDisposed() || !file2.isValid() || editor2.isDisposed() || !file2.isWritable()) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        if (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) {
            return false;
        }
        KtImportList ktImportList = file2.getImportList();
        if (ktImportList == null) {
            return false;
        }
        KtImportList importList = ktImportList;
        Object object = SequencesKt.firstOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)importList), (boolean)false, (boolean)false));
        PsiWhiteSpace leftSpace = object instanceof PsiWhiteSpace ? (PsiWhiteSpace)object : null;
        Object object2 = SequencesKt.firstOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)importList), (boolean)true, (boolean)false));
        PsiWhiteSpace rightSpace = object2 instanceof PsiWhiteSpace ? (PsiWhiteSpace)object2 : null;
        PsiWhiteSpace psiWhiteSpace = leftSpace;
        PsiElement left = psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)importList;
        PsiWhiteSpace psiWhiteSpace2 = rightSpace;
        PsiElement right2 = psiWhiteSpace2 != null ? (PsiElement)psiWhiteSpace2 : (PsiElement)importList;
        TextRange importsRange = new TextRange(left.getTextRange().getStartOffset(), right2.getTextRange().getEndOffset());
        if (importsRange.containsOffset(editor2.getCaretModel().getOffset())) {
            return false;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)project);
        if (!codeAnalyzer.isHighlightingAvailable((PsiFile)file2)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)file2)) {
            return false;
        }
        Document document = editor2.getDocument();
        Ref.BooleanRef hasErrors = new Ref.BooleanRef();
        DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document.getTextLength(), arg_0 -> KotlinUnusedImportInspection.timeToOptimizeImportsOnTheFly$lambda$1((Function1)new Function1<HighlightInfo, Boolean>(importsRange, hasErrors){
            final /* synthetic */ TextRange $importsRange;
            final /* synthetic */ Ref.BooleanRef $hasErrors;
            {
                this.$importsRange = $importsRange;
                this.$hasErrors = $hasErrors;
                super(1);
            }

            @NotNull
            public final Boolean invoke(HighlightInfo highlightInfo) {
                boolean bl;
                if (!this.$importsRange.containsRange(highlightInfo.startOffset, highlightInfo.endOffset)) {
                    this.$hasErrors.element = true;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, arg_0));
        if (hasErrors.element) {
            return false;
        }
        return DaemonListeners.canChangeFileSilently((PsiFileSystemItem)((PsiFileSystemItem)file2), (boolean)true);
    }

    private final void optimizeImportsOnTheFly(KtFile file2, List<ImportPath> optimizedImports, Editor editor2, Project project) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document document = documentManager.getDocument((PsiFile)file2);
        if (document == null) {
            document = editor2.getDocument();
        }
        Document doc = document;
        documentManager.commitDocument(doc);
        DocumentUtil.writeInRunUndoTransparentAction(() -> KotlinUnusedImportInspection.optimizeImportsOnTheFly$lambda$2(file2, optimizedImports, project, doc));
    }

    private static final boolean timeToOptimizeImportsOnTheFly$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void optimizeImportsOnTheFly$lambda$2(KtFile $file, List $optimizedImports, Project $project, Document $doc) {
        KotlinImportOptimizer.Companion.replaceImports($file, $optimizedImports);
        PsiDocumentManager.getInstance((Project)$project).doPostponedOperationsAndUnblockDocument($doc);
    }

    public static final /* synthetic */ boolean access$timeToOptimizeImportsOnTheFly(KotlinUnusedImportInspection $this, KtFile file2, Editor editor2, Project project) {
        return $this.timeToOptimizeImportsOnTheFly(file2, editor2, project);
    }

    public static final /* synthetic */ void access$optimizeImportsOnTheFly(KotlinUnusedImportInspection $this, KtFile file2, List optimizedImports, Editor editor2, Project project) {
        $this.optimizeImportsOnTheFly(file2, optimizedImports, editor2, project);
    }

    public static final /* synthetic */ void access$scheduleOptimizeOnDaemonFinished(KotlinUnusedImportInspection $this, KtFile file2, Function0 action2) {
        $this.scheduleOptimizeOnDaemonFinished(file2, (Function0<Unit>)action2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$ImportData;", "", "unusedImports", "", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "optimizerData", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "(Ljava/util/List;Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;)V", "getOptimizerData", "()Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "getUnusedImports", "()Ljava/util/List;", "kotlin.idea"})
    public static final class ImportData {
        @NotNull
        private final List<KtImportDirective> unusedImports;
        @NotNull
        private final OptimizedImportsBuilder.InputData optimizerData;

        public ImportData(@NotNull List<? extends KtImportDirective> unusedImports, @NotNull OptimizedImportsBuilder.InputData optimizerData) {
            this.unusedImports = unusedImports;
            this.optimizerData = optimizerData;
        }

        @NotNull
        public final List<KtImportDirective> getUnusedImports() {
            return this.unusedImports;
        }

        @NotNull
        public final OptimizedImportsBuilder.InputData getOptimizerData() {
            return this.optimizerData;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$Companion;", "", "()V", "analyzeImports", "Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$ImportData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ImportData analyzeImports(@NotNull KtFile file2) {
            void $this$mapNotNullTo$iv$iv;
            Iterable parentFqName;
            if (file2 instanceof KtCodeFragment) {
                return null;
            }
            if (!SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, 15, null), (PsiElement)file2)) {
                return null;
            }
            if (file2.getImportDirectives().isEmpty()) {
                return null;
            }
            OptimizedImportsBuilder.InputData optimizerData = KotlinImportOptimizer.Companion.collectDescriptorsToImport$default(KotlinImportOptimizer.Companion, file2, false, 2, null);
            List directives = file2.getImportDirectives();
            Set explicitlyImportedFqNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)directives), (Function1)analyzeImports.explicitlyImportedFqNames.1.INSTANCE), (Function1)analyzeImports.explicitlyImportedFqNames.2.INSTANCE), (Function1)analyzeImports.explicitlyImportedFqNames.3.INSTANCE));
            Map<FqName, Set<Name>> fqNames = optimizerData.getNamesToImport();
            HashSet<Iterable> parentFqNames = new HashSet<Iterable>();
            Iterator<OptimizedImportsBuilder.ImportableDescriptor> iterator = optimizerData.getDescriptorsToImport().iterator();
            while (iterator.hasNext()) {
                FqName fqName2 = iterator.next().component2();
                if (explicitlyImportedFqNames2.contains(fqName2) || (parentFqName = fqName2.parent()).isRoot()) continue;
                parentFqNames.add(parentFqName);
            }
            Iterable $this$mapNotNull$iv = optimizerData.getReferences();
            boolean $i$f$mapNotNull = false;
            parentFqName = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FqName it$iv$iv;
                KtInvokeFunctionReference reference2;
                KtNamedFunction ktNamedFunction;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                OptimizedImportsBuilder.AbstractReference it = (OptimizedImportsBuilder.AbstractReference)element$iv$iv;
                boolean bl2 = false;
                KtElement ktElement = it.getElement();
                KtCallExpression ktCallExpression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
                KtReference ktReference = ktCallExpression != null ? ReferenceUtilsKt.getMainReference((KtReferenceExpression)((KtReferenceExpression)ktCallExpression)) : null;
                KtInvokeFunctionReference ktInvokeFunctionReference = ktReference instanceof KtInvokeFunctionReference ? (KtInvokeFunctionReference)ktReference : null;
                if ((ktInvokeFunctionReference == null ? null : ((ktNamedFunction = (ktReference = (reference2 = ktInvokeFunctionReference).resolve()) instanceof KtNamedFunction ? (KtNamedFunction)ktReference : null) != null && (ktNamedFunction = SearchHelpersKt.getDescriptor((KtDeclaration)ktNamedFunction)) != null ? ImportsUtils.getImportableFqName((DeclarationDescriptor)ktNamedFunction) : null)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List invokeFunctionCallFqNames = (List)destination$iv$iv;
            HashSet<ImportPath> importPaths2 = new HashSet<ImportPath>(directives.size());
            ArrayList unusedImports = new ArrayList();
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)file2);
            for (KtImportDirective directive : directives) {
                boolean isUsed;
                boolean bl;
                ImportPath importPath;
                if (directive.getImportPath() == null) continue;
                if (CollectionsKt.contains((Iterable)optimizerData.getUnresolvedNames(), (Object)importPath.getImportedName())) {
                    bl = true;
                } else if (!importPaths2.add(importPath)) {
                    bl = false;
                } else if (importPath.isAllUnder()) {
                    bl = !((Collection)optimizerData.getUnresolvedNames()).isEmpty() || parentFqNames.contains(importPath.getFqName());
                } else if (fqNames.containsKey(importPath.getFqName())) {
                    if (importPath.getImportedName() != null) {
                        boolean bl4 = false;
                        bl = ((Set)MapsKt.getValue(fqNames, (Object)importPath.getFqName())).contains(it);
                    } else {
                        bl = false;
                    }
                } else if (invokeFunctionCallFqNames.contains(importPath.getFqName())) {
                    bl = true;
                } else if ((DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)UtilsKt.targetDescriptors(directive, resolutionFacade)) != null) {
                    boolean bl5 = false;
                    bl = fqNames.containsKey(ImportsUtils.getImportableFqName((DeclarationDescriptor)it));
                } else {
                    bl = false;
                }
                if (isUsed = bl) continue;
                ((Collection)unusedImports).add(directive);
            }
            return new ImportData(unusedImports, optimizerData);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$EnableOptimizeImportsOnTheFlyFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "kotlin.idea"})
    private static final class EnableOptimizeImportsOnTheFlyFix
    extends LocalQuickFixOnPsiElement
    implements LowPriorityAction {
        public EnableOptimizeImportsOnTheFlyFix(@NotNull KtFile file2) {
            super((PsiElement)file2);
        }

        @NotNull
        public String getText() {
            return QuickFixBundle.message((String)"enable.optimize.imports.on.the.fly", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
            KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project).optimizeImportsOnTheFly = true;
            new OptimizeImportsProcessor(project, file2).run();
        }
    }
}

