/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.KotlinInspectionSuppressor;
import org.jetbrains.kotlin.idea.inspections.KotlinRedundantDiagnosticSuppressInspectionKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\t\"\u0006\u0012\u0002\b\u00030\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a,\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"availableDiagnostics", "", "", "getAvailableDiagnostics", "()Ljava/util/Set;", "availableDiagnostics$delegate", "Lkotlin/Lazy;", "extractDiagnosticNames", "classes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)Ljava/util/Set;", "findAllDiagnostics", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtFile;", "allSuppressedPlaces", "findAllSuppressedPlaces", "suppressor", "Lorg/jetbrains/kotlin/idea/inspections/KotlinInspectionSuppressor;", "kotlin.idea"})
public final class KotlinRedundantDiagnosticSuppressInspectionKt {
    @NotNull
    private static final Lazy availableDiagnostics$delegate = LazyKt.lazy((Function0)availableDiagnostics.2.INSTANCE);

    private static final MultiMap<String, PsiElement> findAllDiagnostics(KtFile $this$findAllDiagnostics, MultiMap<String, PsiElement> allSuppressedPlaces) {
        MultiMap multiMap;
        boolean bl;
        KtAnnotated firstElement;
        block4: {
            Collection places = allSuppressedPlaces.values();
            Object object = CollectionsKt.first((Iterable)places);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotated");
            firstElement = (KtAnnotated)object;
            Iterable $this$all$iv = places;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (it == firstElement) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        Diagnostics diagnostics2 = bl ? ResolutionUtils.analyzeWithContentAndGetResult((KtElement)firstElement).getBindingContext().getDiagnostics() : ResolutionUtils.analyzeWithAllCompilerChecks($this$findAllDiagnostics, new KtFile[0]).getBindingContext().getDiagnostics();
        MultiMap $this$findAllDiagnostics_u24lambda_u241 = multiMap = MultiMap.create();
        boolean bl3 = false;
        for (Diagnostic diagnostic : diagnostics2.noSuppression()) {
            String string2 = diagnostic.getFactoryName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            $this$findAllDiagnostics_u24lambda_u241.putValue((Object)string2, (Object)diagnostic.getPsiElement());
        }
        return multiMap;
    }

    private static final MultiMap<String, PsiElement> findAllSuppressedPlaces(KtFile $this$findAllSuppressedPlaces, KotlinInspectionSuppressor suppressor) {
        MultiMap allSuppressedPlaces = MultiMap.createSet();
        $this$findAllSuppressedPlaces.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(suppressor, (MultiMap<String, PsiElement>)allSuppressedPlaces){
            final /* synthetic */ KotlinInspectionSuppressor $suppressor;
            final /* synthetic */ MultiMap<String, PsiElement> $allSuppressedPlaces;
            {
                this.$suppressor = $suppressor;
                this.$allSuppressedPlaces = $allSuppressedPlaces;
            }

            public void visitElement(@NotNull PsiElement element3) {
                for (String id : this.$suppressor.suppressionIds(element3)) {
                    String idInLowercase;
                    Intrinsics.checkNotNullExpressionValue((Object)id.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!KotlinRedundantDiagnosticSuppressInspectionKt.access$getAvailableDiagnostics().contains(idInLowercase)) continue;
                    this.$allSuppressedPlaces.putValue((Object)idInLowercase, (Object)element3);
                }
                super.visitElement(element3);
            }
        });
        return allSuppressedPlaces;
    }

    private static final Set<String> getAvailableDiagnostics() {
        Lazy lazy = availableDiagnostics$delegate;
        return (Set)lazy.getValue();
    }

    private static final Set<String> extractDiagnosticNames(Class<?> ... classes2) {
        Set set2 = new LinkedHashSet();
        for (Class<?> klass2 : classes2) {
            for (Field field2 : klass2.getDeclaredFields()) {
                String string2;
                if (!Modifier.isStatic(field2.getModifiers())) continue;
                Object value2 = field2.get(null);
                if (value2 instanceof DiagnosticFactoryForDeprecation) {
                    string2 = ((DiagnosticFactoryForDeprecation)value2).getWarningFactory().getName();
                } else if (value2 instanceof DiagnosticFactory) {
                    Object object = value2;
                    DiagnosticFactory it = (DiagnosticFactory)object;
                    boolean bl = false;
                    DiagnosticFactory diagnosticFactory = (DiagnosticFactory)(!(it.getSeverity() == Severity.ERROR) ? object : null);
                    string2 = diagnosticFactory != null ? diagnosticFactory.getName() : null;
                } else {
                    string2 = null;
                }
                if (string2 == null) continue;
                String name2 = string2;
                Collection collection = set2;
                String string3 = name2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                collection.add(string3);
            }
        }
        return set2;
    }

    public static final /* synthetic */ MultiMap access$findAllSuppressedPlaces(KtFile $receiver, KotlinInspectionSuppressor suppressor) {
        return KotlinRedundantDiagnosticSuppressInspectionKt.findAllSuppressedPlaces($receiver, suppressor);
    }

    public static final /* synthetic */ MultiMap access$findAllDiagnostics(KtFile $receiver, MultiMap allSuppressedPlaces) {
        return KotlinRedundantDiagnosticSuppressInspectionKt.findAllDiagnostics($receiver, (MultiMap<String, PsiElement>)allSuppressedPlaces);
    }

    public static final /* synthetic */ Set access$getAvailableDiagnostics() {
        return KotlinRedundantDiagnosticSuppressInspectionKt.getAvailableDiagnostics();
    }

    public static final /* synthetic */ Set access$extractDiagnosticNames(Class ... classes2) {
        return KotlinRedundantDiagnosticSuppressInspectionKt.extractDiagnosticNames(classes2);
    }
}

