/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspection;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\u00020\b*\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FunctionNameInspection;", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getNamingRules", "", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "()[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "isFactoryFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shortName", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.idea"})
public final class FunctionNameInspection
extends NamingConventionInspection {
    public FunctionNameInspection() {
        super(KotlinBundle.message("function", new Object[0]), "[a-z][A-Za-z\\d]*", null);
    }

    @Override
    @NotNull
    protected NamingRule[] getNamingRules() {
        NamingRule[] namingRuleArray = new NamingRule[]{NamingConventionInspectionsKt.access$getSTART_LOWER$p(), NamingConventionInspectionsKt.access$getNO_UNDERSCORES$p(), NamingConventionInspectionsKt.access$getNO_BAD_CHARACTERS$p()};
        return namingRuleArray;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ FunctionNameInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtNamedFunction function2) {
                if (function2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    return;
                }
                if (!TestUtils.isInTestSourceContent((PsiElement)((PsiElement)function2))) {
                    this.this$0.verifyName((PsiNameIdentifierOwner)function2, this.$holder, (Function0<Boolean>)((Function0)new Function0<Boolean>(this.this$0, function2){
                        final /* synthetic */ FunctionNameInspection this$0;
                        final /* synthetic */ KtNamedFunction $function;
                        {
                            this.this$0 = $receiver;
                            this.$function = $function;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            return !FunctionNameInspection.access$isFactoryFunction(this.this$0, this.$function);
                        }
                    }));
                }
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFactoryFunction(KtNamedFunction $this$isFactoryFunction) {
        KotlinType it;
        KtTypeElement typeElement;
        String string2 = $this$isFactoryFunction.getName();
        if (string2 == null) {
            return false;
        }
        String functionName = string2;
        KtTypeReference ktTypeReference = $this$isFactoryFunction.getTypeReference();
        Object object = typeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (typeElement != null) {
            KtTypeElement $this$safeAs$iv = KtPsiUtilKt.unwrapNullability((KtTypeElement)typeElement);
            boolean $i$f$safeAs = false;
            KtTypeElement ktTypeElement = $this$safeAs$iv;
            if (!(ktTypeElement instanceof KtUserType)) {
                ktTypeElement = null;
            }
            KtUserType ktUserType2 = (KtUserType)ktTypeElement;
            return Intrinsics.areEqual((Object)(ktUserType2 != null ? ktUserType2.getReferencedName() : null), (Object)functionName);
        }
        FunctionDescriptor functionDescriptor3 = ResolutionUtils.resolveToDescriptorIfAny$default($this$isFactoryFunction, null, 1, null);
        functionDescriptor3 = functionDescriptor3;
        if (functionDescriptor2 == null) return false;
        if ((functionDescriptor3 = functionDescriptor3.getReturnType()) == null) {
            return false;
        }
        FunctionDescriptor returnType2 = functionDescriptor3;
        if (Intrinsics.areEqual((Object)this.shortName((KotlinType)returnType2), (Object)functionName)) return true;
        Iterable $this$any$iv = TypeUtilsKt.supertypes((KotlinType)returnType2);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KotlinType)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)this.shortName(it), (Object)functionName));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String shortName(KotlinType $this$shortName) {
        FqName fqName2;
        FqName fqName4 = FqNameUtilKt.getFqName($this$shortName);
        fqName4 = fqName4;
        if (fqName3 == null) return null;
        FqName p0 = fqName2 = fqName4;
        boolean bl = false;
        if (p0.isRoot()) return null;
        FqName fqName4 = fqName2;
        fqName4 = fqName4;
        if (fqName5 == null) return null;
        Name name2 = fqName4.shortName();
        fqName4 = name2;
        if (name2 == null) return null;
        String string2 = fqName4.asString();
        return string2;
    }

    public static final /* synthetic */ boolean access$isFactoryFunction(FunctionNameInspection $this, KtNamedFunction $receiver) {
        return $this.isFactoryFunction($receiver);
    }
}

