/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.AbstractReplaceRangeToWithRangeUntilInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J:\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J2\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\"\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016J\f\u0010'\u001a\u00020\u0016*\u00020\"H\u0002J\f\u0010(\u001a\u00020\u0016*\u00020\"H\u0002J\f\u0010)\u001a\u00020\u0016*\u00020\"H\u0002J\f\u0010*\u001a\u00020\u0016*\u00020\u0013H\u0002J\u000e\u0010+\u001a\u00020\u0016*\u0004\u0018\u00010\"H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRangeExpressionData", "Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection$RangeExpressionData;", "condition", "firstLess", "Lorg/jetbrains/kotlin/psi/KtExpression;", "firstGreater", "firstStrict", "", "secondLess", "secondGreater", "secondStrict", "value", "min", "max", "incrementMinByOne", "decrementMaxByOne", "getDoubleConstant", "intExpr", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "inspectionText", "isApplicable", "isComparable", "isFloatingPoint", "isInteger", "isSimple", "isValidTypeForIncrementDecrementByOne", "RangeExpressionData", "kotlin.idea"})
public final class ConvertTwoComparisonsToRangeCheckInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    public ConvertTwoComparisonsToRangeCheckInspection() {
        super(KtBinaryExpression.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        return KotlinBundle.message("two.comparisons.should.be.converted.to.a.range.check", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("convert.to.a.range.check", new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element3);
        if (rangeExpressionData == null) {
            return false;
        }
        RangeExpressionData rangeData = rangeExpressionData;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction function2 = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (function2 != null && function2.hasModifier(KtTokens.OPERATOR_KEYWORD) && Intrinsics.areEqual((Object)function2.getNameAsName(), (Object)OperatorNameConventions.CONTAINS)) {
            BindingContext context2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL);
            DeclarationDescriptor functionDescriptor2 = (DeclarationDescriptor)context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)function2);
            KtBinaryExpression newExpression2 = rangeData.createExpression();
            BindingContext newContext = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)newExpression2, (KtExpression)element3, context2, null, null, null, 28, null);
            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)newExpression2.getOperationReference()), (BindingContext)newContext);
            if (Intrinsics.areEqual((Object)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null), (Object)functionDescriptor2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @NotNull Project project, @Nullable Editor editor2) {
        block1: {
            RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element3);
            if (rangeExpressionData == null) {
                return;
            }
            RangeExpressionData rangeData = rangeExpressionData;
            PsiElement replaced2 = element3.replace((PsiElement)rangeData.createExpression());
            KtBinaryExpression ktBinaryExpression = replaced2 instanceof KtBinaryExpression ? (KtBinaryExpression)replaced2 : null;
            if (ktBinaryExpression == null || (ktBinaryExpression = ktBinaryExpression.getRight()) == null) break block1;
            KtBinaryExpression it = ktBinaryExpression;
            boolean bl = false;
            AbstractReplaceRangeToWithRangeUntilInspection.Companion.applyFixIfApplicable((KtExpression)it);
        }
    }

    private final RangeExpressionData generateRangeExpressionData(KtBinaryExpression condition2) {
        if (!Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)KtTokens.ANDAND)) {
            return null;
        }
        KtExpression ktExpression = condition2.getLeft();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression firstCondition = ktBinaryExpression;
        KtExpression ktExpression2 = condition2.getRight();
        KtBinaryExpression ktBinaryExpression2 = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression2 == null) {
            return null;
        }
        KtBinaryExpression secondCondition = ktBinaryExpression2;
        IElementType firstOpToken = firstCondition.getOperationToken();
        IElementType secondOpToken = secondCondition.getOperationToken();
        KtExpression ktExpression3 = firstCondition.getLeft();
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression firstLeft = ktExpression3;
        KtExpression ktExpression4 = firstCondition.getRight();
        if (ktExpression4 == null) {
            return null;
        }
        KtExpression firstRight = ktExpression4;
        KtExpression ktExpression5 = secondCondition.getLeft();
        if (ktExpression5 == null) {
            return null;
        }
        KtExpression secondLeft = ktExpression5;
        KtExpression ktExpression6 = secondCondition.getRight();
        if (ktExpression6 == null) {
            return null;
        }
        KtExpression secondRight = ktExpression6;
        boolean firstStrict = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$isStrictComparison(firstOpToken);
        boolean secondStrict = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$isStrictComparison(secondOpToken);
        Pair<KtExpression, KtExpression> pair = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$orderLessAndGreater(firstOpToken, firstLeft, firstRight);
        if (pair == null) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair2 = pair;
        KtExpression firstLess = (KtExpression)pair2.component1();
        KtExpression firstGreater = (KtExpression)pair2.component2();
        Pair<KtExpression, KtExpression> pair3 = ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$orderLessAndGreater(secondOpToken, secondLeft, secondRight);
        if (pair3 == null) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair4 = pair3;
        KtExpression secondLess = (KtExpression)pair4.component1();
        KtExpression secondGreater = (KtExpression)pair4.component2();
        return this.generateRangeExpressionData(firstLess, firstGreater, firstStrict, secondLess, secondGreater, secondStrict);
    }

    private final boolean isSimple(KtExpression $this$isSimple) {
        return $this$isSimple instanceof KtConstantExpression || $this$isSimple instanceof KtNameReferenceExpression;
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression firstLess, KtExpression firstGreater, boolean firstStrict, KtExpression secondLess, KtExpression secondGreater, boolean secondStrict) {
        return !(firstGreater instanceof KtConstantExpression) && IfThenUtilsKt.evaluatesTo(firstGreater, secondLess) ? this.generateRangeExpressionData(firstGreater, firstLess, secondGreater, firstStrict, secondStrict) : (!(firstLess instanceof KtConstantExpression) && IfThenUtilsKt.evaluatesTo(firstLess, secondGreater) ? this.generateRangeExpressionData(firstLess, secondLess, firstGreater, secondStrict, firstStrict) : null);
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression value2, KtExpression min, KtExpression max, boolean incrementMinByOne, boolean decrementMaxByOne) {
        if (!this.isSimple(min) || !this.isSimple(max)) {
            return null;
        }
        BindingContext context2 = ResolutionUtils.analyze$default((KtElement)value2, null, 1, null);
        KotlinType valType = CallUtilKt.getType((KtExpression)value2, (BindingContext)context2);
        KotlinType minType = CallUtilKt.getType((KtExpression)min, (BindingContext)context2);
        KotlinType maxType = CallUtilKt.getType((KtExpression)max, (BindingContext)context2);
        if (valType == null || minType == null || maxType == null) {
            return null;
        }
        if (!this.isComparable(valType)) {
            return null;
        }
        KtExpression minVal = min;
        KtExpression maxVal = max;
        if (!Intrinsics.areEqual((Object)minType, (Object)valType) || !Intrinsics.areEqual((Object)maxType, (Object)valType)) {
            if (TypeUtilsKt.isPrimitiveNumberType((KotlinType)valType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)minType) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)maxType)) {
                if (KotlinBuiltIns.isChar((KotlinType)valType) || KotlinBuiltIns.isChar((KotlinType)minType) || KotlinBuiltIns.isChar((KotlinType)maxType)) {
                    return null;
                }
                if (this.isInteger(valType) && (this.isFloatingPoint(minType) || this.isFloatingPoint(maxType))) {
                    return null;
                }
                if (this.isFloatingPoint(valType)) {
                    if (this.isInteger(minType)) {
                        String string2 = this.getDoubleConstant(min, minType, context2);
                        if (string2 == null) {
                            return null;
                        }
                        minVal = new KtPsiFactory((KtElement)minVal, false, 2, null).createExpression(string2);
                    }
                    if (this.isInteger(maxType)) {
                        String string3 = this.getDoubleConstant(max, maxType, context2);
                        if (string3 == null) {
                            return null;
                        }
                        maxVal = new KtPsiFactory((KtElement)maxVal, false, 2, null).createExpression(string3);
                    }
                }
            } else {
                return null;
            }
        }
        if ((incrementMinByOne || decrementMaxByOne) && !this.isValidTypeForIncrementDecrementByOne(valType)) {
            return null;
        }
        String minText = incrementMinByOne ? ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$getChangeBy(minVal, this, context2, 1) : minVal.getText();
        String maxText = decrementMaxByOne ? ConvertTwoComparisonsToRangeCheckInspection.generateRangeExpressionData$getChangeBy(maxVal, this, context2, -1) : maxVal.getText();
        String string4 = minText;
        if (string4 == null) {
            return null;
        }
        String string5 = maxText;
        if (string5 == null) {
            return null;
        }
        return new RangeExpressionData(value2, string4, string5);
    }

    private final String getDoubleConstant(KtExpression intExpr, KotlinType type2, BindingContext context2) {
        Object object = ConstantExpressionEvaluator.Companion.getConstant(intExpr, context2);
        if (object == null || (object = object.getValue(type2)) == null) {
            return null;
        }
        Object intConst = object;
        Number number2 = intConst instanceof Number ? (Number)((Number)intConst) : (Number)null;
        return number2 != null ? Double.valueOf(number2.doubleValue()).toString() : null;
    }

    private final boolean isComparable(KotlinType $this$isComparable) {
        return DescriptorUtils.isSubtypeOfClass((KotlinType)$this$isComparable, (DeclarationDescriptor)((DeclarationDescriptor)TypeUtilsKt.getBuiltIns((KotlinType)$this$isComparable).getComparable()));
    }

    private final boolean isFloatingPoint(KotlinType $this$isFloatingPoint) {
        return KotlinBuiltIns.isFloat((KotlinType)$this$isFloatingPoint) || KotlinBuiltIns.isDouble((KotlinType)$this$isFloatingPoint);
    }

    private final boolean isInteger(KotlinType $this$isInteger) {
        return KotlinBuiltIns.isInt((KotlinType)$this$isInteger) || KotlinBuiltIns.isLong((KotlinType)$this$isInteger) || KotlinBuiltIns.isShort((KotlinType)$this$isInteger) || KotlinBuiltIns.isByte((KotlinType)$this$isInteger);
    }

    private final boolean isValidTypeForIncrementDecrementByOne(KotlinType $this$isValidTypeForIncrementDecrementByOne) {
        if ($this$isValidTypeForIncrementDecrementByOne == null) {
            return false;
        }
        return this.isInteger($this$isValidTypeForIncrementDecrementByOne) || KotlinBuiltIns.isChar((KotlinType)$this$isValidTypeForIncrementDecrementByOne);
    }

    private static final boolean generateRangeExpressionData$isStrictComparison(IElementType $this$generateRangeExpressionData_u24isStrictComparison) {
        return Intrinsics.areEqual((Object)$this$generateRangeExpressionData_u24isStrictComparison, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)$this$generateRangeExpressionData_u24isStrictComparison, (Object)KtTokens.LT);
    }

    private static final Pair<KtExpression, KtExpression> generateRangeExpressionData$orderLessAndGreater(IElementType $this$generateRangeExpressionData_u24orderLessAndGreater, KtExpression left, KtExpression right2) {
        IElementType iElementType = $this$generateRangeExpressionData_u24orderLessAndGreater;
        return (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) ? TuplesKt.to((Object)right2, (Object)left) : ((Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) ? TuplesKt.to((Object)left, (Object)right2) : null);
    }

    private static final String generateRangeExpressionData$getChangeBy(KtExpression $this$generateRangeExpressionData_u24getChangeBy, ConvertTwoComparisonsToRangeCheckInspection this$0, BindingContext context2, int number2) {
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$generateRangeExpressionData_u24getChangeBy, (BindingContext)context2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        if (!this$0.isValidTypeForIncrementDecrementByOne(type2)) {
            return null;
        }
        if ($this$generateRangeExpressionData_u24getChangeBy instanceof KtConstantExpression) {
            Object object;
            Object object2 = ConstantExpressionEvaluator.Companion.getConstant($this$generateRangeExpressionData_u24getChangeBy, context2);
            if (object2 == null || (object2 = object2.getValue(type2)) == null) {
                return null;
            }
            Object constantValue = object2;
            if (KotlinBuiltIns.isInt((KotlinType)type2)) {
                int it = (Integer)constantValue + number2;
                boolean bl = false;
                String text2 = ((KtConstantExpression)$this$generateRangeExpressionData_u24getChangeBy).getText();
                if (StringsKt.startsWith$default((String)text2, (String)"0x", (boolean)false, (int)2, null)) {
                    String string2 = Integer.toString(it, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
                    object = "0x" + string2;
                } else if (StringsKt.startsWith$default((String)text2, (String)"0b", (boolean)false, (int)2, null)) {
                    String string3 = Integer.toString(it, CharsKt.checkRadix((int)2));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
                    object = "0b" + string3;
                } else {
                    object = String.valueOf(it);
                }
            } else if (KotlinBuiltIns.isLong((KotlinType)type2)) {
                long it = (Long)constantValue + (long)number2;
                boolean bl = false;
                String text3 = ((KtConstantExpression)$this$generateRangeExpressionData_u24getChangeBy).getText();
                if (StringsKt.startsWith$default((String)text3, (String)"0x", (boolean)false, (int)2, null)) {
                    String string4 = Long.toString(it, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
                    object = "0x" + string4;
                } else if (StringsKt.startsWith$default((String)text3, (String)"0b", (boolean)false, (int)2, null)) {
                    String string5 = Long.toString(it, CharsKt.checkRadix((int)2));
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
                    object = "0b" + string5;
                } else {
                    object = String.valueOf(it);
                }
            } else {
                object = KotlinBuiltIns.isChar((KotlinType)type2) ? "'" + (char)(((Character)constantValue).charValue() + number2) + "'" : null;
            }
            return object;
        }
        return number2 >= 0 ? "(" + $this$generateRangeExpressionData_u24getChangeBy.getText() + " + " + number2 + ")" : "(" + $this$generateRangeExpressionData_u24getChangeBy.getText() + " - " + -number2 + ")";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertTwoComparisonsToRangeCheckInspection$RangeExpressionData;", "", "value", "Lorg/jetbrains/kotlin/psi/KtExpression;", "min", "", "max", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Ljava/lang/String;)V", "getMax", "()Ljava/lang/String;", "getMin", "getValue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "component1", "component2", "component3", "copy", "createExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "equals", "", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class RangeExpressionData {
        @NotNull
        private final KtExpression value;
        @NotNull
        private final String min;
        @NotNull
        private final String max;

        public RangeExpressionData(@NotNull KtExpression value2, @NotNull String min, @NotNull String max) {
            this.value = value2;
            this.min = min;
            this.max = max;
        }

        @NotNull
        public final KtExpression getValue() {
            return this.value;
        }

        @NotNull
        public final String getMin() {
            return this.min;
        }

        @NotNull
        public final String getMax() {
            return this.max;
        }

        @NotNull
        public final KtBinaryExpression createExpression() {
            KtPsiFactory factory2 = new KtPsiFactory((KtElement)this.value, false, 2, null);
            Object[] objectArray = new Object[]{this.value, factory2.createExpression(this.min), factory2.createExpression(this.max)};
            KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0 in $1..$2", (Object[])objectArray, (boolean)false, (int)4, null);
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            return (KtBinaryExpression)ktExpression;
        }

        @NotNull
        public final KtExpression component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.min;
        }

        @NotNull
        public final String component3() {
            return this.max;
        }

        @NotNull
        public final RangeExpressionData copy(@NotNull KtExpression value2, @NotNull String min, @NotNull String max) {
            return new RangeExpressionData(value2, min, max);
        }

        public static /* synthetic */ RangeExpressionData copy$default(RangeExpressionData rangeExpressionData, KtExpression ktExpression, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = rangeExpressionData.value;
            }
            if ((n & 2) != 0) {
                string2 = rangeExpressionData.min;
            }
            if ((n & 4) != 0) {
                string3 = rangeExpressionData.max;
            }
            return rangeExpressionData.copy(ktExpression, string2, string3);
        }

        @NotNull
        public String toString() {
            return "RangeExpressionData(value=" + this.value + ", min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.min.hashCode();
            result2 = result2 * 31 + this.max.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RangeExpressionData)) {
                return false;
            }
            RangeExpressionData rangeExpressionData = (RangeExpressionData)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)rangeExpressionData.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.min, (Object)rangeExpressionData.min)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.max, (Object)rangeExpressionData.max);
        }
    }
}

