/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.inspections.ScopeFunctionConversionInspectionKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "counterpartName", "", "(Ljava/lang/String;)V", "analyzeLambda", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "lambdaDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "replacements", "Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "applyFix", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "postprocessLambda", "kotlin.idea"})
public abstract class ConvertScopeFunctionFix
implements LocalQuickFix {
    @NotNull
    private final String counterpartName;

    public ConvertScopeFunctionFix(@NotNull String counterpartName) {
        this.counterpartName = counterpartName;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.counterpartName};
        return KotlinBundle.message("convert.scope.function.fix.family.name", objectArray);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        PsiElement psiElement2 = problemDescriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        KtNameReferenceExpression callee2 = (KtNameReferenceExpression)psiElement2;
        PsiElement psiElement3 = callee2.getParent();
        KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)callExpression2, null, 1, null);
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)callExpression2.getLambdaArguments());
        if (ktLambdaArgument == null) {
            return;
        }
        KtLambdaArgument lambda2 = ktLambdaArgument;
        KtLambdaExpression ktLambdaExpression2 = lambda2.getLambdaExpression();
        if (ktLambdaExpression2 == null || (ktLambdaExpression2 = ktLambdaExpression2.getFunctionLiteral()) == null) {
            return;
        }
        KtLambdaExpression functionLiteral = ktLambdaExpression2;
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)functionLiteral);
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor lambdaDescriptor = simpleFunctionDescriptor;
        KtParameterList ktParameterList = functionLiteral.getValueParameterList();
        if (ktParameterList != null) {
            ktParameterList.delete();
        }
        PsiElement psiElement4 = functionLiteral.getArrow();
        if (psiElement4 != null) {
            psiElement4.delete();
        }
        ReplacementCollection replacements = new ReplacementCollection(project);
        this.analyzeLambda(bindingContext2, lambda2, lambdaDescriptor, replacements);
        KtExpression ktExpression = new KtPsiFactory(project, false, 2, null).createExpression(this.counterpartName);
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        callee2.replace((PsiElement)((KtNameReferenceExpression)ktExpression));
        replacements.apply();
        this.postprocessLambda(lambda2);
        if (replacements.isNotEmpty() && replacements.getElementToRename() != null) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement psiElement5 = replacements.getElementToRename();
                Intrinsics.checkNotNull((Object)psiElement5);
                ScopeFunctionConversionInspectionKt.access$startInPlaceRename(psiElement5);
            }
        }
    }

    protected abstract void postprocessLambda(@NotNull KtLambdaArgument var1);

    protected abstract void analyzeLambda(@NotNull BindingContext var1, @NotNull KtLambdaArgument var2, @NotNull SimpleFunctionDescriptor var3, @NotNull ReplacementCollection var4);
}

