/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.ConvertNaNEqualityInspectionKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertNaNEqualityQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "inverted", "", "(Z)V", "getInverted", "()Z", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
final class ConvertNaNEqualityQuickFix
implements LocalQuickFix {
    private final boolean inverted;

    public ConvertNaNEqualityQuickFix(boolean inverted) {
        this.inverted = inverted;
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    @NotNull
    public String getName() {
        return KotlinBundle.message("convert.na.n.equality.quick.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        KtExpression ktExpression;
        PsiElement psiElement2 = descriptor2.getPsiElement();
        KtBinaryExpression ktBinaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element3 = ktBinaryExpression;
        if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(element3.getLeft())) {
            ktExpression = element3.getRight();
            if (ktExpression == null) {
                return;
            }
        } else if (ConvertNaNEqualityInspectionKt.access$isNaNExpression(element3.getRight())) {
            ktExpression = element3.getLeft();
            if (ktExpression == null) {
                return;
            }
        } else {
            return;
        }
        KtExpression other = ktExpression;
        String pattern2 = this.inverted ? "!$0.isNaN()" : "$0.isNaN()";
        Object[] objectArray = new Object[]{other};
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory((KtElement)element3, false, 2, null), (String)pattern2, (Object[])objectArray, (boolean)false, (int)4, null));
    }
}

