/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupportKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006!"}, d2={"KOTLIN_SUPPORT_ID", "", "getKOTLIN_SUPPORT_ID", "()Ljava/lang/String;", "addInjectionInstructionInCode", "", "language", "Lcom/intellij/lang/Language;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "canInjectWithAnnotation", "Lcom/intellij/psi/PsiElement;", "checkIsValidPlaceForInjectionWithLineComment", "statement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtElement;", "extractLanguageFromInjectAnnotation", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "extractStringArgumentByName", "name", "extractStringValue", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "findAnnotationInjection", "findElementToInjectWithAnnotation", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "findElementToInjectWithComment", "prevWalker", "", "element", "scope", "firstNonCommentChild", "kotlin.injection"})
public final class KotlinLanguageInjectionSupportKt {
    @NonNls
    @NotNull
    private static final String KOTLIN_SUPPORT_ID = "kotlin";

    @NotNull
    public static final String getKOTLIN_SUPPORT_ID() {
        return KOTLIN_SUPPORT_ID;
    }

    private static final String extractStringArgumentByName(KtAnnotationEntry annotationEntry2, String name2) {
        Object v1;
        block2: {
            Iterable $this$firstOrNull$iv = annotationEntry2.getValueArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                boolean bl = false;
                ValueArgumentName valueArgumentName = it.getArgumentName();
                if (!Intrinsics.areEqual((Object)(valueArgumentName != null && (valueArgumentName = valueArgumentName.getAsName()) != null ? valueArgumentName.asString() : null), (Object)name2)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        ValueArgument valueArgument = v1;
        if (valueArgument == null) {
            return null;
        }
        ValueArgument namedArgument = valueArgument;
        return KotlinLanguageInjectionSupportKt.extractStringValue(namedArgument);
    }

    private static final String extractLanguageFromInjectAnnotation(KtAnnotationEntry annotationEntry2) {
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)annotationEntry2.getValueArguments());
        if (valueArgument == null) {
            return null;
        }
        ValueArgument firstArgument2 = valueArgument;
        return KotlinLanguageInjectionSupportKt.extractStringValue(firstArgument2);
    }

    private static final String extractStringValue(ValueArgument valueArgument) {
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        KtStringTemplateExpression ktStringTemplateExpression = ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression firstStringArgument = ktStringTemplateExpression;
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])firstStringArgument.getEntries());
        if (ktStringTemplateEntry == null) {
            return null;
        }
        KtStringTemplateEntry firstStringEntry = ktStringTemplateEntry;
        return firstStringEntry.getText();
    }

    private static final KtAnnotationEntry findAnnotationInjection(KtElement host) {
        KtModifierListOwner ktModifierListOwner = KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(host);
        if (ktModifierListOwner == null) {
            return null;
        }
        KtModifierListOwner modifierListOwner = ktModifierListOwner;
        KtModifierList ktModifierList = modifierListOwner.getModifierList();
        if (ktModifierList == null) {
            return null;
        }
        KtModifierList modifierList = ktModifierList;
        if (PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)host)) < PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)modifierList))) {
            return null;
        }
        return ModifierListModifactorKt.findAnnotation((KtAnnotated)modifierListOwner, new FqName("org.intellij.lang.annotations.Language"));
    }

    private static final boolean canInjectWithAnnotation(PsiElement host) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module2 == null) {
            return false;
        }
        Module module3 = module2;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module3.getProject());
        return javaPsiFacade.findClass("org.intellij.lang.annotations.Language", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module3)) != null;
    }

    private static final KtModifierListOwner findElementToInjectWithAnnotation(KtElement host) {
        Class[] classArray = new Class[]{KtBlockExpression.class, KtParameterList.class, KtTypeParameterList.class};
        return (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtModifierListOwner.class, (boolean)false, (Class[])classArray);
    }

    private static final KtExpression findElementToInjectWithComment(KtElement host) {
        Object v1;
        block2: {
            Class[] classArray = new Class[]{KtDeclaration.class};
            KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtBlockExpression.class, (boolean)true, (Class[])classArray);
            if (ktBlockExpression == null) {
                return null;
            }
            KtBlockExpression parentBlockExpression = ktBlockExpression;
            Iterable $this$firstOrNull$iv = parentBlockExpression.getStatements();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtExpression statement2 = (KtExpression)element$iv;
                boolean bl = false;
                if (!(PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statement2), (PsiElement)((PsiElement)host), (boolean)false) && KotlinLanguageInjectionSupportKt.checkIsValidPlaceForInjectionWithLineComment(statement2, host))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private static final boolean addInjectionInstructionInCode(Language language, PsiLanguageInjectionHost host) {
        KtElement ktElement = host instanceof KtElement ? (KtElement)host : null;
        if (ktElement == null) {
            return false;
        }
        KtElement ktHost = ktElement;
        Project project = ktHost.getProject();
        KtModifierListOwner modifierListOwner = KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(ktHost);
        if (modifierListOwner != null && KotlinLanguageInjectionSupportKt.canInjectWithAnnotation((PsiElement)ktHost)) {
            ApplicationUtilsKt.executeWriteCommand(project, KotlinJvmBundle.message("command.action.add.injection.annotation", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(modifierListOwner, language){
                final /* synthetic */ KtModifierListOwner $modifierListOwner;
                final /* synthetic */ Language $language;
                {
                    this.$modifierListOwner = $modifierListOwner;
                    this.$language = $language;
                    super(0);
                }

                public final void invoke() {
                    ModifierListModifactorKt.addAnnotation$default(this.$modifierListOwner, new FqName("org.intellij.lang.annotations.Language"), "\"" + this.$language.getID() + "\"", null, null, 12, null);
                }
            }));
            return true;
        }
        KtModifierListOwner ktModifierListOwner = modifierListOwner;
        if (ktModifierListOwner == null || (ktModifierListOwner = KotlinLanguageInjectionSupportKt.firstNonCommentChild((PsiElement)ktModifierListOwner)) == null) {
            KtExpression ktExpression = KotlinLanguageInjectionSupportKt.findElementToInjectWithComment(ktHost);
            if (ktExpression != null) {
                ktModifierListOwner = (PsiElement)ktExpression;
            } else {
                return false;
            }
        }
        KtModifierListOwner commentBeforeAnchor = ktModifierListOwner;
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        PsiComment injectComment = psiFactory.createComment("//language=" + language.getID());
        ApplicationUtilsKt.executeWriteCommand(project, KotlinJvmBundle.message("command.action.add.injection.comment", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>((PsiElement)commentBeforeAnchor, injectComment){
            final /* synthetic */ PsiElement $commentBeforeAnchor;
            final /* synthetic */ PsiComment $injectComment;
            {
                this.$commentBeforeAnchor = $commentBeforeAnchor;
                this.$injectComment = $injectComment;
                super(0);
            }

            public final void invoke() {
                this.$commentBeforeAnchor.getParent().addBefore((PsiElement)this.$injectComment, this.$commentBeforeAnchor);
            }
        }));
        return true;
    }

    private static final boolean checkIsValidPlaceForInjectionWithLineComment(KtExpression statement2, KtElement host) {
        int statementStartOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)statement2));
        int hostStart = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)host));
        if (hostStart < statementStartOffset || hostStart - statementStartOffset > 120) {
            return false;
        }
        if (hostStart - statementStartOffset > 2) {
            boolean bl;
            block4: {
                Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)SequencesKt.asSequence(KotlinLanguageInjectionSupportKt.prevWalker((PsiElement)host, (PsiElement)statement2)), (Function1)checkIsValidPlaceForInjectionWithLineComment.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PsiLanguageInjectionHost && ((PsiLanguageInjectionHost)it).isValidHost() && !StringUtil.isEmptyOrSpaces((String)((PsiLanguageInjectionHost)it).getText()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    private static final PsiElement firstNonCommentChild(PsiElement $this$firstNonCommentChild) {
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)$this$firstNonCommentChild.getFirstChild(), (boolean)false, (boolean)false, (int)3, null), (Function1)firstNonCommentChild.1.INSTANCE));
    }

    private static final Iterator<PsiElement> prevWalker(PsiElement element3, PsiElement scope2) {
        return new Iterator<PsiElement>(element3, scope2){
            @Nullable
            private PsiElement e;
            final /* synthetic */ PsiElement $scope;
            {
                this.$scope = $scope;
                this.e = $element;
            }

            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public PsiElement next() {
                void var3_3;
                PsiElement parent2;
                PsiElement current = this.e;
                if (current == null || current == this.$scope) {
                    return null;
                }
                PsiElement prev2 = current.getPrevSibling();
                this.e = prev2 != null ? PsiTreeUtil.getDeepestLast((PsiElement)prev2) : ((parent2 = current.getParent()) == this.$scope || parent2 instanceof PsiFile ? null : var3_3);
                return this.e;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public static final /* synthetic */ boolean access$addInjectionInstructionInCode(Language language, PsiLanguageInjectionHost host) {
        return KotlinLanguageInjectionSupportKt.addInjectionInstructionInCode(language, host);
    }

    public static final /* synthetic */ KtAnnotationEntry access$findAnnotationInjection(KtElement host) {
        return KotlinLanguageInjectionSupportKt.findAnnotationInjection(host);
    }

    public static final /* synthetic */ String access$extractLanguageFromInjectAnnotation(KtAnnotationEntry annotationEntry2) {
        return KotlinLanguageInjectionSupportKt.extractLanguageFromInjectAnnotation(annotationEntry2);
    }

    public static final /* synthetic */ String access$extractStringArgumentByName(KtAnnotationEntry annotationEntry2, String name2) {
        return KotlinLanguageInjectionSupportKt.extractStringArgumentByName(annotationEntry2, name2);
    }
}

