/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizerKt;
import org.jetbrains.kotlin.idea.imports.OptimizedImportsBuilder;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.references.fe10.Fe10SyntheticPropertyAccessorReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\fH\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer;", "Lcom/intellij/lang/ImportOptimizer;", "()V", "isDocumentUncommitted", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "prepareImports", "Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeInformation;", "file", "processFile", "Lcom/intellij/lang/ImportOptimizer$CollectingInfoRunnable;", "Lcom/intellij/psi/PsiFile;", "supports", "CollectUsedDescriptorsVisitor", "Companion", "OptimizeInformation", "kotlin.idea"})
public final class KotlinImportOptimizer
implements ImportOptimizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Companion.DO_NOTHING.1 DO_NOTHING = new ImportOptimizer.CollectingInfoRunnable(){

        public void run() {
        }

        @NotNull
        public String getUserNotificationInfo() {
            return KotlinBundle.message("import.optimizer.notification.text.unused.imports.not.found", new Object[0]);
        }
    };

    public boolean supports(@NotNull PsiFile file2) {
        return file2 instanceof KtFile;
    }

    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(@NotNull PsiFile file2) {
        KtFile ktFile = file2 instanceof KtFile ? (KtFile)file2 : null;
        if (ktFile == null) {
            return DO_NOTHING;
        }
        KtFile ktFile2 = ktFile;
        OptimizeInformation optimizeInformation = this.prepareImports(ktFile2);
        if (optimizeInformation == null) {
            return DO_NOTHING;
        }
        OptimizeInformation optimizeInformation2 = optimizeInformation;
        int add2 = optimizeInformation2.component1();
        int remove2 = optimizeInformation2.component2();
        List<ImportPath> imports2 = optimizeInformation2.component3();
        return new ImportOptimizer.CollectingInfoRunnable(remove2, add2, ktFile2, imports2){
            final /* synthetic */ int $remove;
            final /* synthetic */ int $add;
            final /* synthetic */ KtFile $ktFile;
            final /* synthetic */ List<ImportPath> $imports;
            {
                this.$remove = $remove;
                this.$add = $add;
                this.$ktFile = $ktFile;
                this.$imports = $imports;
            }

            @NotNull
            public String getUserNotificationInfo() {
                String string2;
                if (this.$remove == 0) {
                    string2 = KotlinBundle.message("import.optimizer.text.zero", new Object[0]);
                } else {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = this.$remove;
                    Object[] objectArray2 = new Object[]{this.$remove};
                    objectArray[1] = KotlinBundle.message("import.optimizer.text.import", objectArray2);
                    objectArray[2] = this.$add;
                    objectArray2 = new Object[]{this.$add};
                    objectArray[3] = KotlinBundle.message("import.optimizer.text.import", objectArray2);
                    string2 = KotlinBundle.message("import.optimizer.text.non.zero", objectArray);
                }
                return string2;
            }

            public void run() {
                KotlinImportOptimizer.Companion.replaceImports(this.$ktFile, this.$imports);
            }
        };
    }

    private final boolean isDocumentUncommitted(KtFile $this$isDocumentUncommitted) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$this$isDocumentUncommitted.getProject());
        Document cachedDocument = documentManager.getCachedDocument((PsiFile)$this$isDocumentUncommitted);
        return cachedDocument != null && documentManager.isUncommited(cachedDocument);
    }

    /*
     * WARNING - void declaration
     */
    private final OptimizeInformation prepareImports(KtFile file2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.isDocumentUncommitted(file2)) {
            return null;
        }
        IdeaModuleInfo moduleInfo = ModuleInfoProviderUtils.getModuleInfoOrNull((PsiElement)file2);
        if (!(moduleInfo instanceof ModuleSourceInfo) && !(moduleInfo instanceof ScriptModuleInfo)) {
            return null;
        }
        List oldImports = file2.getImportDirectives();
        if (oldImports.isEmpty()) {
            return null;
        }
        OptimizedImportsBuilder.InputData descriptorsToImport = Companion.collectDescriptorsToImport(file2, true);
        List<ImportPath> list2 = Companion.prepareOptimizedImports(file2, descriptorsToImport);
        if (list2 == null) {
            return null;
        }
        List<ImportPath> imports2 = list2;
        Iterable iterable = oldImports;
        Iterable iterable2 = imports2;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getImportPath());
        }
        Set intersect = CollectionsKt.intersect((Iterable)iterable2, (Iterable)((List)destination$iv$iv));
        return new OptimizeInformation(imports2.size() - intersect.size(), oldImports.size() - intersect.size(), imports2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$OptimizeInformation;", "", "add", "", "remove", "imports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "(IILjava/util/List;)V", "getAdd", "()I", "getImports", "()Ljava/util/List;", "getRemove", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.idea"})
    private static final class OptimizeInformation {
        private final int add;
        private final int remove;
        @NotNull
        private final List<ImportPath> imports;

        public OptimizeInformation(int add2, int remove2, @NotNull List<ImportPath> imports2) {
            this.add = add2;
            this.remove = remove2;
            this.imports = imports2;
        }

        public final int getAdd() {
            return this.add;
        }

        public final int getRemove() {
            return this.remove;
        }

        @NotNull
        public final List<ImportPath> getImports() {
            return this.imports;
        }

        public final int component1() {
            return this.add;
        }

        public final int component2() {
            return this.remove;
        }

        @NotNull
        public final List<ImportPath> component3() {
            return this.imports;
        }

        @NotNull
        public final OptimizeInformation copy(int add2, int remove2, @NotNull List<ImportPath> imports2) {
            return new OptimizeInformation(add2, remove2, imports2);
        }

        public static /* synthetic */ OptimizeInformation copy$default(OptimizeInformation optimizeInformation, int n, int n2, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = optimizeInformation.add;
            }
            if ((n3 & 2) != 0) {
                n2 = optimizeInformation.remove;
            }
            if ((n3 & 4) != 0) {
                list2 = optimizeInformation.imports;
            }
            return optimizeInformation.copy(n, n2, list2);
        }

        @NotNull
        public String toString() {
            return "OptimizeInformation(add=" + this.add + ", remove=" + this.remove + ", imports=" + this.imports + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.add);
            result2 = result2 * 31 + Integer.hashCode(this.remove);
            result2 = result2 * 31 + ((Object)this.imports).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptimizeInformation)) {
                return false;
            }
            OptimizeInformation optimizeInformation = (OptimizeInformation)other;
            if (this.add != optimizeInformation.add) {
                return false;
            }
            if (this.remove != optimizeInformation.remove) {
                return false;
            }
            return Intrinsics.areEqual(this.imports, optimizeInformation.imports);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020'H\u0016J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u001b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001d0\u001cj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0016j\b\u0012\u0004\u0012\u00020\u000f`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "abstractRefs", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "Lkotlin/collections/ArrayList;", "aliases", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "currentPackageName", "data", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "getData", "()Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "descriptorsToImport", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportableDescriptor;", "Lkotlin/collections/HashSet;", "elementProgress", "", "namesToImport", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "unresolvedNames", "isAccessibleAsMember", "", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "place", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "visitKtElement", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "AbstractReferenceImpl", "kotlin.idea"})
    private static final class CollectUsedDescriptorsVisitor
    extends KtVisitorVoid {
        @Nullable
        private final ProgressIndicator progressIndicator;
        private int elementProgress;
        @NotNull
        private final FqName currentPackageName;
        @NotNull
        private final Map<FqName, List<Name>> aliases;
        @NotNull
        private final HashSet<OptimizedImportsBuilder.ImportableDescriptor> descriptorsToImport;
        @NotNull
        private final HashMap<FqName, Set<Name>> namesToImport;
        @NotNull
        private final ArrayList<OptimizedImportsBuilder.AbstractReference> abstractRefs;
        @NotNull
        private final HashSet<Name> unresolvedNames;

        /*
         * WARNING - void declaration
         */
        public CollectUsedDescriptorsVisitor(@NotNull KtFile file2, @Nullable ProgressIndicator progressIndicator) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            this.progressIndicator = progressIndicator;
            this.currentPackageName = file2.getPackageFqName();
            Sequence sequence2 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)file2.getImportDirectives()), (Function1)aliases.1.INSTANCE), (Function1)aliases.2.INSTANCE);
            CollectUsedDescriptorsVisitor collectUsedDescriptorsVisitor = this;
            boolean $i$f$groupBy = false;
            void var5_6 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                ImportPath it2 = (ImportPath)element$iv$iv;
                boolean $i$a$-groupBy-KotlinImportOptimizer$CollectUsedDescriptorsVisitor$aliases$52 = false;
                FqName key$iv$iv = it2.getFqName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                ImportPath $i$a$-groupBy-KotlinImportOptimizer$CollectUsedDescriptorsVisitor$aliases$52 = (ImportPath)element$iv$iv;
                List list2 = list$iv$iv;
                boolean bl = false;
                Name name2 = it.getImportedName();
                Intrinsics.checkNotNull((Object)name2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.name.Name");
                list2.add(name2);
            }
            collectUsedDescriptorsVisitor.aliases = destination$iv$iv;
            this.descriptorsToImport = new HashSet();
            this.namesToImport = new HashMap();
            this.abstractRefs = new ArrayList();
            this.unresolvedNames = new HashSet();
        }

        public /* synthetic */ CollectUsedDescriptorsVisitor(KtFile ktFile, ProgressIndicator progressIndicator, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                progressIndicator = null;
            }
            this(ktFile, progressIndicator);
        }

        @Nullable
        public final ProgressIndicator getProgressIndicator() {
            return this.progressIndicator;
        }

        @NotNull
        public final OptimizedImportsBuilder.InputData getData() {
            return new OptimizedImportsBuilder.InputData((Set<OptimizedImportsBuilder.ImportableDescriptor>)this.descriptorsToImport, (Map<FqName, ? extends Set<Name>>)this.namesToImport, (Collection<? extends OptimizedImportsBuilder.AbstractReference>)this.abstractRefs, (Set<Name>)this.unresolvedNames);
        }

        public void visitElement(@NotNull PsiElement element3) {
            ProgressIndicatorProvider.checkCanceled();
            ++this.elementProgress;
            element3.acceptChildren((PsiElementVisitor)this);
        }

        public void visitImportList(@NotNull KtImportList importList) {
        }

        public void visitPackageDirective(@NotNull KtPackageDirective directive) {
        }

        public void visitKtElement(@NotNull KtElement element3) {
            super.visitKtElement(element3);
            if (element3 instanceof KtLabelReferenceExpression) {
                return;
            }
            PsiReference[] psiReferenceArray = element3.getReferences();
            if (psiReferenceArray.length == 0) {
                boolean bl = false;
                return;
            }
            PsiReference[] references2 = psiReferenceArray;
            BindingContext bindingContext2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode(element3, BodyResolveMode.PARTIAL);
            boolean isResolved = KotlinImportOptimizerKt.access$hasResolvedDescriptor(element3, bindingContext2);
            for (PsiReference reference2 : references2) {
                if (!(reference2 instanceof KtReference)) continue;
                ProgressIndicatorProvider.checkCanceled();
                this.abstractRefs.add(new AbstractReferenceImpl((KtReference)reference2));
                Collection names2 = ((KtReference)reference2).getResolvesByNames();
                if (!isResolved) {
                    CollectionsKt.addAll((Collection)this.unresolvedNames, (Iterable)names2);
                }
                for (DeclarationDescriptor target2 : Companion.targets((KtReference)reference2, bindingContext2)) {
                    Object object;
                    FqName importableFqName;
                    DeclarationDescriptor importableDescriptor = DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)target2);
                    if (ImportsUtils.getImportableFqName(target2) == null) continue;
                    FqName parentFqName = importableFqName.parent();
                    if (target2 instanceof PackageViewDescriptor && Intrinsics.areEqual((Object)parentFqName, (Object)FqName.ROOT) || !(target2 instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)parentFqName, (Object)this.currentPackageName) && !this.aliases.containsKey(importableFqName) || !ReferenceUtilKt.canBeResolvedViaImport((KtReference)reference2, target2, bindingContext2) || names2.contains(importableDescriptor.getName()) && this.isAccessibleAsMember(importableDescriptor, element3, bindingContext2)) continue;
                    List list2 = this.aliases.get(importableFqName);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    Set descriptorNames = CollectionsKt.intersect((Iterable)CollectionsKt.plus((Collection)list2, (Object)importableFqName.shortName()), (Iterable)names2);
                    Map $this$getOrPut$iv = this.namesToImport;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(importableFqName);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new HashSet();
                        $this$getOrPut$iv.put(importableFqName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    CollectionsKt.addAll((Collection)((Collection)object), (Iterable)descriptorNames);
                    ((Collection)this.descriptorsToImport).add(new OptimizedImportsBuilder.ImportableDescriptor(importableDescriptor, importableFqName));
                }
            }
        }

        private final boolean isAccessibleAsMember(DeclarationDescriptor target2, KtElement place, BindingContext bindingContext2) {
            boolean bl;
            block7: {
                if (!(target2.getContainingDeclaration() instanceof ClassDescriptor)) {
                    return false;
                }
                LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)place, bindingContext2, ResolutionUtils.getResolutionFacade(place));
                LexicalScope noImportsScope = ScopeUtilsKt.replaceImportingScopes((LexicalScope)resolutionScope, null);
                if (CollectUsedDescriptorsVisitor.isAccessibleAsMember$isInScope(target2, bindingContext2, place, (HierarchicalScope)noImportsScope)) {
                    return true;
                }
                if (target2 instanceof ClassDescriptor) {
                    bl = false;
                } else {
                    Iterable $this$any$iv = ScopeUtilsKt.getImplicitReceiversHierarchy((LexicalScope)resolutionScope);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!CollectUsedDescriptorsVisitor.isAccessibleAsMember$isInScope(target2, bindingContext2, place, (HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default((MemberScope)it.getType().getMemberScope(), null, (int)1, null))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }

        private static final boolean isAccessibleAsMember$isInScope(DeclarationDescriptor $target, BindingContext $bindingContext, KtElement $place, HierarchicalScope scope2) {
            DeclarationDescriptor declarationDescriptor = $target;
            return declarationDescriptor instanceof FunctionDescriptor ? ScopeUtilsKt.findFunction((HierarchicalScope)scope2, (Name)((FunctionDescriptor)$target).getName(), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), (Function1)((Function1)new Function1<FunctionDescriptor, Boolean>($target){
                final /* synthetic */ DeclarationDescriptor $target;
                {
                    this.$target = $target;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FunctionDescriptor it) {
                    return Intrinsics.areEqual((Object)it, (Object)this.$target);
                }
            })) != null && !Intrinsics.areEqual((Object)$bindingContext.get((ReadOnlySlice)BindingContext.DEPRECATED_SHORT_NAME_ACCESS, (Object)$place), (Object)true) : (declarationDescriptor instanceof PropertyDescriptor ? ScopeUtilsKt.findVariable((HierarchicalScope)scope2, (Name)((PropertyDescriptor)$target).getName(), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), (Function1)((Function1)new Function1<VariableDescriptor, Boolean>($target){
                final /* synthetic */ DeclarationDescriptor $target;
                {
                    this.$target = $target;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull VariableDescriptor it) {
                    return Intrinsics.areEqual((Object)it, (Object)this.$target);
                }
            })) != null && !Intrinsics.areEqual((Object)$bindingContext.get((ReadOnlySlice)BindingContext.DEPRECATED_SHORT_NAME_ACCESS, (Object)$place), (Object)true) : (declarationDescriptor instanceof ClassDescriptor ? Intrinsics.areEqual((Object)ScopeUtilsKt.findClassifier((HierarchicalScope)scope2, (Name)((ClassDescriptor)$target).getName(), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)), (Object)$target) && !Intrinsics.areEqual((Object)$bindingContext.get((ReadOnlySlice)BindingContext.DEPRECATED_SHORT_NAME_ACCESS, (Object)$place), (Object)true) : false));
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$CollectUsedDescriptorsVisitor$AbstractReferenceImpl;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "reference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "(Lorg/jetbrains/kotlin/idea/references/KtReference;)V", "dependsOnNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getDependsOnNames", "()Ljava/util/Collection;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "resolve", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "toString", "", "kotlin.idea"})
        private static final class AbstractReferenceImpl
        implements OptimizedImportsBuilder.AbstractReference {
            @NotNull
            private final KtReference reference;

            public AbstractReferenceImpl(@NotNull KtReference reference2) {
                this.reference = reference2;
            }

            @Override
            @NotNull
            public KtElement getElement() {
                return this.reference.getElement();
            }

            @Override
            @NotNull
            public Collection<Name> getDependsOnNames() {
                Collection resolvesByNames = this.reference.getResolvesByNames();
                if (this.reference instanceof KtInvokeFunctionReference) {
                    Collection additionalNames;
                    KtExpression ktExpression = ((KtCallExpression)((KtInvokeFunctionReference)this.reference).getElement()).getCalleeExpression();
                    KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
                    Collection collection = ktNameReferenceExpression != null && (ktNameReferenceExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)ktNameReferenceExpression))) != null ? ktNameReferenceExpression.getResolvesByNames() : (additionalNames = null);
                    if (additionalNames != null) {
                        return CollectionsKt.plus((Collection)resolvesByNames, (Iterable)additionalNames);
                    }
                }
                return resolvesByNames;
            }

            @Override
            @NotNull
            public Collection<DeclarationDescriptor> resolve(@NotNull BindingContext bindingContext2) {
                return KtReferenceKt.resolveToDescriptors(this.reference, bindingContext2);
            }

            @NotNull
            public String toString() {
                return this.reference instanceof Fe10SyntheticPropertyAccessorReference ? StringsKt.replace$default((String)this.reference.toString(), (String)"Fe10SyntheticPropertyAccessorReference", (String)(((Fe10SyntheticPropertyAccessorReference)this.reference).getGetter() ? "Getter" : "Setter"), (boolean)false, (int)4, null) : StringsKt.replace$default((String)this.reference.toString(), (String)"Fe10", (String)"", (boolean)false, (int)4, null);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion;", "", "()V", "DO_NOTHING", "org/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion$DO_NOTHING$1", "Lorg/jetbrains/kotlin/idea/imports/KotlinImportOptimizer$Companion$DO_NOTHING$1;", "collectDescriptorsToImport", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "inProgressBar", "", "prepareOptimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "data", "replaceImports", "", "imports", "targets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OptimizedImportsBuilder.InputData collectDescriptorsToImport(@NotNull KtFile file2, boolean inProgressBar) {
            ProgressIndicator progressIndicator;
            ProgressIndicator progressIndicator2 = progressIndicator = inProgressBar ? ProgressIndicatorProvider.getInstance().getProgressIndicator() : null;
            if (progressIndicator2 != null) {
                Object[] objectArray = new Object[]{file2.getName()};
                progressIndicator2.setText(KotlinBundle.message("import.optimizer.progress.indicator.text.collect.imports.for", objectArray));
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setIndeterminate(false);
            }
            CollectUsedDescriptorsVisitor visitor2 = new CollectUsedDescriptorsVisitor(file2, progressIndicator);
            file2.accept((PsiElementVisitor)visitor2);
            return visitor2.getData();
        }

        public static /* synthetic */ OptimizedImportsBuilder.InputData collectDescriptorsToImport$default(Companion companion, KtFile ktFile, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.collectDescriptorsToImport(ktFile, bl);
        }

        @Nullable
        public final List<ImportPath> prepareOptimizedImports(@NotNull KtFile file2, @NotNull OptimizedImportsBuilder.InputData data2) {
            KotlinCodeStyleSettings settings2 = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)file2);
            OptimizedImportsBuilder.Options options2 = new OptimizedImportsBuilder.Options(settings2.NAME_COUNT_TO_USE_STAR_IMPORT, settings2.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS, (Function1<? super FqName, Boolean>)((Function1)new Function1<FqName, Boolean>(settings2){
                final /* synthetic */ KotlinCodeStyleSettings $settings;
                {
                    this.$settings = $settings;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FqName fqName2) {
                    return this.$settings.PACKAGES_TO_USE_STAR_IMPORTS.contains(fqName2.asString());
                }
            }));
            return new OptimizedImportsBuilder(file2, data2, options2, LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)file2).getApiVersion()).buildOptimizedImports();
        }

        public final void replaceImports(@NotNull KtFile file2, @NotNull List<ImportPath> imports2) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
            Document document = manager.getDocument((PsiFile)file2);
            if (document != null) {
                Document it = document;
                boolean bl = false;
                manager.commitDocument(it);
            }
            KtImportList ktImportList = file2.getImportList();
            if (ktImportList == null) {
                return;
            }
            KtImportList importList = ktImportList;
            List oldImports = importList.getImports();
            KtPsiFactory psiFactory = new KtPsiFactory(file2.getProject(), false, 2, null);
            for (ImportPath importPath : imports2) {
                importList.addBefore((PsiElement)psiFactory.createImportDirective(importPath), (PsiElement)CollectionsKt.lastOrNull((List)oldImports));
            }
            for (KtImportDirective ktImportDirective : oldImports) {
                ktImportDirective.delete();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final Collection<DeclarationDescriptor> targets(KtReference $this$targets, BindingContext bindingContext2) {
            Collection collection;
            KtElement ktElement = $this$targets.getElement();
            Object object = (ClassifierDescriptorWithTypeParameters)bindingContext2.get((ReadOnlySlice)BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, (Object)(ktElement instanceof KtReferenceExpression ? (KtReferenceExpression)ktElement : null));
            if (object != null) {
                ClassifierDescriptorWithTypeParameters it = object;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)it);
                object = list2;
                if (list2 != null) {
                    collection = (Collection)object;
                    return collection;
                }
            }
            collection = KtReferenceKt.resolveToDescriptors($this$targets, bindingContext2);
            return collection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

