/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.highlighters;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtBackingFieldSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtKotlinPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtLocalVariableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinNameHighlightingStateUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighting.highlighters.AfterResolveHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.VariableReferenceHighlighterKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J$\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0011H\u0002\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/VariableReferenceHighlighter;", "Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lcom/intellij/openapi/project/Project;)V", "highlight", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "highlightBackingField", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtBackingFieldSymbol;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtBackingFieldSymbol;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "highlightProperty", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtKotlinPropertySymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtKotlinPropertySymbol;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "highlightSimpleNameExpression", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "highlightValueParameter", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtValueParameterSymbol;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "isByNameArgumentReference", "", "kotlin.highlighting"})
public final class VariableReferenceHighlighter
extends AfterResolveHighlighter {
    public VariableReferenceHighlighter(@NotNull AnnotationHolder holder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(holder, project);
    }

    @Override
    public void highlight(@NotNull KtAnalysisSession ktAnalysisSession, @NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)ktAnalysisSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtSimpleNameExpression) {
            this.highlightSimpleNameExpression(ktAnalysisSession, (KtSimpleNameExpression)element3);
        }
    }

    private final void highlightSimpleNameExpression(KtAnalysisSession ktAnalysisSession, KtSimpleNameExpression expression2) {
        Project project = expression2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
        if (!KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(project)) {
            return;
        }
        if (VariableReferenceHighlighterKt.access$isAssignmentReference(expression2)) {
            return;
        }
        if (this.isByNameArgumentReference(expression2)) {
            return;
        }
        if (expression2.getParent() instanceof KtInstanceExpressionWithLabel) {
            return;
        }
        KtSymbol symbol2 = ktAnalysisSession.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)expression2));
        if (symbol2 instanceof KtBackingFieldSymbol) {
            this.highlightBackingField(ktAnalysisSession, (KtBackingFieldSymbol)symbol2, expression2);
        } else if (symbol2 instanceof KtKotlinPropertySymbol) {
            this.highlightProperty(ktAnalysisSession, (KtKotlinPropertySymbol)symbol2, expression2);
        } else if (symbol2 instanceof KtLocalVariableSymbol) {
            if (!((KtLocalVariableSymbol)symbol2).isVal()) {
                AfterResolveHighlighter afterResolveHighlighter = this;
                PsiElement psiElement2 = (PsiElement)expression2;
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
                AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement2, textAttributesKey, null, 4, null);
            }
            AfterResolveHighlighter afterResolveHighlighter = this;
            PsiElement psiElement3 = (PsiElement)expression2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.LOCAL_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"LOCAL_VARIABLE");
            AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement3, textAttributesKey, null, 4, null);
        } else if (symbol2 instanceof KtSyntheticJavaPropertySymbol) {
            AfterResolveHighlighter afterResolveHighlighter = this;
            PsiElement psiElement4 = (PsiElement)expression2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.SYNTHETIC_EXTENSION_PROPERTY;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SYNTHETIC_EXTENSION_PROPERTY");
            AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement4, textAttributesKey, null, 4, null);
        } else if (symbol2 instanceof KtValueParameterSymbol) {
            this.highlightValueParameter(ktAnalysisSession, (KtValueParameterSymbol)symbol2, expression2);
        } else if (symbol2 instanceof KtEnumEntrySymbol) {
            AfterResolveHighlighter afterResolveHighlighter = this;
            PsiElement psiElement5 = (PsiElement)expression2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.ENUM_ENTRY;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"ENUM_ENTRY");
            AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement5, textAttributesKey, null, 4, null);
        }
    }

    private final void highlightValueParameter(KtAnalysisSession ktAnalysisSession, KtValueParameterSymbol symbol2, KtSimpleNameExpression expression2) {
        if (symbol2.isImplicitLambdaParameter()) {
            PsiElement psiElement2 = (PsiElement)expression2;
            String string2 = KotlinBaseHighlightingBundle.message("automatically.declared.based.on.the.expected.type", new Object[0]);
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"FUNCTION_LITERAL_DEFAULT_PARAMETER");
            this.createInfoAnnotation(psiElement2, string2, textAttributesKey);
        } else {
            AfterResolveHighlighter afterResolveHighlighter = this;
            PsiElement psiElement3 = (PsiElement)expression2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PARAMETER");
            AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement3, textAttributesKey, null, 4, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void highlightProperty(KtAnalysisSession <this>, KtKotlinPropertySymbol symbol, KtSimpleNameExpression expression) {
        if (!symbol.isVal()) {
            v0 = this;
            v1 = (PsiElement)expression;
            v2 = KotlinHighlightingColors.MUTABLE_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"MUTABLE_VARIABLE");
            AfterResolveHighlighter.highlightName$default(v0, v1, v2, null, 4, null);
        }
        v3 = symbol.getGetter();
        if (v3 != null ? v3.getHasBody() : false) ** GOTO lbl-1000
        v4 = symbol.getSetter();
        v5 = v4 != null ? v4.getHasBody() : false;
        if (v5) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = false;
        }
        hasExplicitGetterOrSetter = v6;
        color = symbol.isExtension() ? KotlinHighlightingColors.EXTENSION_PROPERTY : (symbol.getSymbolKind() == KtSymbolKind.TOP_LEVEL ? (hasExplicitGetterOrSetter ? KotlinHighlightingColors.PACKAGE_PROPERTY_CUSTOM_PROPERTY_DECLARATION : KotlinHighlightingColors.PACKAGE_PROPERTY) : (hasExplicitGetterOrSetter != false ? KotlinHighlightingColors.INSTANCE_PROPERTY_CUSTOM_PROPERTY_DECLARATION : KotlinHighlightingColors.INSTANCE_PROPERTY));
        v7 = this;
        v8 = (PsiElement)expression;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
        AfterResolveHighlighter.highlightName$default(v7, v8, color, null, 4, null);
    }

    private final void highlightBackingField(KtAnalysisSession ktAnalysisSession, KtBackingFieldSymbol symbol2, KtSimpleNameExpression expression2) {
        if (!symbol2.getOwningProperty().isVal()) {
            AfterResolveHighlighter afterResolveHighlighter = this;
            PsiElement psiElement2 = (PsiElement)expression2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
            AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement2, textAttributesKey, null, 4, null);
        }
        AfterResolveHighlighter afterResolveHighlighter = this;
        PsiElement psiElement3 = (PsiElement)expression2;
        TextAttributesKey textAttributesKey = KotlinHighlightingColors.BACKING_FIELD_VARIABLE;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"BACKING_FIELD_VARIABLE");
        AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, psiElement3, textAttributesKey, null, 4, null);
    }

    private final boolean isByNameArgumentReference(KtSimpleNameExpression $this$isByNameArgumentReference) {
        return $this$isByNameArgumentReference.getParent() instanceof KtValueArgumentName;
    }
}

