/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.highlighters;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtAnonymousObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeParameterSymbol;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinNameHighlightingStateUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighting.highlighters.AfterResolveHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.TypeHighlighterKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/TypeHighlighter;", "Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lcom/intellij/openapi/project/Project;)V", "highlight", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "highlightSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "isAnnotationCall", "", "target", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;)Z", "kotlin.highlighting"})
public final class TypeHighlighter
extends AfterResolveHighlighter {
    public TypeHighlighter(@NotNull AnnotationHolder holder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(holder, project);
    }

    @Override
    public void highlight(@NotNull KtAnalysisSession ktAnalysisSession, @NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)ktAnalysisSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtSimpleNameExpression) {
            this.highlightSimpleNameExpression(ktAnalysisSession, (KtSimpleNameExpression)element3);
        }
    }

    private final void highlightSimpleNameExpression(KtAnalysisSession ktAnalysisSession, KtSimpleNameExpression expression2) {
        TextAttributesKey textAttributesKey;
        block24: {
            KtSymbol ktSymbol;
            block25: {
                KtClassifierSymbol symbol2;
                block23: {
                    Project project = expression2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
                    if (!KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(project)) {
                        return;
                    }
                    if (TypeHighlighterKt.access$isCalleeExpression(expression2)) {
                        return;
                    }
                    PsiElement parent2 = expression2.getParent();
                    if (parent2 instanceof KtInstanceExpressionWithLabel) {
                        return;
                    }
                    if (TypeHighlighterKt.access$isConstructorCallReference(expression2)) {
                        return;
                    }
                    ktSymbol = ktAnalysisSession.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)expression2));
                    KtClassifierSymbol ktClassifierSymbol = ktSymbol instanceof KtClassifierSymbol ? (KtClassifierSymbol)ktSymbol : null;
                    if (ktClassifierSymbol == null) {
                        return;
                    }
                    symbol2 = ktClassifierSymbol;
                    if (this.isAnnotationCall(ktAnalysisSession, expression2, symbol2)) {
                        return;
                    }
                    ktSymbol = symbol2;
                    if (!(ktSymbol instanceof KtAnonymousObjectSymbol)) break block23;
                    textAttributesKey = KotlinHighlightingColors.CLASS;
                    break block24;
                }
                if (!(ktSymbol instanceof KtNamedClassOrObjectSymbol)) break block25;
                switch (WhenMappings.$EnumSwitchMapping$1[((KtNamedClassOrObjectSymbol)symbol2).getClassKind().ordinal()]) {
                    case 1: {
                        switch (WhenMappings.$EnumSwitchMapping$0[((KtNamedClassOrObjectSymbol)symbol2).getModality().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                textAttributesKey = KotlinHighlightingColors.CLASS;
                                break block24;
                            }
                            case 4: {
                                textAttributesKey = KotlinHighlightingColors.ABSTRACT_CLASS;
                                break block24;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 2: {
                        textAttributesKey = KotlinHighlightingColors.ENUM;
                        break block24;
                    }
                    case 3: {
                        textAttributesKey = KotlinHighlightingColors.ANNOTATION;
                        break block24;
                    }
                    case 4: {
                        textAttributesKey = KotlinHighlightingColors.OBJECT;
                        break block24;
                    }
                    case 5: {
                        textAttributesKey = KotlinHighlightingColors.OBJECT;
                        break block24;
                    }
                    case 6: {
                        textAttributesKey = KotlinHighlightingColors.TRAIT;
                        break block24;
                    }
                    case 7: {
                        textAttributesKey = KotlinHighlightingColors.CLASS;
                        break block24;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (ktSymbol instanceof KtTypeAliasSymbol) {
                textAttributesKey = KotlinHighlightingColors.TYPE_ALIAS;
            } else if (ktSymbol instanceof KtTypeParameterSymbol) {
                textAttributesKey = KotlinHighlightingColors.TYPE_PARAMETER;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        TextAttributesKey color = textAttributesKey;
        AfterResolveHighlighter afterResolveHighlighter = this;
        TextRange textRange = expression2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expression.textRange");
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
        AfterResolveHighlighter.highlightName$default(afterResolveHighlighter, textRange, color, null, 4, null);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isAnnotationCall(KtAnalysisSession <this>, KtSimpleNameExpression expression, KtSymbol target) {
        if (!(target instanceof KtConstructorSymbol) || !((KtConstructorSymbol)target).isPrimary()) ** GOTO lbl-1000
        var6_4 = <this>.getContainingSymbol(target);
        v0 = var6_4 instanceof KtClassOrObjectSymbol != false ? (KtClassOrObjectSymbol)var6_4 : null;
        if ((v0 != null ? v0.getClassKind() : null) == KtClassKind.ANNOTATION_CLASS) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = isKotlinAnnotation = false;
        }
        if (!isKotlinAnnotation) {
            targePsi = target.getPsi();
            v2 = targePsi instanceof KtClass != false ? ((KtClass)targePsi).isAnnotation() : (targetIsAnnotation = targePsi instanceof PsiClass != false ? ((PsiClass)targePsi).isAnnotationType() : false);
            if (!targetIsAnnotation) {
                return false;
            }
        }
        var6_4 = new Class[]{KtValueArgumentList.class};
        v3 = annotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression), KtAnnotationEntry.class, (boolean)false, (Class[])var6_4);
        return (v3 != null ? v3.getAtSymbol() : null) != null;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Modality.values().length];
            try {
                nArray[Modality.FINAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Modality.SEALED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Modality.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Modality.ABSTRACT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KtClassKind.values().length];
            try {
                nArray[KtClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.ENUM_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.ANNOTATION_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.COMPANION_OBJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.INTERFACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.ANONYMOUS_OBJECT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

