/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.highlighters;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCall;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.calls.KtSimpleFunctionCall;
import org.jetbrains.kotlin.analysis.api.calls.KtSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.symbols.KtAnonymousFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighting.highlighters.AfterResolveHighlighter;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0017H\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/FunctionCallHighlighter;", "Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lcom/intellij/openapi/project/Project;)V", "getTextAttributesForCall", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "call", "Lorg/jetbrains/kotlin/analysis/api/calls/KtCall;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/calls/KtCall;)Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlight", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "highlightBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "highlightCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "isAssignment", "", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Companion", "kotlin.highlighting"})
public final class FunctionCallHighlighter
extends AfterResolveHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID;

    public FunctionCallHighlighter(@NotNull AnnotationHolder holder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(holder, project);
    }

    @Override
    public void highlight(@NotNull KtAnalysisSession ktAnalysisSession, @NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)ktAnalysisSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtElement ktElement = element3;
        if (ktElement instanceof KtBinaryExpression) {
            this.highlightBinaryExpression(ktAnalysisSession, (KtBinaryExpression)element3);
        } else if (ktElement instanceof KtCallExpression) {
            this.highlightCallExpression(ktAnalysisSession, (KtCallExpression)element3);
        }
    }

    private final void highlightBinaryExpression(KtAnalysisSession ktAnalysisSession, KtBinaryExpression expression2) {
        block10: {
            KtLifetimeOwner ktLifetimeOwner;
            KtReferenceExpression operationReference;
            block9: {
                block8: {
                    KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                    KtReferenceExpression ktReferenceExpression = ktOperationReferenceExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktOperationReferenceExpression : null;
                    if (ktReferenceExpression == null) {
                        return;
                    }
                    operationReference = ktReferenceExpression;
                    if (this.isAssignment(operationReference)) {
                        return;
                    }
                    ktLifetimeOwner = ktAnalysisSession.resolveCall((KtElement)expression2);
                    if (ktLifetimeOwner == null) break block8;
                    KtCallInfo $this$successfulCallOrNull$iv = ktLifetimeOwner;
                    boolean $i$f$successfulCallOrNull = false;
                    KtSuccessCallInfo ktSuccessCallInfo = $this$successfulCallOrNull$iv instanceof KtSuccessCallInfo ? (KtSuccessCallInfo)$this$successfulCallOrNull$iv : null;
                    KtLifetimeOwner ktLifetimeOwner2 = ktSuccessCallInfo != null ? ktSuccessCallInfo.getCall() : null;
                    if (!(ktLifetimeOwner2 instanceof KtCall)) {
                        ktLifetimeOwner2 = ktLifetimeOwner = null;
                    }
                    if (ktLifetimeOwner2 != null) break block9;
                }
                return;
            }
            KtLifetimeOwner call = ktLifetimeOwner;
            if (call instanceof KtSimpleFunctionCall) {
                Object s = KtCallKt.getSymbol((KtCallableMemberCall)call);
                KtFunctionSymbol ktFunctionSymbol = s instanceof KtFunctionSymbol ? (KtFunctionSymbol)s : null;
                boolean bl = ktFunctionSymbol != null ? ktFunctionSymbol.isOperator() : false;
                if (bl) {
                    return;
                }
            }
            TextAttributesKey textAttributesKey = this.getTextAttributesForCall(ktAnalysisSession, (KtCall)call);
            if (textAttributesKey == null) break block10;
            TextAttributesKey attributes2 = textAttributesKey;
            boolean bl = false;
            AfterResolveHighlighter.highlightName$default((AfterResolveHighlighter)this, (PsiElement)operationReference, attributes2, null, 4, null);
        }
    }

    private final boolean isAssignment(KtReferenceExpression $this$isAssignment) {
        KtOperationReferenceExpression ktOperationReferenceExpression = $this$isAssignment instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)$this$isAssignment : null;
        return Intrinsics.areEqual((Object)(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null), (Object)KtTokens.EQ);
    }

    private final void highlightCallExpression(KtAnalysisSession ktAnalysisSession, KtCallExpression expression2) {
        block7: {
            KtExpression ktExpression;
            KtExpression ktExpression2;
            KtExpression ktExpression3 = expression2.getCalleeExpression();
            if (ktExpression3 == null) break block7;
            KtExpression it = ktExpression2 = ktExpression3;
            boolean bl = false;
            Object object = ktExpression = !(it instanceof KtLambdaExpression) ? ktExpression2 : null;
            if (ktExpression != null) {
                KtExpression ktExpression4;
                KtExpression it2 = ktExpression4 = ktExpression;
                boolean bl2 = false;
                Object object2 = ktExpression2 = !(it2 instanceof KtCallExpression) ? ktExpression4 : null;
                if (ktExpression2 != null) {
                    Object v2;
                    KtExpression callee2;
                    block6: {
                        callee2 = ktExpression2;
                        boolean bl3 = false;
                        KtCallInfo $this$singleCallOrNull$iv = ktAnalysisSession.resolveCall((KtCallElement)expression2);
                        boolean $i$f$singleCallOrNull = false;
                        Iterable $this$singleOrNull$iv$iv = KtCallKt.getCalls($this$singleCallOrNull$iv);
                        boolean $i$f$singleOrNull = false;
                        Object single$iv$iv = null;
                        boolean found$iv$iv = false;
                        for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                            KtCall it$iv = (KtCall)element$iv$iv;
                            boolean bl4 = false;
                            if (!(it$iv instanceof KtCall)) continue;
                            if (found$iv$iv) {
                                v2 = null;
                                break block6;
                            }
                            single$iv$iv = element$iv$iv;
                            found$iv$iv = true;
                        }
                        v2 = !found$iv$iv ? null : single$iv$iv;
                    }
                    KtCall ktCall = v2;
                    if (ktCall != null) {
                        KtCall call = ktCall;
                        boolean bl5 = false;
                        TextAttributesKey textAttributesKey = this.getTextAttributesForCall(ktAnalysisSession, call);
                        if (textAttributesKey != null) {
                            TextAttributesKey attributes2 = textAttributesKey;
                            boolean bl6 = false;
                            AfterResolveHighlighter.highlightName$default((AfterResolveHighlighter)this, (PsiElement)callee2, attributes2, null, 4, null);
                        }
                    }
                }
            }
        }
    }

    private final TextAttributesKey getTextAttributesForCall(KtAnalysisSession ktAnalysisSession, KtCall call) {
        if (!(call instanceof KtSimpleFunctionCall)) {
            return null;
        }
        KtFunctionLikeSymbol function2 = (KtFunctionLikeSymbol)KtCallKt.getSymbol((KtCallableMemberCall)call);
        return function2 instanceof KtConstructorSymbol ? KotlinHighlightingColors.CONSTRUCTOR_CALL : (function2 instanceof KtAnonymousFunctionSymbol ? null : (function2 instanceof KtFunctionSymbol ? (((KtFunctionSymbol)function2).isSuspend() ? KotlinHighlightingColors.SUSPEND_FUNCTION_CALL : (((KtSimpleFunctionCall)call).isImplicitInvoke() ? (((KtFunctionSymbol)function2).isBuiltinFunctionInvoke() ? KotlinHighlightingColors.VARIABLE_AS_FUNCTION_CALL : KotlinHighlightingColors.VARIABLE_AS_FUNCTION_LIKE_CALL) : (Intrinsics.areEqual((Object)function2.getCallableIdIfNonLocal(), (Object)KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID) ? KotlinHighlightingColors.KEYWORD : (function2.isExtension() ? KotlinHighlightingColors.EXTENSION_FUNCTION_CALL : (function2.getSymbolKind() == KtSymbolKind.TOP_LEVEL ? KotlinHighlightingColors.PACKAGE_FUNCTION_CALL : KotlinHighlightingColors.FUNCTION_CALL))))) : KotlinHighlightingColors.FUNCTION_CALL));
    }

    static {
        Name name2 = Name.identifier((String)"suspend");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"suspend\")");
        KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID = new CallableId(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, name2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/FunctionCallHighlighter$Companion;", "", "()V", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "kotlin.highlighting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

