/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.highlighters;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtImplicitReceiverSmartCast;
import org.jetbrains.kotlin.analysis.api.components.KtImplicitReceiverSmartCastKind;
import org.jetbrains.kotlin.analysis.api.components.KtSmartCastInfo;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighting.highlighters.AfterResolveHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.ExpressionsSmartcastHighlighterKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/ExpressionsSmartcastHighlighter;", "Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lcom/intellij/openapi/project/Project;)V", "highlight", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "higlightExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "kotlin.highlighting"})
public final class ExpressionsSmartcastHighlighter
extends AfterResolveHighlighter {
    public ExpressionsSmartcastHighlighter(@NotNull AnnotationHolder holder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(holder, project);
    }

    @Override
    public void highlight(@NotNull KtAnalysisSession ktAnalysisSession, @NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)ktAnalysisSession, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtExpression) {
            this.higlightExpression(ktAnalysisSession, (KtExpression)element3);
        }
    }

    private final void higlightExpression(KtAnalysisSession ktAnalysisSession, KtExpression expression2) {
        block5: {
            Iterable $this$forEach$iv = ktAnalysisSession.getImplicitReceiverSmartCast(expression2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtImplicitReceiverSmartCast it = (KtImplicitReceiverSmartCast)element$iv;
                boolean bl = false;
                String receiverName = switch (WhenMappings.$EnumSwitchMapping$0[it.getKind().ordinal()]) {
                    case 1 -> KotlinBaseHighlightingBundle.message("extension.implicit.receiver", new Object[0]);
                    case 2 -> KotlinBaseHighlightingBundle.message("implicit.receiver", new Object[0]);
                    default -> throw new NoWhenBranchMatchedException();
                };
                PsiElement psiElement2 = (PsiElement)expression2;
                Object[] objectArray = new Object[]{receiverName, it.getType().asStringForDebugging()};
                String string2 = KotlinBaseHighlightingBundle.message("0.smart.cast.to.1", objectArray);
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.SMART_CAST_RECEIVER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_CAST_RECEIVER");
                this.createInfoAnnotation(psiElement2, string2, textAttributesKey);
            }
            KtSmartCastInfo ktSmartCastInfo = ktAnalysisSession.getSmartCastInfo(expression2);
            if (ktSmartCastInfo == null) break block5;
            KtSmartCastInfo info2 = ktSmartCastInfo;
            boolean bl = false;
            PsiElement psiElement3 = ExpressionsSmartcastHighlighterKt.access$getSmartCastTarget(expression2);
            Object[] objectArray = new Object[]{info2.getSmartCastType().asStringForDebugging()};
            String string3 = KotlinBaseHighlightingBundle.message("smart.cast.to.0", objectArray);
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.SMART_CAST_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_CAST_VALUE");
            this.createInfoAnnotation(psiElement3, string3, textAttributesKey);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtImplicitReceiverSmartCastKind.values().length];
            try {
                nArray[KtImplicitReceiverSmartCastKind.EXTENSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtImplicitReceiverSmartCastKind.DISPATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

