/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.highlighters;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinNameHighlightingStateUtils;
import org.jetbrains.kotlin.idea.highlighting.HiglightingFactory;
import org.jetbrains.kotlin.idea.highlighting.highlighters.ExpressionsSmartcastHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.FunctionCallHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.TypeHighlighter;
import org.jetbrains.kotlin.idea.highlighting.highlighters.VariableReferenceHighlighter;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u001c\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0015H&R\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00102\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004J$\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00102\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createInfoAnnotation", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "message", "", "textAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "element", "Lcom/intellij/psi/PsiElement;", "highlight", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "highlightName", "attributesKey", "Companion", "kotlin.highlighting"})
public abstract class AfterResolveHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationHolder holder;
    @NotNull
    private final Project project;

    public AfterResolveHighlighter(@NotNull AnnotationHolder holder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.holder = holder;
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public abstract void highlight(@NotNull KtAnalysisSession var1, @NotNull KtElement var2);

    private final void createInfoAnnotation(TextRange textRange, String message2, TextAttributesKey textAttributes) {
        HiglightingFactory.INSTANCE.createInfoAnnotation(this.holder, textRange, message2, textAttributes);
    }

    protected final void createInfoAnnotation(@NotNull PsiElement element3, @Nullable String message2, @NotNull TextAttributesKey textAttributes) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        TextRange textRange = element3.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        this.createInfoAnnotation(textRange, message2, textAttributes);
    }

    public static /* synthetic */ void createInfoAnnotation$default(AfterResolveHighlighter afterResolveHighlighter, PsiElement psiElement2, String string2, TextAttributesKey textAttributesKey, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createInfoAnnotation");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        afterResolveHighlighter.createInfoAnnotation(psiElement2, string2, textAttributesKey);
    }

    protected final void highlightName(@NotNull PsiElement element3, @NotNull TextAttributesKey attributesKey, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)attributesKey, (String)"attributesKey");
        if (KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(this.project) && !element3.getTextRange().isEmpty()) {
            this.createInfoAnnotation(element3, message2, attributesKey);
        }
    }

    public static /* synthetic */ void highlightName$default(AfterResolveHighlighter afterResolveHighlighter, PsiElement psiElement2, TextAttributesKey textAttributesKey, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: highlightName");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        afterResolveHighlighter.highlightName(psiElement2, textAttributesKey, string2);
    }

    protected final void highlightName(@NotNull TextRange textRange, @NotNull TextAttributesKey attributesKey, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)attributesKey, (String)"attributesKey");
        if (KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(this.project)) {
            this.createInfoAnnotation(textRange, message2, attributesKey);
        }
    }

    public static /* synthetic */ void highlightName$default(AfterResolveHighlighter afterResolveHighlighter, TextRange textRange, TextAttributesKey textAttributesKey, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: highlightName");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        afterResolveHighlighter.highlightName(textRange, textAttributesKey, string2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter$Companion;", "", "()V", "createHighlighters", "", "Lorg/jetbrains/kotlin/idea/highlighting/highlighters/AfterResolveHighlighter;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.highlighting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<AfterResolveHighlighter> createHighlighters(@NotNull AnnotationHolder holder, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] objectArray = new AfterResolveHighlighter[]{new TypeHighlighter(holder, project), new FunctionCallHighlighter(holder, project), new ExpressionsSmartcastHighlighter(holder, project), new VariableReferenceHighlighter(holder, project)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

