/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtDiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticKt;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixService;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\n*\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a*\u0006\u0012\u0002\b\u00030\u0013H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/KotlinHighLevelDiagnosticHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "annotationHolder", "Lcom/intellij/codeInsight/daemon/impl/AnnotationHolderImpl;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isInternalOrUnitTestMode", "", "addDiagnostic", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "diagnostic", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;", "addFixes", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "fixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getHighlightSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "getMessageToRender", "", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic;", "Companion", "kotlin.highlighting"})
public final class KotlinHighLevelDiagnosticHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final AnnotationHolderImpl annotationHolder;
    private static volatile boolean IGNORE_IN_TESTS;

    public KotlinHighLevelDiagnosticHighlightingPass(@NotNull KtFile ktFile, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(ktFile.getProject(), document);
        this.ktFile = ktFile;
        this.annotationHolder = new AnnotationHolderImpl(new AnnotationSession((PsiFile)this.ktFile), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        if (IGNORE_IN_TESTS) {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return;
        }
        KtElement useSiteKtElement$iv = (KtElement)this.ktFile;
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project = useSiteKtElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        void var8_10 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$doCollectInformation_u24lambda_u241 = analysisSession$iv$iv$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$doCollectInformation_u24lambda_u241.collectDiagnosticsForFile(this.ktFile, KtDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDiagnosticWithPsi diagnostic = (KtDiagnosticWithPsi)element$iv;
                boolean bl2 = false;
                this.addDiagnostic($this$doCollectInformation_u24lambda_u241, diagnostic);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final void addDiagnostic(KtAnalysisSession $this$addDiagnostic, KtDiagnosticWithPsi<?> diagnostic) {
        boolean $i$f$service = false;
        Class<KotlinQuickFixService> serviceClass$iv = KotlinQuickFixService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        KotlinQuickFixService $this$addDiagnostic_u24lambda_u242 = (KotlinQuickFixService)object;
        boolean bl = false;
        Intrinsics.checkNotNull(diagnostic, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic<*>");
        List<IntentionAction> fixes = $this$addDiagnostic_u24lambda_u242.getQuickFixesFor($this$addDiagnostic, (KtFirDiagnostic)diagnostic);
        this.annotationHolder.runAnnotatorWithContext(diagnostic.getPsi(), (arg_0, arg_1) -> KotlinHighLevelDiagnosticHighlightingPass.addDiagnostic$lambda$4(diagnostic, this, fixes, arg_0, arg_1));
    }

    private final HighlightSeverity getHighlightSeverity(KtDiagnosticWithPsi<?> $this$getHighlightSeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getHighlightSeverity.getSeverity().ordinal()]) {
            case 1 -> HighlightSeverity.INFORMATION;
            case 2 -> HighlightSeverity.ERROR;
            case 3 -> HighlightSeverity.WARNING;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotationBuilder addFixes(AnnotationBuilder $this$addFixes, List<? extends IntentionAction> fixes) {
        Iterable $this$fold$iv = fixes;
        boolean $i$f$fold = false;
        AnnotationBuilder accumulator$iv = $this$addFixes;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            IntentionAction intentionAction = (IntentionAction)element$iv;
            AnnotationBuilder p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.withFix((IntentionAction)p1);
        }
        return accumulator$iv;
    }

    private final String getMessageToRender(KtDiagnostic $this$getMessageToRender) {
        return this.isInternalOrUnitTestMode() ? KtDiagnosticKt.getDefaultMessageWithFactoryName($this$getMessageToRender) : $this$getMessageToRender.getDefaultMessage();
    }

    private final boolean isInternalOrUnitTestMode() {
        Application application = ApplicationManager.getApplication();
        return application.isInternal() || application.isUnitTestMode();
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $this$mapTo$iv$iv;
        if (IGNORE_IN_TESTS) {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return;
        }
        Iterable $this$map$iv = (Iterable)this.annotationHolder;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Annotation annotation = (Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HighlightInfo.fromAnnotation((Annotation)p0));
        }
        List diagnosticInfos = (List)destination$iv$iv;
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.ktFile.getTextLength(), (Collection)diagnosticInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private static final void addDiagnostic$lambda$4(KtDiagnosticWithPsi $diagnostic, KotlinHighLevelDiagnosticHighlightingPass this$0, List $fixes, PsiElement psiElement2, AnnotationHolder annotationHolder2) {
        Intrinsics.checkNotNullParameter((Object)$diagnostic, (String)"$diagnostic");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fixes, (String)"$fixes");
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)annotationHolder2, (String)"<anonymous parameter 1>");
        Iterable $this$forEach$iv = $diagnostic.getTextRanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange range2 = (TextRange)element$iv;
            boolean bl = false;
            AnnotationBuilder annotationBuilder = this$0.annotationHolder.newAnnotation(this$0.getHighlightSeverity($diagnostic), this$0.getMessageToRender($diagnostic));
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"annotationHolder.newAnno\u2026tic.getMessageToRender())");
            this$0.addFixes(annotationBuilder, $fixes).range(range2).create();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/KotlinHighLevelDiagnosticHighlightingPass$Companion;", "", "()V", "IGNORE_IN_TESTS", "", "ignoreThisPassInTests", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.highlighting"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TestOnly
        public final <T> T ignoreThisPassInTests(@NotNull Function0<? extends T> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            IGNORE_IN_TESTS = true;
            try {
                Object object = action2.invoke();
                return (T)object;
            }
            finally {
                IGNORE_IN_TESTS = false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

