/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinHighlighterAttributeUtils;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighting.beforeResolve.AbstractBeforeResolveHiglightingVisitory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\u00020\u0006\"\f\b\u0000\u0010\u0007*\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\u0007H\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/DeclarationHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighting/beforeResolve/AbstractBeforeResolveHiglightingVisitory;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "highlightMutability", "", "D", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;)V", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitDestructuringDeclaration", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "visitObjectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin.highlighting"})
public final class DeclarationHighlightingVisitor
extends AbstractBeforeResolveHiglightingVisitory {
    public DeclarationHighlightingVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias2) {
        Intrinsics.checkNotNullParameter((Object)typeAlias2, (String)"typeAlias");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)typeAlias2;
        TextAttributesKey textAttributesKey = KotlinHighlightingColors.TYPE_ALIAS;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"TYPE_ALIAS");
        this.highlightNamedDeclaration(ktNamedDeclaration, textAttributesKey);
        super.visitTypeAlias(typeAlias2);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)declaration2;
        TextAttributesKey textAttributesKey = KotlinHighlightingColors.OBJECT;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"OBJECT");
        this.highlightNamedDeclaration(ktNamedDeclaration, textAttributesKey);
        super.visitObjectDeclaration(declaration2);
    }

    public void visitClass(@NotNull KtClass klass2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        this.highlightNamedDeclaration((KtNamedDeclaration)klass2, KotlinHighlighterAttributeUtils.textAttributesForClass(klass2));
        super.visitClass(klass2);
    }

    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        TextAttributesKey textAttributesKey = KotlinHighlighterAttributeUtils.textAttributesForKtPropertyDeclaration(property2);
        if (textAttributesKey != null) {
            TextAttributesKey attributes2 = textAttributesKey;
            boolean bl = false;
            this.highlightNamedDeclaration((KtNamedDeclaration)property2, attributes2);
        }
        this.highlightMutability((KtValVarKeywordOwner)property2);
        super.visitProperty(property2);
    }

    public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        boolean isVar = destructuringDeclaration.isVar();
        for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
            AbstractHighlightingVisitor abstractHighlightingVisitor = this;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            PsiElement psiElement2 = (PsiElement)entry;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.LOCAL_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"LOCAL_VARIABLE");
            AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor, psiElement2, textAttributesKey, null, 4, null);
            if (!isVar) continue;
            AbstractHighlightingVisitor abstractHighlightingVisitor2 = this;
            PsiElement psiElement3 = (PsiElement)entry;
            TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.MUTABLE_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"MUTABLE_VARIABLE");
            AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor2, psiElement3, textAttributesKey2, null, 4, null);
        }
    }

    public void visitParameter(@NotNull KtParameter parameter2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        this.highlightNamedDeclaration((KtNamedDeclaration)parameter2, KotlinHighlighterAttributeUtils.textAttributesForKtParameterDeclaration(parameter2));
        this.highlightMutability((KtValVarKeywordOwner)parameter2);
        super.visitParameter(parameter2);
    }

    private final <D extends KtValVarKeywordOwner & KtNamedDeclaration> void highlightMutability(D declaration2) {
        if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)declaration2.getValOrVarKeyword()), (Object)KtTokens.VAR_KEYWORD)) {
            KtNamedDeclaration ktNamedDeclaration = declaration2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
            this.highlightNamedDeclaration(ktNamedDeclaration, textAttributesKey);
        }
    }
}

