/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinNameHighlightingStateUtils;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighting.beforeResolve.AbstractBeforeResolveHiglightingVisitory;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/AnnotationEntryHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighting/beforeResolve/AbstractBeforeResolveHiglightingVisitory;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitAnnotationEntry", "", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getTextRangeToHiglight", "Lcom/intellij/openapi/util/TextRange;", "kotlin.highlighting"})
public final class AnnotationEntryHighlightingVisitor
extends AbstractBeforeResolveHiglightingVisitory {
    public AnnotationEntryHighlightingVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        Project project = annotationEntry2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"annotationEntry.project");
        if (!KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(project)) {
            return;
        }
        TextRange textRange = this.getTextRangeToHiglight(annotationEntry2);
        if (textRange == null) {
            return;
        }
        TextRange range2 = textRange;
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, range2, null, KotlinHighlightingColors.ANNOTATION, 2, null);
    }

    private final TextRange getTextRangeToHiglight(KtAnnotationEntry $this$getTextRangeToHiglight) {
        PsiElement psiElement2 = $this$getTextRangeToHiglight.getAtSymbol();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement atSymbol = psiElement2;
        KtTypeReference ktTypeReference = $this$getTextRangeToHiglight.getTypeReference();
        if (ktTypeReference == null) {
            return null;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)atSymbol), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference2)));
    }
}

