/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.CommonProcessors;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridingMethodsUpdater;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0005j\b\u0012\u0004\u0012\u00020\u0003`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/OverridingMethodsUpdater;", "Lcom/intellij/codeInsight/navigation/BackgroundUpdaterTask;", "myMethod", "Lcom/intellij/psi/PsiMethod;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lcom/intellij/psi/PsiMethod;Ljava/util/Comparator;)V", "getCaption", "", "size", "", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "kotlin.idea"})
final class OverridingMethodsUpdater
extends BackgroundUpdaterTask {
    @NotNull
    private final PsiMethod myMethod;

    public OverridingMethodsUpdater(@NotNull PsiMethod myMethod, final @NotNull Comparator<PsiMethod> comparator) {
        super(myMethod.getProject(), KotlinBundle.message("highlighter.title.searching.for.overriding.methods", new Object[0]), BackgroundUpdaterTask.createComparatorWrapper((arg_0, arg_1) -> OverridingMethodsUpdater._init_$lambda$0((Function2)new Function2<PsiElement, PsiElement, Integer>(){

            @NotNull
            public final Integer invoke(@NotNull PsiElement o1, @NotNull PsiElement o2) {
                return o1 instanceof PsiMethod && o2 instanceof PsiMethod ? comparator.compare((PsiMethod)o1, (PsiMethod)o2) : 0;
            }
        }, arg_0, arg_1)));
        this.myMethod = myMethod;
    }

    @NotNull
    public String getCaption(int size) {
        String string2;
        if (this.myMethod.hasModifierProperty("abstract")) {
            Object[] objectArray = new Object[]{this.myMethod.getName(), size};
            string2 = DaemonBundle.message((String)"navigation.title.implementation.method", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{this.myMethod.getName(), size};
            string2 = DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])objectArray);
        }
        return string2;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        super.run(indicator);
        CommonProcessors.CollectProcessor<PsiMethod> processor2 = new CommonProcessors.CollectProcessor<PsiMethod>(this, indicator){
            final /* synthetic */ OverridingMethodsUpdater this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.this$0 = $receiver;
                this.$indicator = $indicator;
            }

            public boolean process(@NotNull PsiMethod psiMethod) {
                if (!this.this$0.updateComponent((PsiElement)psiMethod)) {
                    this.$indicator.cancel();
                }
                this.$indicator.checkCanceled();
                return super.process((Object)psiMethod);
            }
        };
        OverridersSearchUtilsKt.forEachOverridingMethod$default(this.myMethod, null, (Function1)new Function1<PsiMethod, Boolean>(processor2){
            final /* synthetic */ run.processor.1 $processor;
            {
                this.$processor = $processor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiMethod it) {
                return this.$processor.process(it);
            }
        }, 1, null);
    }

    private static final int _init_$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

