/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.impl.GutterIconTooltipHelper;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.AdapterProcessor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinDefinitionsSearcher;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\r"}, d2={"buildNavigateToPropertyOverriddenDeclarationsPopup", "Lorg/jetbrains/kotlin/idea/highlighter/markers/NavigationPopupDescriptor;", "e", "Ljava/awt/event/MouseEvent;", "element", "Lcom/intellij/psi/PsiElement;", "getOverriddenPropertyTooltip", "", "property", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isImplemented", "", "declaration", "kotlin.idea"})
public final class OverridenPropertyMarkerKt {
    @Nullable
    public static final String getOverriddenPropertyTooltip(@NotNull KtNamedDeclaration property2) {
        PsiElementProcessor.CollectElementsWithLimit overriddenInClassesProcessor = new PsiElementProcessor.CollectElementsWithLimit(5);
        AdapterProcessor consumer = new AdapterProcessor((Processor)new CommonProcessors.UniqueProcessor((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)overriddenInClassesProcessor)), OverridenPropertyMarkerKt::getOverriddenPropertyTooltip$lambda$0);
        for (PsiMethod method : OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)property2)) {
            if (overriddenInClassesProcessor.isOverflow()) continue;
            OverridersSearchUtilsKt.forEachOverridingMethod$default(method, null, (Function1)new Function1<PsiMethod, Boolean>((Object)consumer){

                @NotNull
                public final Boolean invoke(PsiMethod p0) {
                    return ((AdapterProcessor)this.receiver).process((Object)p0);
                }
            }, 1, null);
        }
        boolean isImplemented = OverridenPropertyMarkerKt.isImplemented(property2);
        if (overriddenInClassesProcessor.isOverflow()) {
            return isImplemented ? KotlinBundle.message("overridden.marker.implementations.multiple", new Object[0]) : KotlinBundle.message("overridden.marker.overrides.multiple", new Object[0]);
        }
        Collection collectedClasses = overriddenInClassesProcessor.getCollection();
        if (collectedClasses.isEmpty()) {
            return null;
        }
        String start2 = isImplemented ? KotlinBundle.message("overridden.marker.implementation", new Object[0]) : KotlinBundle.message("overridden.marker.overrides", new Object[0]);
        String pattern2 = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
        return GutterIconTooltipHelper.composeText((Iterable)CollectionsKt.sortedWith((Iterable)collectedClasses, (Comparator)new PsiClassListCellRenderer().getComparator()), (String)start2, (String)pattern2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final NavigationPopupDescriptor buildNavigateToPropertyOverriddenDeclarationsPopup(@Nullable MouseEvent e, @Nullable PsiElement element3) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        PsiElement psiElement2 = element3;
        PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
        KtNamedDeclaration ktNamedDeclaration = psiElement3 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement3 : null;
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration propertyOrParameter = ktNamedDeclaration;
        Project project = propertyOrParameter.getProject();
        if (DumbService.isDumb((Project)project)) {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService != null) {
                dumbService.showDumbModeNotification(KotlinBundle.message("highlighter.notification.text.navigation.to.overriding.classes.is.not.possible.during.index.update", new Object[0]));
            }
            return null;
        }
        List<PsiMethod> psiPropertyMethods = OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)propertyOrParameter);
        CommonProcessors.CollectUniquesProcessor elementProcessor = new CommonProcessors.CollectUniquesProcessor();
        Runnable ktPsiMethodProcessor = () -> OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup$lambda$1(psiPropertyMethods, project, elementProcessor);
        MouseEvent mouseEvent = e;
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(ktPsiMethodProcessor, KotlinBundle.message("searching.for.overriding.methods", new Object[0]), true, project, (JComponent)(mouseEvent != null ? mouseEvent.getComponent() : null))) {
            return null;
        }
        DefaultPsiElementCellRenderer renderer2 = new DefaultPsiElementCellRenderer();
        Object[] objectArray = (Object[])CollectionsKt.sortedWith((Iterable)elementProcessor.getResults(), (Comparator)renderer2.getComparator());
        boolean $i$f$filterIsInstance = false;
        void var11_10 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof NavigatablePsiElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List navigatingOverrides = (List)destination$iv$iv;
        objectArray = new Object[]{String.valueOf(propertyOrParameter.getName())};
        String string2 = KotlinBundle.message("overridden.marker.implementations.choose.implementation.title", objectArray);
        objectArray = new Object[]{String.valueOf(propertyOrParameter.getName())};
        return new NavigationPopupDescriptor(navigatingOverrides, string2, KotlinBundle.message("overridden.marker.implementations.choose.implementation.find.usages", objectArray), (ListCellRenderer)renderer2, null, 16, null);
    }

    public static final boolean isImplemented(@NotNull KtNamedDeclaration declaration2) {
        if (declaration2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            return true;
        }
        PsiElement parent2 = declaration2.getParent();
        PsiElement psiElement2 = parent2 = parent2 instanceof KtClassBody ? parent2.getParent() : parent2;
        if (!(parent2 instanceof KtClass)) {
            return false;
        }
        return !(!((KtClass)parent2).isInterface() || declaration2 instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)declaration2).hasBody() || declaration2 instanceof KtDeclarationWithInitializer && ((KtDeclarationWithInitializer)declaration2).hasInitializer());
    }

    private static final PsiClass getOverriddenPropertyTooltip$lambda$0(PsiMethod method) {
        PsiMethod psiMethod = method;
        return psiMethod != null ? psiMethod.getContainingClass() : null;
    }

    private static final void buildNavigateToPropertyOverriddenDeclarationsPopup$lambda$1(List $psiPropertyMethods, Project $project, CommonProcessors.CollectUniquesProcessor $elementProcessor) {
        KotlinDefinitionsSearcher.Companion.processPropertyImplementationsMethods($psiPropertyMethods, (SearchScope)GlobalSearchScope.allScope((Project)$project), (Processor<PsiElement>)((Processor)$elementProcessor));
    }
}

