/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtFakeLightMethod;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasActualMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.OverriddenMergeableLineMarkerInfo;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SubClassMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0002\u0001\n\u001a(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a(\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a(\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a(\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a.\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a.\u0010(\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110&2\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a(\u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0016\u0010\u001b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\u0002`\u001eH\u0002\u001a\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0&H\u0002\u001a\u001e\u00100\u001a\u00020,*\u0002012\u0006\u00102\u001a\u00020\u00112\b\u00103\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u0012\u00104\u001a\b\u0012\u0004\u0012\u00020\u001105*\u00020\u0015H\u0000\u001a\f\u00106\u001a\u00020\u000f*\u00020\u0011H\u0002\u001a\u0018\u00107\u001a\u00020,*\u00020\u00112\n\b\u0002\u00108\u001a\u0004\u0018\u000101H\u0002\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\"\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u001d\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"EXPECTED_DECLARATION", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$EXPECTED_DECLARATION$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$EXPECTED_DECLARATION$1;", "OVERRIDDEN_FUNCTION", "Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "getOVERRIDDEN_FUNCTION", "()Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "OVERRIDDEN_PROPERTY", "getOVERRIDDEN_PROPERTY", "PLATFORM_ACTUAL", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$PLATFORM_ACTUAL$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$PLATFORM_ACTUAL$1;", "SUBCLASSED_CLASS", "getSUBCLASSED_CLASS", "expectOrActualAnchor", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getExpectOrActualAnchor", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Lcom/intellij/psi/PsiElement;", "markerDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMarkerDeclaration", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "collectActualMarkers", "", "declaration", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "collectExpectedMarkers", "collectInheritedClassMarker", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "collectMultiplatformMarkers", "collectOverriddenFunctions", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectOverriddenPropertyAccessors", "properties", "collectSuperDeclarationMarkers", "isImplementsAndNotOverrides", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overriddenMembers", "areAnchorsOnOneLine", "Lcom/intellij/openapi/editor/Document;", "first", "second", "findMarkerBoundDeclarations", "Lkotlin/sequences/Sequence;", "nameAnchor", "requiresNoMarkers", "document", "kotlin.idea"})
public final class KotlinLineMarkerProviderKt {
    @NotNull
    private static final MarkerType SUBCLASSED_CLASS;
    @NotNull
    private static final MarkerType OVERRIDDEN_FUNCTION;
    @NotNull
    private static final MarkerType OVERRIDDEN_PROPERTY;
    @NotNull
    private static final PLATFORM_ACTUAL.1 PLATFORM_ACTUAL;
    @NotNull
    private static final EXPECTED_DECLARATION.1 EXPECTED_DECLARATION;

    @NotNull
    public static final MarkerType getSUBCLASSED_CLASS() {
        return SUBCLASSED_CLASS;
    }

    @NotNull
    public static final MarkerType getOVERRIDDEN_FUNCTION() {
        return OVERRIDDEN_FUNCTION;
    }

    @NotNull
    public static final MarkerType getOVERRIDDEN_PROPERTY() {
        return OVERRIDDEN_PROPERTY;
    }

    @Nullable
    public static final KtDeclaration getMarkerDeclaration(@NotNull PsiElement $this$markerDeclaration) {
        Object object = $this$markerDeclaration instanceof KtDeclaration ? (KtDeclaration)$this$markerDeclaration : null;
        if (object == null) {
            PsiElement psiElement2 = $this$markerDeclaration.getParent();
            object = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isImplementsAndNotOverrides(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        boolean bl;
        if (descriptor2.getModality() == Modality.ABSTRACT) return false;
        Iterable $this$all$iv = overriddenMembers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
            boolean bl2 = false;
            if (it.getModality() != Modality.ABSTRACT) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final void collectSuperDeclarationMarkers(KtDeclaration declaration2, Collection<? super LineMarkerInfo<?>> result2) {
        boolean bl;
        if (!KotlinLineMarkerOptions.INSTANCE.getImplementingOption().isEnabled() && !KotlinLineMarkerOptions.INSTANCE.getOverridingOption().isEnabled()) {
            return;
        }
        boolean bl2 = bl = declaration2 instanceof KtNamedFunction || declaration2 instanceof KtProperty || declaration2 instanceof KtParameter;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
        KtNamedDeclaration cfr_ignored_0 = (KtNamedDeclaration)declaration2;
        if (!declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = SuperDeclarationMarkerKt.resolveDeclarationWithParents(declaration2);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        Intrinsics.checkNotNull((Object)callableMemberDescriptor);
        boolean bl3 = KotlinLineMarkerProviderKt.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        PsiElement anchor = KotlinLineMarkerProviderKt.nameAnchor((KtNamedDeclaration)declaration2);
        GutterIconDescriptor.Option gutter = bl3 ? KotlinLineMarkerOptions.INSTANCE.getImplementingOption() : KotlinLineMarkerOptions.INSTANCE.getOverridingOption();
        TextRange textRange = anchor.getTextRange();
        Icon icon = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon, (Function)SuperDeclarationMarkerTooltip.INSTANCE, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler(), GutterIconRenderer.Alignment.RIGHT, () -> KotlinLineMarkerProviderKt.collectSuperDeclarationMarkers$lambda$6(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)(declaration2 instanceof KtNamedFunction ? KotlinBundle.message("highlighter.action.text.go.to.super.method", new Object[0]) : KotlinBundle.message("highlighter.action.text.go.to.super.property", new Object[0])), (String)"GotoSuperMethod");
        result2.add(lineMarkerInfo2);
    }

    private static final void collectInheritedClassMarker(KtClass element3, Collection<? super LineMarkerInfo<?>> result2) {
        KtLightClass lightClass;
        if (!KotlinLineMarkerOptions.INSTANCE.getImplementedOption().isEnabled() && !KotlinLineMarkerOptions.INSTANCE.getOverriddenOption().isEnabled()) {
            return;
        }
        if (!PsiModificationUtilsKt.isInheritable(element3)) {
            return;
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)element3));
        if (ktLightClass == null) {
            ktLightClass = (KtLightClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)((KtClassOrObject)element3));
        }
        if (ClassInheritorsSearch.search((PsiClass)((PsiClass)(lightClass = ktLightClass)), (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)element3;
        }
        PsiElement anchor = psiElement2;
        GutterIconDescriptor.Option gutter = element3.isInterface() ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
        Icon icon = gutter.getIcon();
        if (icon == null) {
            return;
        }
        Icon icon2 = icon;
        OverriddenMergeableLineMarkerInfo lineMarkerInfo2 = new OverriddenMergeableLineMarkerInfo(anchor, anchor.getTextRange(), icon2, (Function<? super PsiElement, String>)SUBCLASSED_CLASS.getTooltip(), (GutterIconNavigationHandler<PsiElement>)SUBCLASSED_CLASS.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)new Function0<String>(gutter){
            final /* synthetic */ GutterIconDescriptor.Option $gutter;
            {
                this.$gutter = $gutter;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$gutter.getName();
            }
        }));
        NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo2), (String)(element3.isInterface() ? KotlinBundle.message("highlighter.action.text.go.to.implementations", new Object[0]) : KotlinBundle.message("highlighter.action.text.go.to.subclasses", new Object[0])), (String)"GotoImplementation");
        result2.add((LineMarkerInfo<?>)lineMarkerInfo2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenPropertyAccessors(Collection<? extends KtNamedDeclaration> properties2, Collection<? super LineMarkerInfo<?>> result2) {
        void $this$filterIsInstanceTo$iv$iv;
        if (!KotlinLineMarkerOptions.INSTANCE.getImplementedOption().isEnabled() && !KotlinLineMarkerOptions.INSTANCE.getOverriddenOption().isEnabled()) {
            return;
        }
        HashMap mappingToJava = new HashMap();
        for (KtNamedDeclaration ktNamedDeclaration : properties2) {
            if (!PsiModificationUtilsKt.isOverridable((KtDeclaration)ktNamedDeclaration)) continue;
            Iterable $this$forEach$iv = OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)ktNamedDeclaration);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                ((Map)mappingToJava).put(it, ktNamedDeclaration);
            }
            ((Map)mappingToJava).put(ktNamedDeclaration, ktNamedDeclaration);
        }
        Iterable iterable = mappingToJava.keySet();
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$forEach = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> classes2 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedDeclaration property3 : OverridenFunctionMarkerKt.getOverriddenDeclarations(mappingToJava, classes2)) {
            ProgressManager.checkCanceled();
            PsiNameIdentifierOwner psiNameIdentifierOwner = property3 instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)property3 : null;
            if (psiNameIdentifierOwner == null || (psiNameIdentifierOwner = psiNameIdentifierOwner.getNameIdentifier()) == null) {
                psiNameIdentifierOwner = (PsiElement)property3;
            }
            PsiNameIdentifierOwner anchor = psiNameIdentifierOwner;
            GutterIconDescriptor.Option gutter = OverridenPropertyMarkerKt.isImplemented(property3) ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
            TextRange textRange = anchor.getTextRange();
            Icon icon = gutter.getIcon();
            Intrinsics.checkNotNull((Object)icon);
            OverriddenMergeableLineMarkerInfo lineMarkerInfo2 = new OverriddenMergeableLineMarkerInfo((PsiElement)anchor, textRange, icon, (Function<? super PsiElement, String>)OVERRIDDEN_PROPERTY.getTooltip(), (GutterIconNavigationHandler<PsiElement>)OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)new Function0<String>(gutter){
                final /* synthetic */ GutterIconDescriptor.Option $gutter;
                {
                    this.$gutter = $gutter;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$gutter.getName();
                }
            }));
            NavigateAction.setNavigateAction((LineMarkerInfo)((LineMarkerInfo)lineMarkerInfo2), (String)KotlinBundle.message("highlighter.action.text.go.to.overridden.properties", new Object[0]), (String)"GotoImplementation");
            result2.add((LineMarkerInfo<?>)lineMarkerInfo2);
        }
    }

    private static final PsiElement getExpectOrActualAnchor(KtNamedDeclaration $this$expectOrActualAnchor) {
        PsiElement psiElement2 = $this$expectOrActualAnchor.getNameIdentifier();
        if (psiElement2 == null) {
            Object object;
            KtNamedDeclaration ktNamedDeclaration = $this$expectOrActualAnchor;
            if (ktNamedDeclaration instanceof KtConstructor) {
                object = ((KtConstructor)$this$expectOrActualAnchor).getConstructorKeyword();
                if (object == null) {
                    KtParameterList ktParameterList = ((KtConstructor)$this$expectOrActualAnchor).getValueParameterList();
                    object = ktParameterList != null ? ktParameterList.getLeftParenthesis() : null;
                }
            } else {
                object = psiElement2 = ktNamedDeclaration instanceof KtObjectDeclaration ? ((KtObjectDeclaration)$this$expectOrActualAnchor).getObjectKeyword() : null;
            }
            if (object == null) {
                psiElement2 = (PsiElement)$this$expectOrActualAnchor;
            }
        }
        return psiElement2;
    }

    private static final void collectMultiplatformMarkers(KtNamedDeclaration declaration2, Collection<? super LineMarkerInfo<?>> result2) {
        if (KotlinLineMarkerOptions.INSTANCE.getActualOption().isEnabled() && ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)declaration2)) {
            KotlinLineMarkerProviderKt.collectActualMarkers(declaration2, result2);
            return;
        }
        if (KotlinLineMarkerOptions.INSTANCE.getExpectOption().isEnabled() && !ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)declaration2) && ExpectActualUtilKt.isEffectivelyActual$default((KtDeclaration)declaration2, false, 1, null)) {
            KotlinLineMarkerProviderKt.collectExpectedMarkers(declaration2, result2);
            return;
        }
    }

    private static final boolean areAnchorsOnOneLine(Document $this$areAnchorsOnOneLine, KtNamedDeclaration first2, KtNamedDeclaration second) {
        if (second == null) {
            return false;
        }
        PsiElement firstAnchor = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(first2);
        PsiElement secondAnchor = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(second);
        return FixersUtilKt.startLine(firstAnchor, $this$areAnchorsOnOneLine) == FixersUtilKt.startLine(secondAnchor, $this$areAnchorsOnOneLine);
    }

    private static final boolean requiresNoMarkers(KtNamedDeclaration $this$requiresNoMarkers, Document document) {
        KtNamedDeclaration ktNamedDeclaration = $this$requiresNoMarkers;
        if (ktNamedDeclaration instanceof KtPrimaryConstructor) {
            return true;
        }
        if (ktNamedDeclaration instanceof KtParameter ? true : ktNamedDeclaration instanceof KtEnumEntry) {
            Document document2 = document;
            boolean bl = document2 != null ? KotlinLineMarkerProviderKt.areAnchorsOnOneLine(document2, $this$requiresNoMarkers, (KtNamedDeclaration)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$requiresNoMarkers))) : false;
            if (bl) {
                return true;
            }
            if ($this$requiresNoMarkers instanceof KtEnumEntry) {
                List list2;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$requiresNoMarkers));
                if ((ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getBody()) != null ? ktClassOrObject.getEnumEntries() : (list2 = null)) == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List enumEntries = list2;
                KtEnumEntry previousEnumEntry = (KtEnumEntry)CollectionsKt.getOrNull((List)enumEntries, (int)(enumEntries.indexOf($this$requiresNoMarkers) - 1));
                Document document3 = document;
                boolean bl2 = document3 != null ? KotlinLineMarkerProviderKt.areAnchorsOnOneLine(document3, $this$requiresNoMarkers, (KtNamedDeclaration)previousEnumEntry) : false;
                if (bl2) {
                    return true;
                }
            }
            if ($this$requiresNoMarkers instanceof KtParameter && ((KtParameter)$this$requiresNoMarkers).hasValOrVar()) {
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$requiresNoMarkers));
                List list3 = ktClassOrObject != null ? ktClassOrObject.getPrimaryConstructorParameters() : null;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List parameters2 = list3;
                KtParameter previousParameter = (KtParameter)CollectionsKt.getOrNull((List)parameters2, (int)(parameters2.indexOf($this$requiresNoMarkers) - 1));
                Document document4 = document;
                boolean bl3 = document4 != null ? KotlinLineMarkerProviderKt.areAnchorsOnOneLine(document4, $this$requiresNoMarkers, (KtNamedDeclaration)previousParameter) : false;
                if (bl3) {
                    return true;
                }
            }
        }
        return false;
    }

    static /* synthetic */ boolean requiresNoMarkers$default(KtNamedDeclaration ktNamedDeclaration, Document document, int n, Object object) {
        if ((n & 1) != 0) {
            document = PsiDocumentManager.getInstance((Project)ktNamedDeclaration.getProject()).getDocument(ktNamedDeclaration.getContainingFile());
        }
        return KotlinLineMarkerProviderKt.requiresNoMarkers(ktNamedDeclaration, document);
    }

    @NotNull
    public static final Sequence<KtNamedDeclaration> findMarkerBoundDeclarations(@NotNull KtDeclaration $this$findMarkerBoundDeclarations) {
        Sequence sequence2;
        if (!($this$findMarkerBoundDeclarations instanceof KtClass) && !($this$findMarkerBoundDeclarations instanceof KtParameter)) {
            return SequencesKt.emptySequence();
        }
        Document document = PsiDocumentManager.getInstance((Project)$this$findMarkerBoundDeclarations.getProject()).getDocument($this$findMarkerBoundDeclarations.getContainingFile());
        KtDeclaration ktDeclaration = $this$findMarkerBoundDeclarations;
        if (ktDeclaration instanceof KtParameter) {
            List list2;
            KtDeclaration ktDeclaration2 = $this$findMarkerBoundDeclarations;
            KtParameter it = (KtParameter)ktDeclaration2;
            boolean bl = false;
            KtParameter ktParameter = (KtParameter)(((KtParameter)$this$findMarkerBoundDeclarations).hasValOrVar() ? ktDeclaration2 : null);
            if (ktParameter == null || (ktDeclaration2 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)ktParameter))) == null || (list2 = ktDeclaration2.getPrimaryConstructorParameters()) == null) {
                return SequencesKt.emptySequence();
            }
            List propertyParameters = list2;
            sequence2 = SequencesKt.filter(KotlinLineMarkerProviderKt.findMarkerBoundDeclarations$takeBound(SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)propertyParameters), (Function1)((Function1)new Function1<KtParameter, Boolean>($this$findMarkerBoundDeclarations){
                final /* synthetic */ KtDeclaration $this_findMarkerBoundDeclarations;
                {
                    this.$this_findMarkerBoundDeclarations = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtParameter it) {
                    return it != this.$this_findMarkerBoundDeclarations;
                }
            })), (int)1), document, (KtNamedDeclaration)$this$findMarkerBoundDeclarations), (Function1)findMarkerBoundDeclarations.2.INSTANCE);
        } else if (ktDeclaration instanceof KtEnumEntry) {
            Object object = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)$this$findMarkerBoundDeclarations);
            if (object == null || (object = object.getBody()) == null || (object = object.getEnumEntries()) == null) {
                return SequencesKt.emptySequence();
            }
            Object enumEntries = object;
            sequence2 = KotlinLineMarkerProviderKt.findMarkerBoundDeclarations$takeBound(SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)enumEntries)), (Function1)((Function1)new Function1<KtEnumEntry, Boolean>($this$findMarkerBoundDeclarations){
                final /* synthetic */ KtDeclaration $this_findMarkerBoundDeclarations;
                {
                    this.$this_findMarkerBoundDeclarations = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtEnumEntry it) {
                    return it != this.$this_findMarkerBoundDeclarations;
                }
            })), (int)1), document, (KtNamedDeclaration)$this$findMarkerBoundDeclarations);
        } else if (ktDeclaration instanceof KtClass) {
            Sequence sequence3;
            Sequence bl;
            KtDeclaration ktDeclaration3;
            List list3;
            KtPrimaryConstructor ktPrimaryConstructor = ((KtClass)$this$findMarkerBoundDeclarations).getPrimaryConstructor();
            Sequence sequence4 = ktPrimaryConstructor != null && (list3 = ktPrimaryConstructor.getValueParameters()) != null && (ktDeclaration3 = CollectionsKt.asSequence((Iterable)list3)) != null && (bl = KotlinLineMarkerProviderKt.findMarkerBoundDeclarations$takeBound(ktDeclaration3, document, (KtNamedDeclaration)$this$findMarkerBoundDeclarations)) != null ? SequencesKt.filter(bl, (Function1)findMarkerBoundDeclarations.boundParameters.1.INSTANCE) : null;
            if (sequence4 == null) {
                sequence4 = SequencesKt.emptySequence();
            }
            Sequence boundParameters2 = sequence4;
            ktDeclaration3 = $this$findMarkerBoundDeclarations;
            KtClass it = (KtClass)ktDeclaration3;
            boolean bl2 = false;
            Object object = (KtClass)(((KtClass)$this$findMarkerBoundDeclarations).isEnum() ? ktDeclaration3 : null);
            if ((object != null && (object = object.getBody()) != null && (object = object.getEnumEntries()) != null && (object = CollectionsKt.asSequence((Iterable)((Iterable)object))) != null ? KotlinLineMarkerProviderKt.findMarkerBoundDeclarations$takeBound(object, document, (KtNamedDeclaration)$this$findMarkerBoundDeclarations) : (sequence3 = null)) == null) {
                sequence3 = SequencesKt.emptySequence();
            }
            Sequence boundEnumEntries = sequence3;
            sequence2 = SequencesKt.plus((Sequence)boundParameters2, (Sequence)boundEnumEntries);
        } else {
            sequence2 = SequencesKt.emptySequence();
        }
        return sequence2;
    }

    private static final void collectActualMarkers(KtNamedDeclaration declaration2, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter = KotlinLineMarkerOptions.INSTANCE.getActualOption();
        if (!gutter.isEnabled()) {
            return;
        }
        if (KotlinLineMarkerProviderKt.requiresNoMarkers$default(declaration2, null, 1, null)) {
            return;
        }
        if (!ExpectActualUtilKt.hasAtLeastOneActual((KtDeclaration)declaration2)) {
            return;
        }
        PsiElement anchor = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(declaration2);
        TextRange textRange = anchor.getTextRange();
        Icon icon = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon, PLATFORM_ACTUAL.getTooltip(), PLATFORM_ACTUAL.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT, () -> KotlinLineMarkerProviderKt.collectActualMarkers$lambda$10(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message("highlighter.action.text.go.to.actual.declarations", new Object[0]), (String)"GotoImplementation");
        result2.add(lineMarkerInfo2);
    }

    private static final void collectExpectedMarkers(KtNamedDeclaration declaration2, Collection<? super LineMarkerInfo<?>> result2) {
        if (!KotlinLineMarkerOptions.INSTANCE.getExpectOption().isEnabled()) {
            return;
        }
        if (KotlinLineMarkerProviderKt.requiresNoMarkers$default(declaration2, null, 1, null)) {
            return;
        }
        if (!ExpectActualUtilKt.hasMatchingExpected((KtDeclaration)declaration2)) {
            return;
        }
        PsiElement anchor = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(declaration2);
        GutterIconDescriptor.Option gutter = KotlinLineMarkerOptions.INSTANCE.getExpectOption();
        TextRange textRange = anchor.getTextRange();
        Icon icon = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon, EXPECTED_DECLARATION.getTooltip(), EXPECTED_DECLARATION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT, () -> KotlinLineMarkerProviderKt.collectExpectedMarkers$lambda$11(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message("highlighter.action.text.go.to.expected.declaration", new Object[0]), null);
        result2.add(lineMarkerInfo2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenFunctions(Collection<? extends KtNamedFunction> functions2, Collection<? super LineMarkerInfo<?>> result2) {
        void $this$filterIsInstanceTo$iv$iv;
        if (!KotlinLineMarkerOptions.INSTANCE.getImplementedOption().isEnabled() && !KotlinLineMarkerOptions.INSTANCE.getOverriddenOption().isEnabled()) {
            return;
        }
        HashMap mappingToJava = new HashMap();
        for (KtNamedFunction ktNamedFunction : functions2) {
            PsiMethod method;
            if (!PsiModificationUtilsKt.isOverridable((KtDeclaration)ktNamedFunction)) continue;
            PsiMethod psiMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedFunction);
            if (psiMethod == null) {
                psiMethod = (PsiMethod)KtFakeLightMethod.Companion.get((KtNamedDeclaration)ktNamedFunction);
            }
            if ((method = psiMethod) != null) {
                ((Map)mappingToJava).put(method, ktNamedFunction);
            }
            ((Map)mappingToJava).put(ktNamedFunction, ktNamedFunction);
        }
        Iterable iterable = mappingToJava.keySet();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> classes2 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedFunction function3 : OverridenFunctionMarkerKt.getOverriddenDeclarations(mappingToJava, classes2)) {
            ProgressManager.checkCanceled();
            PsiElement anchor = KotlinLineMarkerProviderKt.nameAnchor((KtNamedDeclaration)function3);
            GutterIconDescriptor.Option gutter = OverridenPropertyMarkerKt.isImplemented((KtNamedDeclaration)function3) ? KotlinLineMarkerOptions.INSTANCE.getImplementedOption() : KotlinLineMarkerOptions.INSTANCE.getOverriddenOption();
            TextRange textRange = anchor.getTextRange();
            Icon icon = gutter.getIcon();
            Intrinsics.checkNotNull((Object)icon);
            LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT, () -> KotlinLineMarkerProviderKt.collectOverriddenFunctions$lambda$12(gutter));
            NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message("highlighter.action.text.go.to.overridden.methods", new Object[0]), (String)"GotoImplementation");
            result2.add(lineMarkerInfo2);
        }
    }

    private static final PsiElement nameAnchor(KtNamedDeclaration $this$nameAnchor) {
        PsiElement psiElement2 = $this$nameAnchor.getNameIdentifier();
        if (psiElement2 == null && (psiElement2 = PsiTreeUtil.getDeepestVisibleFirst((PsiElement)((PsiElement)$this$nameAnchor))) == null) {
            psiElement2 = (PsiElement)$this$nameAnchor;
        }
        return psiElement2;
    }

    private static final String SUBCLASSED_CLASS$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String OVERRIDDEN_FUNCTION$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String OVERRIDDEN_PROPERTY$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String PLATFORM_ACTUAL$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String EXPECTED_DECLARATION$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String collectSuperDeclarationMarkers$lambda$6(GutterIconDescriptor.Option $gutter) {
        return $gutter.getName();
    }

    private static final <T extends KtNamedDeclaration> Sequence<T> findMarkerBoundDeclarations$takeBound(Sequence<? extends T> $this$findMarkerBoundDeclarations_u24takeBound, Document document, KtNamedDeclaration bound2) {
        return SequencesKt.takeWhile($this$findMarkerBoundDeclarations_u24takeBound, (Function1)new Function1<T, Boolean>(document, bound2){
            final /* synthetic */ Document $document;
            final /* synthetic */ KtNamedDeclaration $bound;
            {
                this.$document = $document;
                this.$bound = $bound;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                Document document = this.$document;
                return document != null ? KotlinLineMarkerProviderKt.access$areAnchorsOnOneLine(document, this.$bound, it) : false;
            }
        });
    }

    private static final String collectActualMarkers$lambda$10(GutterIconDescriptor.Option $gutter) {
        return $gutter.getName();
    }

    private static final String collectExpectedMarkers$lambda$11(GutterIconDescriptor.Option $gutter) {
        return $gutter.getName();
    }

    private static final String collectOverriddenFunctions$lambda$12(GutterIconDescriptor.Option $gutter) {
        return $gutter.getName();
    }

    public static final /* synthetic */ void access$collectInheritedClassMarker(KtClass element3, Collection result2) {
        KotlinLineMarkerProviderKt.collectInheritedClassMarker(element3, result2);
    }

    public static final /* synthetic */ void access$collectSuperDeclarationMarkers(KtDeclaration declaration2, Collection result2) {
        KotlinLineMarkerProviderKt.collectSuperDeclarationMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectMultiplatformMarkers(KtNamedDeclaration declaration2, Collection result2) {
        KotlinLineMarkerProviderKt.collectMultiplatformMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenFunctions(Collection functions2, Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenFunctions(functions2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenPropertyAccessors(Collection properties2, Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenPropertyAccessors(properties2, result2);
    }

    public static final /* synthetic */ boolean access$areAnchorsOnOneLine(Document $receiver, KtNamedDeclaration first2, KtNamedDeclaration second) {
        return KotlinLineMarkerProviderKt.areAnchorsOnOneLine($receiver, first2, second);
    }

    static {
        Function function2 = arg_0 -> KotlinLineMarkerProviderKt.SUBCLASSED_CLASS$lambda$0(SUBCLASSED_CLASS.2.INSTANCE, arg_0);
        LineMarkerNavigator lineMarkerNavigator = new LineMarkerNavigator(){

            public void browse(@NotNull MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = SubClassMarkerKt.buildNavigateToClassInheritorsPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        };
        SUBCLASSED_CLASS = new MarkerType((Function<Object, String>)function2, lineMarkerNavigator){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)superHandler){
                    final /* synthetic */ GutterIconNavigationHandler<PsiElement> $superHandler;
                    {
                        this.$superHandler = $superHandler;
                    }

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return SubClassMarkerKt.buildNavigateToClassInheritorsPopup(null, element3);
                    }
                };
            }
        };
        function2 = arg_0 -> KotlinLineMarkerProviderKt.OVERRIDDEN_FUNCTION$lambda$1(OVERRIDDEN_FUNCTION.2.INSTANCE, arg_0);
        lineMarkerNavigator = new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block1: {
                    MouseEvent mouseEvent = e;
                    if (mouseEvent == null) break block1;
                    MouseEvent it = mouseEvent;
                    boolean bl = false;
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(e, element3);
                    if (navigationPopupDescriptor != null) {
                        navigationPopupDescriptor.showPopup(e);
                    }
                }
            }
        };
        OVERRIDDEN_FUNCTION = new MarkerType((Function<Object, String>)function2, lineMarkerNavigator){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)superHandler){
                    final /* synthetic */ GutterIconNavigationHandler<PsiElement> $superHandler;
                    {
                        this.$superHandler = $superHandler;
                    }

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(null, element3);
                    }
                };
            }
        };
        function2 = arg_0 -> KotlinLineMarkerProviderKt.OVERRIDDEN_PROPERTY$lambda$2(OVERRIDDEN_PROPERTY.2.INSTANCE, arg_0);
        lineMarkerNavigator = new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block1: {
                    MouseEvent mouseEvent = e;
                    if (mouseEvent == null) break block1;
                    MouseEvent it = mouseEvent;
                    boolean bl = false;
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(e, element3);
                    if (navigationPopupDescriptor != null) {
                        navigationPopupDescriptor.showPopup(e);
                    }
                }
            }
        };
        OVERRIDDEN_PROPERTY = new MarkerType((Function<Object, String>)function2, lineMarkerNavigator){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)superHandler){
                    final /* synthetic */ GutterIconNavigationHandler<PsiElement> $superHandler;
                    {
                        this.$superHandler = $superHandler;
                    }

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(null, element3);
                    }
                };
            }
        };
        function2 = arg_0 -> KotlinLineMarkerProviderKt.PLATFORM_ACTUAL$lambda$3(PLATFORM_ACTUAL.2.INSTANCE, arg_0);
        lineMarkerNavigator = new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block1: {
                    MouseEvent mouseEvent = e;
                    if (mouseEvent == null) break block1;
                    MouseEvent it = mouseEvent;
                    boolean bl = false;
                    NavigationPopupDescriptor navigationPopupDescriptor = HasActualMarkerKt.buildNavigateToActualDeclarationsPopup(element3);
                    if (navigationPopupDescriptor != null) {
                        navigationPopupDescriptor.showPopup(e);
                    }
                }
            }
        };
        PLATFORM_ACTUAL = new MarkerType((Function<Object, String>)function2, lineMarkerNavigator){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)superHandler){
                    final /* synthetic */ GutterIconNavigationHandler<PsiElement> $superHandler;
                    {
                        this.$superHandler = $superHandler;
                    }

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return HasActualMarkerKt.buildNavigateToActualDeclarationsPopup(element3);
                    }
                };
            }
        };
        function2 = arg_0 -> KotlinLineMarkerProviderKt.EXPECTED_DECLARATION$lambda$4(EXPECTED_DECLARATION.2.INSTANCE, arg_0);
        lineMarkerNavigator = new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block1: {
                    MouseEvent mouseEvent = e;
                    if (mouseEvent == null) break block1;
                    MouseEvent it = mouseEvent;
                    boolean bl = false;
                    NavigationPopupDescriptor navigationPopupDescriptor = HasExpectedMarkerKt.buildNavigateToExpectedDeclarationsPopup(element3);
                    if (navigationPopupDescriptor != null) {
                        navigationPopupDescriptor.showPopup(e);
                    }
                }
            }
        };
        EXPECTED_DECLARATION = new MarkerType((Function<Object, String>)function2, lineMarkerNavigator){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)superHandler){
                    final /* synthetic */ GutterIconNavigationHandler<PsiElement> $superHandler;
                    {
                        this.$superHandler = $superHandler;
                    }

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return HasExpectedMarkerKt.buildNavigateToExpectedDeclarationsPopup(element3);
                    }
                };
            }
        };
    }
}

