/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.PropertiesHighlightingVisitorKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ImplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.MultipleSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getSmartCastTarget", "Lcom/intellij/psi/PsiElement;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "highlightVariable", "", "elementToHighlight", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "visitDestructuringDeclarationEntry", "multiDeclarationEntry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "visitExpression", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitVariableDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.base.fe10.highlighting"})
public final class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public VariablesHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor target2 = declarationDescriptor;
        if (target2 instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)this.getBindingContext().get((ReadOnlySlice)BindingContext.AUTO_CREATED_IT, (Object)target2), (Object)true)) {
            this.createInfoAnnotation((PsiElement)expression2, KotlinBaseHighlightingBundle.message("automatically.declared.based.on.the.expected.type", new Object[0]), KotlinHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER);
        } else if (!(expression2.getParent() instanceof KtValueArgumentName)) {
            this.highlightVariable((PsiElement)expression2, target2);
        }
        super.visitSimpleNameExpression(expression2);
    }

    public void visitProperty(@NotNull KtProperty property2) {
        this.visitVariableDeclaration((KtNamedDeclaration)property2);
        super.visitProperty(property2);
    }

    public void visitParameter(@NotNull KtParameter parameter2) {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)parameter2);
        if (propertyDescriptor == null) {
            this.visitVariableDeclaration((KtNamedDeclaration)parameter2);
        }
        super.visitParameter(parameter2);
    }

    public void visitDestructuringDeclarationEntry(@NotNull KtDestructuringDeclarationEntry multiDeclarationEntry) {
        this.visitVariableDeclaration((KtNamedDeclaration)multiDeclarationEntry);
        super.visitDestructuringDeclarationEntry(multiDeclarationEntry);
    }

    private final PsiElement getSmartCastTarget(KtExpression expression2) {
        PsiElement psiElement2;
        PsiElement target2 = (PsiElement)expression2;
        if (target2 instanceof KtParenthesizedExpression) {
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)target2));
            PsiElement psiElement3 = target2 = ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression2;
        }
        return (psiElement2 = target2) instanceof KtIfExpression ? ((KtIfExpression)target2).getIfKeyword() : (psiElement2 instanceof KtWhenExpression ? ((KtWhenExpression)target2).getWhenKeyword() : (psiElement2 instanceof KtBinaryExpression ? (PsiElement)((KtBinaryExpression)target2).getOperationReference() : target2));
    }

    public void visitExpression(@NotNull KtExpression expression2) {
        ExplicitSmartCasts smartCast;
        boolean nullSmartCast;
        ImplicitSmartCasts implicitSmartCast = (ImplicitSmartCasts)this.getBindingContext().get((ReadOnlySlice)BindingContext.IMPLICIT_RECEIVER_SMARTCAST, (Object)expression2);
        if (implicitSmartCast != null) {
            for (Map.Entry entry : implicitSmartCast.getReceiverTypes().entrySet()) {
                Object[] receiver2 = (Object[])entry.getKey();
                KotlinType type2 = (KotlinType)entry.getValue();
                Object[] objectArray = receiver2;
                String entry2 = objectArray instanceof ExtensionReceiver ? KotlinBaseHighlightingBundle.message("extension.implicit.receiver", new Object[0]) : (objectArray instanceof ImplicitClassReceiver ? KotlinBaseHighlightingBundle.message("implicit.receiver", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("unknown.receiver", new Object[0]));
                objectArray = new Object[]{entry2, DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2)};
                this.createInfoAnnotation((PsiElement)expression2, KotlinBaseHighlightingBundle.message("0.smart.cast.to.1", objectArray), KotlinHighlightingColors.SMART_CAST_RECEIVER);
            }
        }
        if (nullSmartCast = Intrinsics.areEqual((Object)this.getBindingContext().get((ReadOnlySlice)BindingContext.SMARTCAST_NULL, (Object)expression2), (Object)true)) {
            this.createInfoAnnotation((PsiElement)expression2, KotlinBaseFe10HighlightingBundle.message("always.null", new Object[0]), KotlinHighlightingColors.SMART_CONSTANT);
        }
        if ((smartCast = (ExplicitSmartCasts)this.getBindingContext().get((ReadOnlySlice)BindingContext.SMARTCAST, (Object)expression2)) != null) {
            KotlinType defaultType2 = smartCast.getDefaultType();
            if (defaultType2 != null) {
                Object[] objectArray = new Object[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(defaultType2)};
                this.createInfoAnnotation(this.getSmartCastTarget(expression2), KotlinBaseHighlightingBundle.message("smart.cast.to.0", objectArray), KotlinHighlightingColors.SMART_CAST_VALUE);
            } else if (smartCast instanceof MultipleSmartCasts) {
                for (Map.Entry entry : ((MultipleSmartCasts)smartCast).getMap().entrySet()) {
                    Call call = (Call)entry.getKey();
                    KotlinType type3 = (KotlinType)entry.getValue();
                    Object[] objectArray = new Object[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type3), String.valueOf(call)};
                    this.createInfoAnnotation(this.getSmartCastTarget(expression2), KotlinBaseFe10HighlightingBundle.message("smart.cast.to.0.for.1.call", objectArray), KotlinHighlightingColors.SMART_CAST_VALUE);
                }
            }
        }
        super.visitExpression(expression2);
    }

    private final void visitVariableDeclaration(KtNamedDeclaration declaration2) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration2);
        PsiElement nameIdentifier = declaration2.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private final void highlightVariable(PsiElement elementToHighlight, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            if (DynamicCallsKt.isDynamic((DeclarationDescriptor)descriptor2)) {
                AbstractHighlightingVisitor.highlightName$default(this, elementToHighlight, KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL, null, 4, null);
                return;
            }
            if (((VariableDescriptor)descriptor2).isVar()) {
                AbstractHighlightingVisitor.highlightName$default(this, elementToHighlight, KotlinHighlightingColors.MUTABLE_VARIABLE, null, 4, null);
            }
            if (this.getBindingContext().get((ReadOnlySlice)BindingContext.CAPTURED_IN_CLOSURE, (Object)descriptor2) == CaptureKind.NOT_INLINE) {
                String msg = ((VariableDescriptor)descriptor2).isVar() ? KotlinBaseFe10HighlightingBundle.message("wrapped.into.a.reference.object.to.be.modified.when.captured.in.a.closure", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("value.captured.in.a.closure", new Object[0]);
                PsiElement parent2 = elementToHighlight.getParent();
                if (!(parent2 instanceof PsiNameIdentifierOwner) || !Intrinsics.areEqual((Object)((PsiNameIdentifierOwner)parent2).getNameIdentifier(), (Object)elementToHighlight)) {
                    this.createInfoAnnotation(elementToHighlight, msg, KotlinHighlightingColors.WRAPPED_INTO_REF);
                    return;
                }
            }
            if (descriptor2 instanceof LocalVariableDescriptor && !(descriptor2 instanceof SyntheticFieldDescriptor)) {
                AbstractHighlightingVisitor.highlightName$default(this, elementToHighlight, KotlinHighlightingColors.LOCAL_VARIABLE, null, 4, null);
            }
            if (descriptor2 instanceof ValueParameterDescriptor) {
                AbstractHighlightingVisitor.highlightName$default(this, elementToHighlight, KotlinHighlightingColors.PARAMETER, null, 4, null);
            }
            if (descriptor2 instanceof PropertyDescriptor && PropertiesHighlightingVisitorKt.hasCustomPropertyDeclaration((PropertyDescriptor)descriptor2)) {
                boolean isStaticDeclaration = DescriptorUtils.isStaticDeclaration((CallableDescriptor)((CallableDescriptor)descriptor2));
                AbstractHighlightingVisitor.highlightName$default(this, elementToHighlight, isStaticDeclaration ? KotlinHighlightingColors.PACKAGE_PROPERTY_CUSTOM_PROPERTY_DECLARATION : KotlinHighlightingColors.INSTANCE_PROPERTY_CUSTOM_PROPERTY_DECLARATION, null, 4, null);
            }
        }
    }
}

