/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinNameHighlightingStateUtils;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.TypeKindHighlightingVisitor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "attributeKeyForObjectAccess", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "calculateClassReferenceAttributes", "target", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "calculateDeclarationReferenceAttributes", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "calculateTypeAliasReferenceAttributes", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "computeHighlightingRangeForUsage", "Lcom/intellij/openapi/util/TextRange;", "referenceTarget", "computeReferencedDescriptor", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "visitIntersectionType", "Lorg/jetbrains/kotlin/psi/KtIntersectionType;", "visitSimpleNameExpression", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin.base.fe10.highlighting"})
public final class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public TypeKindHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        KtIntersectionType ktIntersectionType;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtSuperExpression || parent2 instanceof KtThisExpression) {
            return;
        }
        PsiElement psiElement2 = parent2;
        if (psiElement2 != null && (psiElement2 = psiElement2.getParent()) != null && (psiElement2 = psiElement2.getParent()) != null) {
            PsiElement $this$safeAs$iv = psiElement2;
            boolean $i$f$safeAs = false;
            PsiElement psiElement3 = $this$safeAs$iv;
            if (!(psiElement3 instanceof KtIntersectionType)) {
                psiElement3 = null;
            }
            ktIntersectionType = (KtIntersectionType)psiElement3;
        } else {
            ktIntersectionType = null;
        }
        if (ktIntersectionType != null) {
            return;
        }
        if (!KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(expression2.getProject())) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = this.computeReferencedDescriptor(expression2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor referenceTarget = declarationDescriptor;
        TextAttributesKey textAttributesKey = this.attributeKeyForObjectAccess(expression2);
        if (textAttributesKey == null && (textAttributesKey = this.calculateDeclarationReferenceAttributes(referenceTarget)) == null) {
            return;
        }
        TextAttributesKey key = textAttributesKey;
        AbstractHighlightingVisitor.highlightName$default(this, expression2.getProject(), this.computeHighlightingRangeForUsage(expression2, referenceTarget), key, null, 8, null);
    }

    private final TextAttributesKey attributeKeyForObjectAccess(KtSimpleNameExpression expression2) {
        ResolvedCall resolvedCall2;
        ResolvedCall resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.getBindingContext());
        return (resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null) instanceof FakeCallableDescriptorForObject ? this.attributeKeyForCallFromExtensions(expression2, (ResolvedCall<? extends CallableDescriptor>)resolvedCall2) : null;
    }

    private final DeclarationDescriptor computeReferencedDescriptor(KtSimpleNameExpression expression2) {
        NavigatablePsiElement callElement2;
        boolean strict$iv;
        PsiElement $this$getParentOfTypeAndBranch$iv;
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression2);
        if (!(referenceTarget instanceof ConstructorDescriptor)) {
            return referenceTarget;
        }
        PsiElement psiElement2 = (PsiElement)expression2;
        boolean bl = true;
        Function1 branch$iv = computeReferencedDescriptor.callElement.1.INSTANCE;
        boolean $i$f$getParentOfTypeAndBranch = false;
        PsiElement $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallExpression.class, (boolean)strict$iv);
        KtCallExpression ktCallExpression = (KtCallExpression)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement3, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv) : null);
        if (ktCallExpression != null) {
            v2 = (NavigatablePsiElement)ktCallExpression;
        } else {
            $this$getParentOfTypeAndBranch$iv = (PsiElement)expression2;
            strict$iv = true;
            branch$iv = computeReferencedDescriptor.callElement.2.INSTANCE;
            $i$f$getParentOfTypeAndBranch = false;
            $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
            $i$f$getParentOfType = false;
            PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtSuperTypeCallEntry.class, (boolean)strict$iv);
            v2 = callElement2 = (NavigatablePsiElement)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement4, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv) : null);
        }
        if (callElement2 != null) {
            return referenceTarget;
        }
        return (DeclarationDescriptor)((ConstructorDescriptor)referenceTarget).getContainingDeclaration();
    }

    private final TextRange computeHighlightingRangeForUsage(KtSimpleNameExpression expression2, DeclarationDescriptor referenceTarget) {
        TextRange expressionRange2 = expression2.getTextRange();
        if (!(referenceTarget instanceof ClassDescriptor) || ((ClassDescriptor)referenceTarget).getKind() != ClassKind.ANNOTATION_CLASS) {
            return expressionRange2;
        }
        Class[] classArray = new Class[]{KtValueArgumentList.class};
        KtAnnotationEntry annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), KtAnnotationEntry.class, (boolean)false, (Class[])classArray);
        KtAnnotationEntry ktAnnotationEntry = annotationEntry2;
        if (ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getAtSymbol()) == null) {
            return expressionRange2;
        }
        KtAnnotationEntry atSymbol = ktAnnotationEntry;
        return new TextRange(atSymbol.getTextRange().getStartOffset(), expression2.getTextRange().getEndOffset());
    }

    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        PsiElement identifier2 = classOrObject.getNameIdentifier();
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.CLASS, (Object)classOrObject);
        if (identifier2 != null && classDescriptor != null) {
            AbstractHighlightingVisitor abstractHighlightingVisitor = this;
            TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions((PsiElement)classOrObject, (DeclarationDescriptor)classDescriptor);
            if (textAttributesKey == null) {
                textAttributesKey = this.calculateClassReferenceAttributes(classDescriptor);
            }
            AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor, identifier2, textAttributesKey, null, 4, null);
        }
        super.visitClassOrObject(classOrObject);
    }

    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias2) {
        PsiElement identifier2 = typeAlias2.getNameIdentifier();
        TypeAliasDescriptor descriptor2 = (TypeAliasDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE_ALIAS, (Object)typeAlias2);
        if (identifier2 != null && descriptor2 != null) {
            TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions(identifier2, (DeclarationDescriptor)descriptor2);
            if (textAttributesKey == null) {
                textAttributesKey = this.calculateTypeAliasReferenceAttributes(descriptor2);
            }
            TextAttributesKey key = textAttributesKey;
            AbstractHighlightingVisitor.highlightName$default(this, identifier2, key, null, 4, null);
        }
        super.visitTypeAlias(typeAlias2);
    }

    public void visitDynamicType(@NotNull KtDynamicType type2) {
    }

    public void visitIntersectionType(@NotNull KtIntersectionType type2) {
        PsiElement psiElement2 = type2.getParent();
        if (psiElement2 != null) {
            PsiElement $this$safeAs$iv = psiElement2;
            boolean $i$f$safeAs = false;
            PsiElement psiElement3 = $this$safeAs$iv;
            if (!(psiElement3 instanceof KtTypeReference)) {
                psiElement3 = null;
            }
            if ((psiElement2 = (KtTypeReference)psiElement3) != null) {
                PsiElement $this$visitIntersectionType_u24lambda_u240 = psiElement2;
                boolean bl = false;
                AbstractHighlightingVisitor.highlightName$default(this, $this$visitIntersectionType_u24lambda_u240, KotlinHighlightingColors.TYPE_PARAMETER, null, 4, null);
            }
        }
        super.visitIntersectionType(type2);
    }

    private final TextAttributesKey calculateClassReferenceAttributes(ClassDescriptor target2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[target2.getKind().ordinal()]) {
            case 1 -> KotlinHighlightingColors.ANNOTATION;
            case 2 -> KotlinHighlightingColors.TRAIT;
            case 3 -> KotlinHighlightingColors.OBJECT;
            case 4 -> KotlinHighlightingColors.ENUM;
            case 5 -> KotlinHighlightingColors.ENUM_ENTRY;
            default -> target2.getModality() == Modality.ABSTRACT ? KotlinHighlightingColors.ABSTRACT_CLASS : KotlinHighlightingColors.CLASS;
        };
    }

    private final TextAttributesKey calculateTypeAliasReferenceAttributes(TypeAliasDescriptor target2) {
        ClassifierDescriptor aliasedTarget = target2.getExpandedType().getConstructor().getDeclarationDescriptor();
        return aliasedTarget instanceof ClassDescriptor && ((ClassDescriptor)aliasedTarget).getKind() == ClassKind.ANNOTATION_CLASS ? KotlinHighlightingColors.ANNOTATION : KotlinHighlightingColors.TYPE_ALIAS;
    }

    private final TextAttributesKey calculateDeclarationReferenceAttributes(DeclarationDescriptor target2) {
        DeclarationDescriptor declarationDescriptor = target2;
        return declarationDescriptor instanceof TypeParameterDescriptor ? KotlinHighlightingColors.TYPE_PARAMETER : (declarationDescriptor instanceof TypeAliasDescriptor ? this.calculateTypeAliasReferenceAttributes((TypeAliasDescriptor)target2) : (declarationDescriptor instanceof ClassDescriptor ? this.calculateClassReferenceAttributes((ClassDescriptor)target2) : null));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

