/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.script.ScriptDiagnosticFixProvider;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\n*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "computeOffsets", "Lkotlin/Pair;", "", "position", "Lkotlin/script/experimental/api/SourceCode$Location;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "coerceLineIn", "convertSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lkotlin/script/experimental/api/ScriptDiagnostic$Severity;", "offsetBy", "line", "col", "Factory", "Registrar", "kotlin.base.scripting"})
public final class ScriptExternalHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final KtFile file;

    public ScriptExternalHighlightingPass(@NotNull KtFile file2, @NotNull Document document) {
        super(file2.getProject(), document);
        this.file = file2;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Document document = this.getDocument();
        if (!this.file.isScript()) {
            return;
        }
        List<ScriptDiagnostic> reports = IdeScriptReportSink.Companion.getReports(this.file);
        Iterable $this$mapNotNull$iv = reports;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Annotation> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Annotation annotation;
            Throwable exception;
            Pair<Integer, Integer> pair;
            ScriptDiagnostic scriptDiagnostic;
            block11: {
                block10: {
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    scriptDiagnostic = (ScriptDiagnostic)element$iv$iv;
                    boolean bl2 = false;
                    pair = scriptDiagnostic.getLocation();
                    if (pair == null) break block10;
                    Pair<Integer, Integer> it = pair;
                    boolean bl3 = false;
                    Pair<Integer, Integer> pair2 = this.computeOffsets(document, (SourceCode.Location)it);
                    pair = pair2;
                    if (pair2 != null) break block11;
                }
                pair = TuplesKt.to((Object)0, (Object)0);
            }
            Pair<Integer, Integer> pair3 = pair;
            int startOffset = ((Number)pair3.component1()).intValue();
            int endOffset2 = ((Number)pair3.component2()).intValue();
            Throwable throwable = exception = scriptDiagnostic.getException();
            Object exceptionMessage = throwable != null ? " (" + throwable + ")" : "";
            String message2 = scriptDiagnostic.getMessage() + (String)exceptionMessage;
            if (this.convertSeverity(scriptDiagnostic.getSeverity()) == null) {
                Annotation annotation2;
                annotation = annotation2 = null;
            } else {
                HighlightSeverity highlightSeverity;
                int n;
                int n2;
                String string2 = message2;
                String string3 = message2;
                Annotation annotation3 = new Annotation(n2, n, highlightSeverity, string3, string2);
                annotation3.setFileLevelAnnotation(startOffset == endOffset2);
                for (ScriptDiagnosticFixProvider provider2 : ScriptDiagnosticFixProvider.Companion.getEP_NAME().getExtensionList()) {
                    Iterable $this$forEach$iv = provider2.provideFixes(scriptDiagnostic);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IntentionAction it = (IntentionAction)element$iv;
                        boolean bl = false;
                        annotation3.registerFix(it);
                    }
                }
                annotation = annotation3;
            }
            if (annotation == null) continue;
            Annotation it$iv$iv = annotation;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (Annotation)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(HighlightInfo.fromAnnotation((Annotation)it));
        }
        List infos = (List)destination$iv$iv2;
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private final Pair<Integer, Integer> computeOffsets(Document document, SourceCode.Location position) {
        int n;
        int n2;
        Integer n3 = position.getStart().getAbsolutePos();
        if (n3 != null) {
            n2 = n3;
        } else {
            ScriptExternalHighlightingPass $this$computeOffsets_u24lambda_u244 = this;
            boolean bl = false;
            int startLine = $this$computeOffsets_u24lambda_u244.coerceLineIn(position.getStart().getLine(), document);
            n2 = $this$computeOffsets_u24lambda_u244.offsetBy(document, startLine, position.getStart().getCol());
        }
        int startOffset = n2;
        Serializable serializable = position.getEnd();
        if (serializable != null && (serializable = ((SourceCode.Position)serializable).getAbsolutePos()) != null) {
            n = (Integer)serializable;
        } else {
            int n4;
            ScriptExternalHighlightingPass $this$computeOffsets_u24lambda_u245 = this;
            boolean bl = false;
            int startLine = $this$computeOffsets_u24lambda_u245.coerceLineIn(position.getStart().getLine(), document);
            SourceCode.Position position2 = position.getEnd();
            if (position2 != null) {
                int n5 = RangesKt.coerceAtLeast((int)position2.getLine(), (int)startLine);
                n4 = $this$computeOffsets_u24lambda_u245.coerceLineIn(n5, document);
            } else {
                n4 = startLine;
            }
            int endLine = n4;
            SourceCode.Position position3 = position.getEnd();
            n = RangesKt.coerceAtLeast((int)$this$computeOffsets_u24lambda_u245.offsetBy(document, endLine, position3 != null ? position3.getCol() : document.getLineEndOffset(endLine)), (int)startOffset);
        }
        int endOffset2 = n;
        return TuplesKt.to((Object)startOffset, (Object)endOffset2);
    }

    private final int coerceLineIn(int $this$coerceLineIn, Document document) {
        return RangesKt.coerceIn((int)$this$coerceLineIn, (int)0, (int)(document.getLineCount() - 1));
    }

    private final int offsetBy(Document $this$offsetBy, int line, int col) {
        return RangesKt.coerceIn((int)($this$offsetBy.getLineStartOffset(line) + col), (int)$this$offsetBy.getLineStartOffset(line), (int)$this$offsetBy.getLineEndOffset(line));
    }

    private final HighlightSeverity convertSeverity(ScriptDiagnostic.Severity $this$convertSeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convertSeverity.ordinal()]) {
            case 1 -> HighlightSeverity.ERROR;
            case 2 -> HighlightSeverity.ERROR;
            case 3 -> HighlightSeverity.WARNING;
            case 4 -> HighlightSeverity.INFORMATION;
            case 5 -> {
                boolean $i$f$isApplicationInternalMode = false;
                if (ApplicationManager.getApplication().isInternal()) {
                    yield HighlightSeverity.INFORMATION;
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.scripting"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar2, @NotNull Project project) {
            registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 1, false, false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.base.scripting"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
            if (!(file2 instanceof KtFile)) {
                return null;
            }
            return new ScriptExternalHighlightingPass((KtFile)file2, editor2.getDocument());
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

