/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightExitPointsHandlerFactoryKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightExitPointsHandlerFactory;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerFactoryBase;", "()V", "createHighlightUsagesHandler", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lcom/intellij/psi/PsiElement;", "Companion", "OnExitUsagesHandler", "kotlin.idea"})
public final class KotlinHighlightExitPointsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public HighlightUsagesHandlerBase<?> createHighlightUsagesHandler(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull PsiElement target2) {
        HighlightUsagesHandlerBase highlightUsagesHandlerBase = KotlinHighlightExitPointsHandlerFactory.Companion.getOnReturnOrThrowUsageHandler(editor2, file2, target2);
        if (highlightUsagesHandlerBase == null) {
            highlightUsagesHandlerBase = KotlinHighlightExitPointsHandlerFactory.Companion.getOnLambdaCallUsageHandler(editor2, file2, target2);
        }
        return highlightUsagesHandlerBase;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightExitPointsHandlerFactory$Companion;", "", "()V", "getOnLambdaCallUsageHandler", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lcom/intellij/psi/PsiElement;", "getOnReturnOrThrowUsageHandler", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final HighlightUsagesHandlerBase<?> getOnReturnOrThrowUsageHandler(Editor editor2, PsiFile file2, PsiElement target2) {
            Object object;
            PsiElement parent2 = target2.getParent();
            if (parent2 instanceof KtReturnExpression ? true : parent2 instanceof KtThrowExpression) {
                object = parent2;
            } else if (parent2 instanceof KtLabelReferenceExpression) {
                Class[] classArray = new Class[]{KtReturnExpression.class, KtThrowExpression.class, KtFunction.class};
                Class[] classArray2 = PsiTreeUtil.getParentOfType((PsiElement)target2, (Class[])classArray);
                if (classArray2 != null) {
                    Class[] it = classArray = classArray2;
                    boolean bl = false;
                    object = !(it instanceof KtFunction) ? classArray : null;
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
            PsiElement psiElement2 = object;
            KtExpression ktExpression = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            if (ktExpression == null) {
                return null;
            }
            KtExpression returnOrThrow = ktExpression;
            return new OnExitUsagesHandler(editor2, file2, returnOrThrow, false, 8, null);
        }

        private final HighlightUsagesHandlerBase<?> getOnLambdaCallUsageHandler(Editor editor2, PsiFile file2, PsiElement target2) {
            if (!(target2 instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)target2).getElementType(), (Object)KtTokens.IDENTIFIER)) {
                return null;
            }
            PsiElement psiElement2 = ((LeafPsiElement)target2).getParent();
            KtNameReferenceExpression ktNameReferenceExpression = psiElement2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement2 : null;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression refExpr = ktNameReferenceExpression;
            PsiElement psiElement3 = refExpr.getParent();
            KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression call = ktCallExpression;
            if (!Intrinsics.areEqual((Object)call.getCalleeExpression(), (Object)refExpr)) {
                return null;
            }
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)call.getLambdaArguments());
            if (ktLambdaArgument == null) {
                return null;
            }
            KtLambdaArgument lambda2 = ktLambdaArgument;
            KtLambdaExpression ktLambdaExpression2 = lambda2.getLambdaExpression();
            if (ktLambdaExpression2 == null || (ktLambdaExpression2 = ktLambdaExpression2.getFunctionLiteral()) == null) {
                return null;
            }
            KtLambdaExpression literal = ktLambdaExpression2;
            return new OnExitUsagesHandler(editor2, file2, (KtExpression)literal, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0016\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00132\u0016\u0010\u0017\u001a\u0012\u0012\u000e\b\u0000\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00130\u0018H\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightExitPointsHandlerFactory$OnExitUsagesHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lorg/jetbrains/kotlin/psi/KtExpression;", "highlightReferences", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getHighlightReferences", "()Z", "getTarget", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "computeUsages", "", "targets", "", "getTargets", "", "selectTargets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "kotlin.idea"})
    private static final class OnExitUsagesHandler
    extends HighlightUsagesHandlerBase<PsiElement> {
        @NotNull
        private final KtExpression target;
        private final boolean highlightReferences;

        public OnExitUsagesHandler(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull KtExpression target2, boolean highlightReferences) {
            super(editor2, file2);
            this.target = target2;
            this.highlightReferences = highlightReferences;
        }

        public /* synthetic */ OnExitUsagesHandler(Editor editor2, PsiFile psiFile2, KtExpression ktExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(editor2, psiFile2, ktExpression, bl);
        }

        @NotNull
        public final KtExpression getTarget() {
            return this.target;
        }

        public final boolean getHighlightReferences() {
            return this.highlightReferences;
        }

        @NotNull
        public List<KtExpression> getTargets() {
            return CollectionsKt.listOf((Object)this.target);
        }

        protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
            selectionConsumer.consume(targets);
        }

        /*
         * WARNING - void declaration
         */
        public void computeUsages(@NotNull List<? extends PsiElement> targets) {
            block8: {
                KtDeclarationWithBody relevantFunction;
                KtDeclarationWithBody ktDeclarationWithBody = relevantFunction = this.target instanceof KtFunctionLiteral ? (KtDeclarationWithBody)this.target : KotlinHighlightExitPointsHandlerFactoryKt.access$getRelevantDeclaration(this.target);
                if (this.target instanceof KtReturnExpression || this.target instanceof KtThrowExpression) {
                    KtDeclarationWithBody ktDeclarationWithBody2 = relevantFunction;
                    if (ktDeclarationWithBody2 instanceof KtNamedFunction) {
                        PsiElement psiElement2 = ((KtNamedFunction)relevantFunction).getNameIdentifier();
                        if (psiElement2 == null) {
                            psiElement2 = ((KtNamedFunction)relevantFunction).getFunKeyword();
                        }
                        if (psiElement2 != null) {
                            PsiElement it = psiElement2;
                            boolean bl = false;
                            this.addOccurrence(it);
                        }
                    } else if (ktDeclarationWithBody2 instanceof KtFunctionLiteral) {
                        PsiElement $this$getStrictParentOfType$iv = (PsiElement)relevantFunction;
                        boolean $i$f$getStrictParentOfType2 = false;
                        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLambdaArgument.class, (boolean)true);
                        if (ktLambdaArgument != null) {
                            KtExpression ktExpression;
                            void $this$getStrictParentOfType$iv2;
                            PsiElement $i$f$getStrictParentOfType2 = (PsiElement)ktLambdaArgument;
                            boolean $i$f$getStrictParentOfType3 = false;
                            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtCallExpression.class, (boolean)true);
                            if (ktCallExpression != null && (ktExpression = ktCallExpression.getCalleeExpression()) != null) {
                                KtExpression it = ktExpression;
                                boolean bl = false;
                                this.addOccurrence((PsiElement)it);
                            }
                        }
                    }
                }
                KtDeclarationWithBody ktDeclarationWithBody3 = relevantFunction;
                if (ktDeclarationWithBody3 == null) break block8;
                ktDeclarationWithBody3.accept((PsiElementVisitor)new KtVisitorVoid(relevantFunction, this){
                    final /* synthetic */ KtDeclarationWithBody $relevantFunction;
                    final /* synthetic */ OnExitUsagesHandler this$0;
                    {
                        this.$relevantFunction = $relevantFunction;
                        this.this$0 = $receiver;
                    }

                    public void visitKtElement(@NotNull KtElement element3) {
                        ProgressIndicatorProvider.checkCanceled();
                        element3.acceptChildren((PsiElementVisitor)this);
                    }

                    public void visitExpression(@NotNull KtExpression expression2) {
                        if (this.$relevantFunction instanceof KtFunctionLiteral && this.occurrenceForFunctionLiteralReturnExpression(expression2)) {
                            return;
                        }
                        super.visitExpression(expression2);
                    }

                    private final boolean occurrenceForFunctionLiteralReturnExpression(KtExpression expression2) {
                        if (!KtPsiUtil.isStatement((PsiElement)((PsiElement)expression2))) {
                            return false;
                        }
                        if (expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression || expression2 instanceof KtBlockExpression) {
                            return false;
                        }
                        BindingContext bindingContext2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)expression2, BodyResolveMode.FULL);
                        if (Intrinsics.areEqual((Object)bindingContext2, (Object)BindingContext.EMPTY) || !BindingContextUtilsKt.isUsedAsResultOfLambda((KtExpression)expression2, (BindingContext)bindingContext2)) {
                            return false;
                        }
                        if (!Intrinsics.areEqual((Object)KotlinHighlightExitPointsHandlerFactoryKt.access$getRelevantDeclaration(expression2), (Object)this.$relevantFunction)) {
                            return false;
                        }
                        OnExitUsagesHandler.access$addOccurrence(this.this$0, (PsiElement)expression2);
                        return true;
                    }

                    private final void visitReturnOrThrow(KtExpression expression2) {
                        if (Intrinsics.areEqual((Object)KotlinHighlightExitPointsHandlerFactoryKt.access$getRelevantDeclaration(expression2), (Object)this.$relevantFunction)) {
                            OnExitUsagesHandler.access$addOccurrence(this.this$0, (PsiElement)expression2);
                        }
                    }

                    public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
                        this.visitReturnOrThrow((KtExpression)expression2);
                    }

                    public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
                        this.visitReturnOrThrow((KtExpression)expression2);
                    }
                });
            }
        }

        public boolean highlightReferences() {
            return this.highlightReferences;
        }

        public static final /* synthetic */ void access$addOccurrence(OnExitUsagesHandler $this, PsiElement p0) {
            $this.addOccurrence(p0);
        }
    }
}

