/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingVisitorExtension;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/FunctionsHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "highlightCall", "", "callee", "Lcom/intellij/psi/PsiElement;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlin.base.fe10.highlighting"})
public final class FunctionsHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public FunctionsHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        if (expression2.getOperationReference().getIdentifier() != null) {
            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.getBindingContext());
            if (resolvedCall2 != null) {
                ResolvedCall resolvedCall3 = resolvedCall2;
                boolean bl = false;
                this.highlightCall((PsiElement)expression2.getOperationReference(), (ResolvedCall<? extends CallableDescriptor>)resolvedCall3);
            }
        }
        super.visitBinaryExpression(expression2);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        KtExpression callee2 = expression2.getCalleeExpression();
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.getBindingContext());
        if (callee2 instanceof KtReferenceExpression && !(callee2 instanceof KtCallExpression) && resolvedCall2 != null) {
            this.highlightCall((PsiElement)callee2, (ResolvedCall<? extends CallableDescriptor>)resolvedCall2);
        }
        super.visitCallExpression(expression2);
    }

    private final void highlightCall(PsiElement callee2, ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        block11: {
            TextAttributesKey textAttributesKey;
            Object object;
            TextAttributesKey textAttributesKey2;
            CallableDescriptor calleeDescriptor;
            block10: {
                calleeDescriptor = resolvedCall2.getResultingDescriptor();
                List extensions = KotlinHighlightingVisitorExtension.Companion.getEP_NAME().getExtensionList();
                for (KotlinHighlightingVisitorExtension extension2 : (Iterable)extensions) {
                    boolean bl = false;
                    TextAttributesKey textAttributesKey3 = extension2.highlightCall(callee2, resolvedCall2);
                    if (textAttributesKey3 == null) continue;
                    textAttributesKey2 = textAttributesKey3;
                    break block10;
                }
                textAttributesKey2 = object = null;
            }
            if (textAttributesKey2 == null) {
                if (Intrinsics.areEqual((Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)calleeDescriptor)), (Object)SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
                    object = KotlinHighlightingColors.KEYWORD;
                } else if (DynamicCallsKt.isDynamic((DeclarationDescriptor)((DeclarationDescriptor)calleeDescriptor))) {
                    object = KotlinHighlightingColors.DYNAMIC_FUNCTION_CALL;
                } else if (calleeDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)calleeDescriptor).isSuspend()) {
                    object = KotlinHighlightingColors.SUSPEND_FUNCTION_CALL;
                } else if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                    boolean containedInFunctionClassOrSubclass;
                    DeclarationDescriptor container = calleeDescriptor.getContainingDeclaration();
                    boolean bl = containedInFunctionClassOrSubclass = container instanceof ClassDescriptor && FunctionTypesKt.isFunctionTypeOrSubtype((KotlinType)((KotlinType)((ClassDescriptor)container).getDefaultType()));
                    object = containedInFunctionClassOrSubclass ? KotlinHighlightingColors.VARIABLE_AS_FUNCTION_CALL : KotlinHighlightingColors.VARIABLE_AS_FUNCTION_LIKE_CALL;
                } else {
                    object = calleeDescriptor instanceof ConstructorDescriptor ? KotlinHighlightingColors.CONSTRUCTOR_CALL : (!(calleeDescriptor instanceof FunctionDescriptor) ? null : (((FunctionDescriptor)calleeDescriptor).getExtensionReceiverParameter() != null ? KotlinHighlightingColors.EXTENSION_FUNCTION_CALL : (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)((DeclarationDescriptor)calleeDescriptor)) ? KotlinHighlightingColors.PACKAGE_FUNCTION_CALL : KotlinHighlightingColors.FUNCTION_CALL)));
                }
            }
            if ((textAttributesKey = object) == null) break block11;
            TextAttributesKey key = textAttributesKey;
            boolean bl = false;
            AbstractHighlightingVisitor.highlightName$default(this, callee2, key, null, 4, null);
        }
    }
}

