/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.highlighter.AnnotationHostKind;
import org.jetbrains.kotlin.idea.highlighter.DeclarationKindDetector;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001f\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020 2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020#2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020&2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020)2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DeclarationKindDetector;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "", "()V", "detect", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getDeclarationName", "", "Lcom/intellij/openapi/util/NlsSafe;", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitDeclaration", "", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lkotlin/Unit;)Ljava/lang/Void;", "visitDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitObjectDeclaration", "d", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "visitTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/highlighter/AnnotationHostKind;", "kotlin.base.fe10.highlighting"})
final class DeclarationKindDetector
extends KtVisitor<AnnotationHostKind, Unit> {
    @NotNull
    public static final DeclarationKindDetector INSTANCE = new DeclarationKindDetector();

    private DeclarationKindDetector() {
    }

    @Nullable
    public final AnnotationHostKind detect(@NotNull KtDeclaration declaration2) {
        return (AnnotationHostKind)declaration2.accept((KtVisitor)this, null);
    }

    @Nullable
    public Void visitDeclaration(@NotNull KtDeclaration declaration2, @Nullable Unit data2) {
        return null;
    }

    private final String getDeclarationName(KtDeclaration declaration2) {
        String string2 = declaration2.getName();
        if (string2 == null) {
            string2 = KotlinBaseFe10HighlightingBundle.message("declaration.name.anonymous", new Object[0]);
        }
        return string2;
    }

    @NotNull
    public AnnotationHostKind visitClass(@NotNull KtClass declaration2, @Nullable Unit data2) {
        String kind2 = declaration2.isInterface() ? KotlinBaseFe10HighlightingBundle.message("declaration.kind.interface", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("declaration.kind.class", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), true);
    }

    @NotNull
    public AnnotationHostKind visitNamedFunction(@NotNull KtNamedFunction declaration2, @Nullable Unit data2) {
        String kind2 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.fun", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), true);
    }

    @NotNull
    public AnnotationHostKind visitProperty(@NotNull KtProperty declaration2, @Nullable Unit data2) {
        String kind2 = declaration2.isVar() ? KotlinBaseFe10HighlightingBundle.message("declaration.kind.var", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("declaration.kind.val", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), true);
    }

    @NotNull
    public AnnotationHostKind visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration2, @Nullable Unit data2) {
        String kind2 = declaration2.isVar() ? KotlinBaseFe10HighlightingBundle.message("declaration.kind.var", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("declaration.kind.val", new Object[0]);
        String name2 = CollectionsKt.joinToString$default((Iterable)declaration2.getEntries(), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)visitDestructuringDeclaration.name.1.INSTANCE, (int)24, null);
        return new AnnotationHostKind(kind2, name2, true);
    }

    @NotNull
    public AnnotationHostKind visitTypeParameter(@NotNull KtTypeParameter declaration2, @Nullable Unit data2) {
        String kind2 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.type.parameter", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), false);
    }

    @NotNull
    public AnnotationHostKind visitEnumEntry(@NotNull KtEnumEntry declaration2, @Nullable Unit data2) {
        String kind2 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.enum.entry", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), true);
    }

    @NotNull
    public AnnotationHostKind visitParameter(@NotNull KtParameter declaration2, @Nullable Unit data2) {
        String kind2 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.parameter", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), false);
    }

    @NotNull
    public AnnotationHostKind visitSecondaryConstructor(@NotNull KtSecondaryConstructor declaration2, @Nullable Unit data2) {
        String kind2 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.secondary.constructor.of", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration2), true);
    }

    @Nullable
    public AnnotationHostKind visitObjectDeclaration(@NotNull KtObjectDeclaration d, @Nullable Unit data2) {
        AnnotationHostKind annotationHostKind;
        if (d.isCompanion()) {
            String kind2 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.companion.object", new Object[0]);
            Object[] objectArray = new Object[2];
            objectArray[0] = String.valueOf(d.getName());
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)d;
            boolean $i$f$getStrictParentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
            objectArray[1] = String.valueOf(ktClass != null ? ktClass.getName() : null);
            String name2 = KotlinBaseFe10HighlightingBundle.message("declaration.name.0.of.1", objectArray);
            annotationHostKind = new AnnotationHostKind(kind2, name2, true);
        } else if (d.getParent() instanceof KtObjectLiteralExpression) {
            annotationHostKind = null;
        } else {
            String kind3 = KotlinBaseFe10HighlightingBundle.message("declaration.kind.object", new Object[0]);
            annotationHostKind = new AnnotationHostKind(kind3, this.getDeclarationName((KtDeclaration)d), true);
        }
        return annotationHostKind;
    }
}

