/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.utils.DebugInfoUtil;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinHighlightingUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.highlighter.AbstractBindingContextAwareHighlightingPassBase;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass;", "Lorg/jetbrains/kotlin/idea/highlighter/AbstractBindingContextAwareHighlightingPassBase;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "annotator", "Lcom/intellij/lang/annotation/Annotator;", "getAnnotator", "()Lcom/intellij/lang/annotation/Annotator;", "DebugInfoAnnotator", "Factory", "Registrar", "kotlin.base.fe10.highlighting"})
public final class DebugInfoHighlightingPass
extends AbstractBindingContextAwareHighlightingPassBase {
    public DebugInfoHighlightingPass(@NotNull KtFile file2, @NotNull Document document) {
        super(file2, document);
    }

    @Override
    @NotNull
    protected Annotator getAnnotator() {
        return new DebugInfoAnnotator();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$DebugInfoAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "(Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass;)V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "kotlin.base.fe10.highlighting"})
    private final class DebugInfoAnnotator
    implements Annotator {
        public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
            if (element3 instanceof KtFile && !(element3 instanceof KtCodeFragment)) {
                try {
                    DebugInfoUtil.INSTANCE.markDebugAnnotations(element3, DebugInfoHighlightingPass.this.bindingContext(), new DebugInfoUtil.DebugInfoReporter(holder){
                        final /* synthetic */ AnnotationHolder $holder;
                        {
                            this.$holder = $holder;
                        }

                        public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                            DebugInfoAnnotator.access$annotate$errorAnnotation(this.$holder, (PsiElement)expression2, "Resolved to error element", KotlinHighlightingColors.RESOLVED_TO_ERROR);
                        }

                        public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                            DebugInfoAnnotator.annotate$errorAnnotation$default(this.$holder, (PsiElement)expression2, "Reference is not resolved to anything, but is not marked unresolved", null, 8, null);
                        }

                        public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target2) {
                            DebugInfoAnnotator.annotate$errorAnnotation$default(this.$holder, (PsiElement)expression2, "Reference marked as unresolved is actually resolved to " + target2, null, 8, null);
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    DebugInfoAnnotator.annotate$errorAnnotation(holder, element3, e.getClass().getCanonicalName() + ": " + e.getMessage(), null);
                    e.printStackTrace();
                }
            }
        }

        private static final void annotate$errorAnnotation(AnnotationHolder $holder, PsiElement expression2, String message2, TextAttributesKey textAttributes) {
            AnnotationBuilder annotationBuilder;
            AnnotationBuilder it = annotationBuilder = $holder.newAnnotation(HighlightSeverity.ERROR, "[DEBUG] " + message2).range(expression2.getTextRange());
            boolean bl = false;
            TextAttributesKey textAttributesKey = textAttributes;
            if (textAttributesKey != null) {
                TextAttributesKey ta = textAttributesKey;
                boolean bl2 = false;
                it.textAttributes(ta);
            }
            annotationBuilder.create();
        }

        static /* synthetic */ void annotate$errorAnnotation$default(AnnotationHolder annotationHolder2, PsiElement psiElement2, String string2, TextAttributesKey textAttributesKey, int n, Object object) {
            if ((n & 8) != 0) {
                textAttributesKey = KotlinHighlightingColors.DEBUG_INFO;
            }
            DebugInfoAnnotator.annotate$errorAnnotation(annotationHolder2, psiElement2, string2, textAttributesKey);
        }

        public static final /* synthetic */ void access$annotate$errorAnnotation(AnnotationHolder $holder, PsiElement expression2, String message2, TextAttributesKey textAttributes) {
            DebugInfoAnnotator.annotate$errorAnnotation($holder, expression2, message2, textAttributes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.base.fe10.highlighting"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
            if (!(file2 instanceof KtFile)) return null;
            if (!KotlinHighlightingUtils.shouldHighlightErrors((KtFile)file2)) return null;
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                boolean $i$f$isApplicationInternalMode = false;
                if (!ApplicationManager.getApplication().isInternal()) return null;
                if (!KotlinIdePlugin.INSTANCE.isSnapshot()) {
                    if (!KotlinIdePlugin.INSTANCE.isDev()) return null;
                }
            }
            if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)file2)) return null;
            boolean bl = true;
            boolean useDebugInfoPass = bl;
            if (!useDebugInfoPass) return null;
            Intrinsics.checkNotNull((Object)file2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            TextEditorHighlightingPass textEditorHighlightingPass = new DebugInfoHighlightingPass((KtFile)file2, editor2.getDocument());
            return textEditorHighlightingPass;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.fe10.highlighting"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar2, @NotNull Project project) {
            int[] nArray = new int[]{4};
            registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), nArray, null, false, -1);
        }
    }
}

