/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractAnnotationHolderHighlightingVisitor;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/base/highlighting/visitor/AbstractAnnotationHolderHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitArgument", "", "argument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitExpressionWithLabel", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitSuperTypeCallEntry", "call", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitTypeParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "willApplyRainbowHighlight", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "kotlin.base.highlighting"})
public final class BeforeResolveHighlightingVisitor
extends AbstractAnnotationHolderHighlightingVisitor {
    public BeforeResolveHighlightingVisitor(@NotNull AnnotationHolder holder) {
        super(holder);
    }

    public void visitElement(@NotNull PsiElement element3) {
        TextAttributesKey textAttributesKey;
        IElementType elementType = element3.getNode().getElementType();
        if (element3 instanceof KDocLink && !this.willApplyRainbowHighlight((KDocLink)element3)) {
            textAttributesKey = KotlinHighlightingColors.KDOC_LINK;
        } else if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
            IElementType iElementType = elementType;
            textAttributesKey = KtTokens.MODIFIER_KEYWORDS.contains(iElementType) ? KotlinHighlightingColors.BUILTIN_ANNOTATION : KotlinHighlightingColors.KEYWORD;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.SAFE_ACCESS)) {
            textAttributesKey = KotlinHighlightingColors.SAFE_ACCESS;
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EXCLEXCL)) {
            textAttributesKey = KotlinHighlightingColors.EXCLEXCL;
        } else {
            return;
        }
        TextAttributesKey attributes2 = textAttributesKey;
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, element3, null, attributes2, 2, null);
    }

    private final boolean willApplyRainbowHighlight(KDocLink element3) {
        if (!RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)((TextAttributesScheme)EditorColorsManager.getInstance().getGlobalScheme()), (Language)((Language)KotlinLanguage.INSTANCE))) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        KDocTag kDocTag = psiElement2 instanceof KDocTag ? (KDocTag)psiElement2 : null;
        return (kDocTag != null ? kDocTag.getKnownTag() : null) == KDocKnownTag.PARAM;
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        PsiElement arrow2;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral functionLiteral = lambdaExpression2.getFunctionLiteral();
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, functionLiteral.getLBrace(), null, KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW, 2, null);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, closingBrace, null, KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW, 2, null);
        }
        if ((arrow2 = functionLiteral.getArrow()) != null) {
            AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, arrow2, null, KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW, 2, null);
        }
    }

    public void visitArgument(@NotNull KtValueArgument argument2) {
        KtValueArgumentName ktValueArgumentName = argument2.getArgumentName();
        if (ktValueArgumentName == null) {
            return;
        }
        KtValueArgumentName argumentName2 = ktValueArgumentName;
        PsiElement psiElement2 = argument2.getEqualsToken();
        if (psiElement2 == null) {
            return;
        }
        PsiElement eq = psiElement2;
        AbstractHighlightingVisitor.createInfoAnnotation$default((AbstractHighlightingVisitor)this, new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)argumentName2)), PsiUtilsKt.getEndOffset((PsiElement)eq)), null, argument2.getParent().getParent() instanceof KtAnnotationEntry ? KotlinHighlightingColors.ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES : KotlinHighlightingColors.NAMED_ARGUMENT, 2, null);
    }

    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression2) {
        KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            AbstractHighlightingVisitor.highlightName$default(this, (PsiElement)targetLabel, KotlinHighlightingColors.LABEL, null, 4, null);
        }
    }

    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        KtTypeElement typeElement;
        KtConstructorCalleeExpression calleeExpression2 = call.getCalleeExpression();
        KtTypeReference ktTypeReference = calleeExpression2.getTypeReference();
        Object object = typeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (typeElement instanceof KtUserType) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtUserType)typeElement).getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression it = ktSimpleNameExpression;
                boolean bl = false;
                AbstractHighlightingVisitor.highlightName$default(this, (PsiElement)it, KotlinHighlightingColors.CONSTRUCTOR_CALL, null, 4, null);
            }
        }
        super.visitSuperTypeCallEntry(call);
    }

    public void visitTypeParameter(@NotNull KtTypeParameter parameter2) {
        PsiElement psiElement2 = parameter2.getNameIdentifier();
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            AbstractHighlightingVisitor.highlightName$default(this, it, KotlinHighlightingColors.TYPE_PARAMETER, null, 4, null);
        }
        super.visitTypeParameter(parameter2);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        this.highlightNamedDeclaration((KtNamedDeclaration)function2, KotlinHighlightingColors.FUNCTION_DECLARATION);
        super.visitNamedFunction(function2);
    }
}

