/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.overrides;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.intellij.usageView.UsageViewLongNameLocation;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.hierarchy.overrides.KotlinOverrideHierarchyProviderKt;
import org.jetbrains.kotlin.idea.hierarchy.overrides.KotlinOverrideTreeStructure;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0014J#\u0010\u0013\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0016*\b\u0012\u0002\b\u0003\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u0017H\u0014J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005H\u0014J\u0017\u0010\u001a\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0005H\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/overrides/KotlinOverrideHierarchyBrowser;", "Lcom/intellij/ide/hierarchy/MethodHierarchyBrowserBase;", "project", "Lcom/intellij/openapi/project/Project;", "baseElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)V", "createHierarchyTreeStructure", "Lcom/intellij/ide/hierarchy/HierarchyTreeStructure;", "typeName", "", "psiElement", "createLegendPanel", "Ljavax/swing/JPanel;", "createTrees", "", "trees", "", "Ljavax/swing/JTree;", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getContentDisplayName", "element", "getElementFromDescriptor", "Lorg/jetbrains/annotations/Nullable;", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "isApplicableElement", "", "kotlin.idea"})
public final class KotlinOverrideHierarchyBrowser
extends MethodHierarchyBrowserBase {
    public KotlinOverrideHierarchyBrowser(@NotNull Project project, @NotNull PsiElement baseElement) {
        super(project, baseElement);
    }

    protected void createTrees(@NotNull Map<? super String, ? super JTree> trees) {
        ActionManager actionManager = ActionManager.getInstance();
        JTree tree2 = this.createTree(false);
        PopupHandler.installPopupMenu((JComponent)tree2, (String)"MethodHierarchyPopupMenu", (String)"MethodHierarchyViewPopup");
        new MethodHierarchyBrowserBase.BaseOnThisMethodAction().registerCustomShortcutSet(actionManager.getAction("MethodHierarchy").getShortcutSet(), (JComponent)tree2);
        trees.put(MethodHierarchyBrowserBase.getMethodType(), tree2);
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return MethodHierarchyBrowserBase.createStandardLegendPanel((String)KotlinBundle.message("hierarchy.legend.member.is.defined.in.class", new Object[0]), (String)KotlinBundle.message("hierarchy.legend.member.defined.in.superclass", new Object[0]), (String)KotlinBundle.message("hierarchy.legend.member.should.be.defined", new Object[0]));
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        return descriptor2.getPsiElement();
    }

    protected boolean isApplicableElement(@NotNull PsiElement psiElement2) {
        return KotlinOverrideHierarchyProviderKt.isOverrideHierarchyElement(psiElement2);
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement2) {
        HierarchyTreeStructure hierarchyTreeStructure;
        if (Intrinsics.areEqual((Object)typeName, (Object)MethodHierarchyBrowserBase.getMethodType())) {
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            hierarchyTreeStructure = new KotlinOverrideTreeStructure(this.myProject, (KtCallableDeclaration)psiElement2);
        } else {
            hierarchyTreeStructure = null;
        }
        return hierarchyTreeStructure;
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> getComparator() {
        return JavaHierarchyUtil.getComparator((Project)this.myProject);
    }

    @Nullable
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element3) {
        PsiElement targetElement = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
        if (targetElement instanceof KtDeclaration) {
            return ElementDescriptionUtil.getElementDescription((PsiElement)targetElement, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE));
        }
        return super.getContentDisplayName(typeName, element3);
    }
}

