/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider;", "()V", "getOriginalPsiClassOrCreateLightClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "module", "Lcom/intellij/openapi/module/Module;", "getTarget", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetByContainingElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getTargetByReference", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    private final PsiClass getOriginalPsiClassOrCreateLightClass(KtClassOrObject classOrObject, Module module2) {
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null) {
            ClassId javaClassId;
            Module module3 = module2;
            if (JvmPlatformKt.isJvm((TargetPlatform)(module3 != null ? TargetPlatformDetectorUtils.getPlatform(module3) : null)) && (javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2.toUnsafe())) != null) {
                return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
            }
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)classOrObject);
        return ktLightClass != null ? (PsiClass)ktLightClass : (PsiClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)classOrObject);
    }

    private final PsiClass getTargetByReference(Project project, Editor editor2, Module module2) {
        PsiClass psiClass;
        PsiElement target2 = TargetElementUtil.findTargetElement((Editor)editor2, (int)TargetElementUtil.getInstance().getAllAccepted());
        if (target2 instanceof PsiClass) {
            psiClass = (PsiClass)target2;
        } else if (target2 instanceof KtConstructor) {
            psiClass = this.getOriginalPsiClassOrCreateLightClass(((KtConstructor)target2).getContainingClassOrObject(), module2);
        } else if (target2 instanceof KtClassOrObject) {
            psiClass = this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target2, module2);
        } else if (target2 instanceof KtNamedFunction) {
            String functionName = ((KtNamedFunction)target2).getName();
            FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny((KtNamedFunction)target2, BodyResolveMode.FULL);
            if (functionDescriptor2 == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            KotlinType kotlinType = functionDescriptor3.getReturnType();
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            String returnTypeText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2);
            if (!Intrinsics.areEqual((Object)returnTypeText, (Object)functionName)) {
                return null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((Iterable)KotlinClassShortNameIndex.INSTANCE.get(functionName, project, KotlinScopeUtils.allScope(project)));
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            psiClass = this.getOriginalPsiClassOrCreateLightClass(classOrObject, module2);
        } else {
            psiClass = null;
        }
        return psiClass;
    }

    private final PsiClass getTargetByContainingElement(Editor editor2, PsiFile file2) {
        PsiElement element3;
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement $this$getNonStrictParentOfType$iv = element3 = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return this.getOriginalPsiClassOrCreateLightClass(classOrObject, GenericPsiUtils.getModule((PsiElement)file2));
    }

    @Nullable
    public PsiClass getTarget(@NotNull DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor2 = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor2 != null) {
            PsiClass psiElement2;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
            if (psiFile2 == null) {
                return null;
            }
            PsiFile file2 = psiFile2;
            if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)file2)) {
                return null;
            }
            PsiClass psiClass = this.getTargetByReference(project2, editor2, GenericPsiUtils.getModule((PsiElement)file2));
            if (psiClass == null) {
                psiClass = this.getTargetByContainingElement(editor2, file2);
            }
            if ((psiElement2 = psiClass) instanceof PsiNamedElement && psiElement2.getName() == null) {
                return null;
            }
            return psiElement2;
        }
        PsiElement element3 = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element3 instanceof KtClassOrObject) {
            return this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)element3, GenericPsiUtils.getModule(element3));
        }
        return null;
    }
}

