/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleModuleBuilderUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0000\u00a8\u0006\f"}, d2={"addBrowserSupport", "", "module", "Lcom/intellij/openapi/module/Module;", "browserConfiguration", "", "kotlinDsl", "", "getNewFileWriter", "Ljava/io/Writer;", "relativeDir", "fileName", "kotlin.gradle.gradle-java"})
public final class GradleKotlinFrameworkSupportProviderUtilsKt {
    @Nullable
    public static final Writer getNewFileWriter(@NotNull Module module2, @NotNull String relativeDir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)relativeDir, (String)"relativeDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object object = GradleModuleBuilderUtilsKt.getGradleModuleBuilder(module2);
        if (object == null || (object = object.getContentEntryPath()) == null) {
            return null;
        }
        Object contentEntryPath = object;
        if (((CharSequence)contentEntryPath).length() == 0) {
            return null;
        }
        File contentRootDir = new File((String)contentEntryPath);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentRootDir);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile modelContentRootDir = virtualFile;
        VirtualFile virtualFile2 = VfsUtil.createDirectoryIfMissing((VirtualFile)modelContentRootDir, (String)relativeDir);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile dir = virtualFile2;
        if (dir.findChild(fileName) != null) {
            return null;
        }
        VirtualFile virtualFile3 = dir.createChildData(null, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"dir.createChildData(null, fileName)");
        VirtualFile file2 = virtualFile3;
        OutputStream outputStream = file2.getOutputStream(null);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"file.getOutputStream(null)");
        OutputStream outputStream2 = outputStream;
        Charset charset = Charsets.UTF_8;
        return new OutputStreamWriter(outputStream2, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addBrowserSupport(@NotNull Module module2) {
        Writer it2;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Writer writer = GradleKotlinFrameworkSupportProviderUtilsKt.getNewFileWriter(module2, "src/main/resources", "index.html");
        if (writer != null) {
            closeable = writer;
            throwable = null;
            try {
                it2 = (Writer)closeable;
                boolean bl = false;
                it2.write(((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)("\n                <!DOCTYPE html>\n                <html lang=\"en\">\n                <head>\n                    <meta charset=\"UTF-8\">\n                    <title>" + module2.getName() + "</title>\n                    <script src=\"" + module2.getName() + ".js\"></script>\n                </head>\n                <body>\n                \n                </body>\n                </html>\n            ")))).toString());
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Writer writer2 = GradleKotlinFrameworkSupportProviderUtilsKt.getNewFileWriter(module2, "src/main/kotlin", "main.kt");
        if (writer2 != null) {
            closeable = writer2;
            throwable = null;
            try {
                it2 = (Writer)closeable;
                boolean bl = false;
                it2.write(((Object)StringsKt.trim((CharSequence)"import kotlinx.browser.document\n\nfun main() {\n    document.write(\"Hello, world!\")\n}")).toString());
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final String browserConfiguration(boolean kotlinDsl) {
        String receiver2 = kotlinDsl ? "" : "it.";
        return StringsKt.trimIndent((String)("\n        webpackTask {\n            cssSupport {\n                " + receiver2 + "enabled.set(true)\n            }\n        }\n        \n        runTask {\n            cssSupport {\n                " + receiver2 + "enabled.set(true)\n            }\n        }\n        \n        testTask {\n            useKarma {\n                useChromeHeadless()\n                webpackConfig.cssSupport {\n                    " + receiver2 + "enabled.set(true)\n                }\n            }\n        }\n    "));
    }
}

