/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.diagnostic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \b2\u00060\u0001j\u0002`\u0002:\u0001\bB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "kotlin.gradle.gradle"})
public final class CompilerInternalError
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("at (.+)\\.(.+)\\(([^:]+)(:?)(\\d*)\\)$");
    @NotNull
    private static final String CAUSED_BY_PREFIX = "Caused by:";

    public CompilerInternalError(@NotNull String message2, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(message2, cause);
    }

    public /* synthetic */ CompilerInternalError(String string2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        this(string2, throwable);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jf\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e2:\u0010\u000f\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00110\u00100\fj\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00110\u0010`\u000eH\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError$Companion;", "", "()V", "CAUSED_BY_PREFIX", "", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "joinIntoException", "Lorg/jetbrains/kotlin/idea/gradle/diagnostic/CompilerInternalError;", "message", "currentStack", "Ljava/util/ArrayList;", "Ljava/lang/StackTraceElement;", "Lkotlin/collections/ArrayList;", "reasonsList", "Lkotlin/Pair;", "", "parseStack", "", "rawStack", "parseStackTraceLine", "line", "kotlin.gradle.gradle"})
    public static final class Companion {
        private Companion() {
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher2 = STACK_TRACE_ELEMENT_PATTERN.matcher(((Object)StringsKt.trim((CharSequence)line)).toString());
            if (matcher2.matches()) {
                String declaringClass = matcher2.group(1);
                String methodName2 = matcher2.group(2);
                String fileName = matcher2.group(3);
                String lineNumberString = matcher2.group(5);
                Intrinsics.checkNotNullExpressionValue((Object)lineNumberString, (String)"lineNumberString");
                int lineNumber = StringsKt.isBlank((CharSequence)lineNumberString) ? 0 : Integer.parseInt(lineNumberString);
                return new StackTraceElement(declaringClass, methodName2, fileName, lineNumber);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Throwable> parseStack(@NotNull List<String> rawStack) {
            Intrinsics.checkNotNullParameter(rawStack, (String)"rawStack");
            Ref.ObjectRef currentMessage = new Ref.ObjectRef();
            Ref.ObjectRef currentStack = new Ref.ObjectRef();
            currentStack.element = new ArrayList();
            Ref.ObjectRef currentReasonsList = new Ref.ObjectRef();
            currentReasonsList.element = new ArrayList();
            ArrayList<CompilerInternalError> exceptions = new ArrayList<CompilerInternalError>();
            org.jetbrains.kotlin.idea.gradle.diagnostic.CompilerInternalError$Companion.parseStack$clearValues((Ref.ObjectRef<String>)currentMessage, (Ref.ObjectRef<ArrayList<StackTraceElement>>)currentStack, (Ref.ObjectRef<ArrayList<Pair<String, List<StackTraceElement>>>>)currentReasonsList);
            Iterable $this$forEach$iv = rawStack;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                block11: {
                    String it;
                    block10: {
                        void message2;
                        it = (String)element$iv;
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0 || StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"...", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"Attachments:", (boolean)false, (int)2, null)) continue;
                        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"---", (boolean)false, (int)2, null)) {
                            exceptions.add(Companion.joinIntoException((String)currentMessage.element, (ArrayList)currentStack.element, (ArrayList)currentReasonsList.element));
                            org.jetbrains.kotlin.idea.gradle.diagnostic.CompilerInternalError$Companion.parseStack$clearValues((Ref.ObjectRef<String>)currentMessage, (Ref.ObjectRef<ArrayList<StackTraceElement>>)currentStack, (Ref.ObjectRef<ArrayList<Pair<String, List<StackTraceElement>>>>)currentReasonsList);
                            continue;
                        }
                        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"at", (boolean)false, (int)2, null)) {
                            if (Companion.parseStackTraceLine(((Object)StringsKt.trim((CharSequence)it)).toString()) != null) {
                                StackTraceElement stackTraceElement;
                                StackTraceElement it2 = stackTraceElement;
                                boolean bl2 = false;
                                ((ArrayList)currentStack.element).add(it2);
                            }
                            continue;
                        }
                        if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)CompilerInternalError.CAUSED_BY_PREFIX, (boolean)false, (int)2, null)) {
                            ArrayList arrayList = (ArrayList)currentReasonsList.element;
                            String string2 = (String)currentMessage.element;
                            if (string2 == null) {
                                string2 = "TODO";
                            }
                            arrayList.add(new Pair((Object)string2, currentStack.element));
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)StringsKt.trim((CharSequence)it)).toString().substring(10), (String)"this as java.lang.String).substring(startIndex)");
                            currentMessage.element = currentMessage.element;
                            currentStack.element = new ArrayList();
                            continue;
                        }
                        Ref.ObjectRef objectRef = currentMessage;
                        object = (String)currentMessage.element;
                        if (object == null) break block10;
                        String bl2 = object;
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl3 = false;
                        String string3 = (String)message2 + " " + ((Object)StringsKt.trim((CharSequence)it)).toString();
                        objectRef = objectRef2;
                        object = string3;
                        if (string3 != null) break block11;
                    }
                    object = ((Object)StringsKt.trim((CharSequence)it)).toString();
                }
                objectRef.element = object;
            }
            exceptions.add(this.joinIntoException((String)currentMessage.element, (ArrayList)currentStack.element, (ArrayList)currentReasonsList.element));
            return exceptions;
        }

        /*
         * WARNING - void declaration
         */
        private final CompilerInternalError joinIntoException(String message2, ArrayList<StackTraceElement> currentStack, ArrayList<Pair<String, List<StackTraceElement>>> reasonsList) {
            void it;
            CompilerInternalError compilerInternalError;
            Ref.ObjectRef exception = new Ref.ObjectRef();
            String string2 = message2;
            if (string2 == null) {
                string2 = "TODO";
            }
            CompilerInternalError compilerInternalError2 = compilerInternalError = new CompilerInternalError(string2, null, 2, null);
            Ref.ObjectRef objectRef = exception;
            boolean bl = false;
            Collection $this$toTypedArray$iv = currentStack;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            it.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
            objectRef.element = compilerInternalError;
            Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)reasonsList);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void it2;
                CompilerInternalError compilerInternalError3;
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                String message3 = (String)pair.component1();
                List stacktrace = (List)pair.component2();
                CompilerInternalError compilerInternalError4 = compilerInternalError3 = new CompilerInternalError(message3, (Throwable)exception.element);
                Ref.ObjectRef objectRef2 = exception;
                boolean bl3 = false;
                Collection $this$toTypedArray$iv2 = stacktrace;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                it2.setStackTrace(thisCollection$iv2.toArray(new StackTraceElement[0]));
                objectRef2.element = compilerInternalError3;
            }
            return (CompilerInternalError)exception.element;
        }

        private static final void parseStack$clearValues(Ref.ObjectRef<String> currentMessage, Ref.ObjectRef<ArrayList<StackTraceElement>> currentStack, Ref.ObjectRef<ArrayList<Pair<String, List<StackTraceElement>>>> currentReasonsList) {
            currentMessage.element = null;
            currentStack.element = new ArrayList();
            currentReasonsList.element = new ArrayList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

