/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration.klib;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

@IntellijInternalApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/klib/KotlinNativeLibrariesFixer;", "", "()V", "applyTo", "", "ownerNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "fixLibraryDependencyLevel", "oldDependencyNode", "Lcom/intellij/openapi/externalSystem/model/project/LibraryDependencyData;", "fixLibraryName", "libraryData", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "kotlin.gradle.gradle"})
public final class KotlinNativeLibrariesFixer {
    @NotNull
    public static final KotlinNativeLibrariesFixer INSTANCE = new KotlinNativeLibrariesFixer();

    private KotlinNativeLibrariesFixer() {
    }

    public final void applyTo(@NotNull DataNode<? extends GradleSourceSetData> ownerNode, @NotNull DataNode<ProjectData> ideProject) {
        Intrinsics.checkNotNullParameter(ownerNode, (String)"ownerNode");
        Intrinsics.checkNotNullParameter(ideProject, (String)"ideProject");
        for (DataNode libraryDependencyNode : ExternalSystemApiUtil.findAll(ownerNode, (Key)ProjectKeys.LIBRARY_DEPENDENCY)) {
            AbstractExternalEntityData abstractExternalEntityData = ((LibraryDependencyData)libraryDependencyNode.getData()).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)abstractExternalEntityData, (String)"libraryDependencyNode.data.target");
            LibraryData libraryData = (LibraryData)abstractExternalEntityData;
            String string2 = libraryData.getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"libraryData.internalName");
            if (!StringsKt.startsWith$default((String)string2, (String)"Gradle: Kotlin/Native", (boolean)false, (int)2, null)) continue;
            this.fixLibraryName(libraryData);
            GradleProjectResolverUtil.linkProjectLibrary(null, ideProject, (LibraryData)libraryData);
            Intrinsics.checkNotNullExpressionValue((Object)libraryDependencyNode, (String)"libraryDependencyNode");
            this.fixLibraryDependencyLevel((DataNode<LibraryDependencyData>)libraryDependencyNode);
        }
    }

    private final void fixLibraryName(LibraryData libraryData) {
        String string2 = libraryData.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"libraryData.internalName");
        libraryData.setInternalName(StringsKt.substringAfter$default((String)string2, (String)"Gradle: ", null, (int)2, null));
    }

    private final void fixLibraryDependencyLevel(DataNode<LibraryDependencyData> oldDependencyNode) {
        LibraryDependencyData libraryDependencyData;
        Object object = oldDependencyNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldDependencyNode.data");
        LibraryDependencyData oldDependency = (LibraryDependencyData)object;
        if (oldDependency.getLevel() == LibraryLevel.PROJECT) {
            return;
        }
        LibraryDependencyData $this$fixLibraryDependencyLevel_u24lambda_u240 = libraryDependencyData = new LibraryDependencyData(oldDependency.getOwnerModule(), (LibraryData)oldDependency.getTarget(), LibraryLevel.PROJECT);
        boolean bl = false;
        $this$fixLibraryDependencyLevel_u24lambda_u240.setScope(oldDependency.getScope());
        $this$fixLibraryDependencyLevel_u24lambda_u240.setOrder(oldDependency.getOrder());
        $this$fixLibraryDependencyLevel_u24lambda_u240.setExported(oldDependency.isExported());
        LibraryDependencyData newDependency = libraryDependencyData;
        DataNode dataNode = oldDependencyNode.getParent();
        if (dataNode == null) {
            return;
        }
        DataNode parentNode = dataNode;
        Collection collection = oldDependencyNode.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"oldDependencyNode.children");
        Collection childNodes = collection;
        DataNode dataNode2 = parentNode.createChild(oldDependencyNode.getKey(), (Object)newDependency);
        Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"parentNode.createChild(o\u2026yNode.key, newDependency)");
        DataNode newDependencyNode = dataNode2;
        for (DataNode child2 : childNodes) {
            newDependencyNode.addChild(child2);
        }
        oldDependencyNode.clear(true);
    }
}

