/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;

public class FrameworksCompatibilityUtils {
    private FrameworksCompatibilityUtils() {
    }

    public static void suggestRemoveIncompatibleFramework(@NotNull ModifiableRootModel rootModel, @NotNull Set<? extends LibraryKind> frameworkLibraryKinds, @NotNull String presentableName) {
        ArrayList<OrderEntry> existingEntries = new ArrayList<OrderEntry>();
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library2;
            if (!(entry instanceof LibraryOrderEntry) || (library2 = ((LibraryOrderEntry)entry).getLibrary()) == null) continue;
            for (LibraryKind libraryKind : frameworkLibraryKinds) {
                if (!LibraryPresentationManager.getInstance().isLibraryOfKind(Arrays.asList(library2.getFiles(OrderRootType.CLASSES)), libraryKind)) continue;
                existingEntries.add(entry);
            }
        }
        FrameworksCompatibilityUtils.removeWithConfirm(rootModel, existingEntries, KotlinJvmBundle.message("frameworks.remove.conflict.question", presentableName), KotlinJvmBundle.message("frameworks.remove.conflict.title", new Object[0]));
    }

    private static void removeWithConfirm(ModifiableRootModel rootModel, List<OrderEntry> orderEntries, @NlsContexts.DialogMessage String message2, @NlsContexts.DialogTitle String title) {
        int result2;
        if (!orderEntries.isEmpty() && (result2 = Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getWarningIcon())) == 0) {
            for (OrderEntry entry : orderEntries) {
                rootModel.removeOrderEntry(entry);
            }
        }
    }
}

