/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter.trailingComma;

import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContextKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u0004\u0018\u00010\b*\u00020\bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaHelper;", "", "()V", "LEFT_BARRIERS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "RIGHT_BARRIERS", "lastSignificantChild", "Lcom/intellij/psi/PsiElement;", "getLastSignificantChild", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "elementAfterLastElement", "commaOwner", "Lorg/jetbrains/kotlin/psi/KtElement;", "elementBeforeFirstElement", "findInvalidCommas", "", "lineBreakIsMissing", "", "trailingCommaExists", "trailingCommaExistsOrCanExist", "psiElement", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "trailingCommaOrLastElement", "takeIfIsNotError", "kotlin.formatter"})
public final class TrailingCommaHelper {
    @NotNull
    public static final TrailingCommaHelper INSTANCE = new TrailingCommaHelper();
    @NotNull
    private static final TokenSet RIGHT_BARRIERS;
    @NotNull
    private static final TokenSet LEFT_BARRIERS;

    private TrailingCommaHelper() {
    }

    @NotNull
    public final List<PsiElement> findInvalidCommas(@NotNull KtElement commaOwner2) {
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        PsiElement psiElement2 = commaOwner2.getFirstChild();
        List list2 = psiElement2 != null && (sequence4 = PsiUtilsKt.siblings$default((PsiElement)psiElement2, (boolean)false, (boolean)false, (int)1, null)) != null && (sequence3 = SequencesKt.filter((Sequence)sequence4, (Function1)findInvalidCommas.1.INSTANCE)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, (Function1)findInvalidCommas.2.INSTANCE)) != null ? SequencesKt.toList((Sequence)sequence2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean trailingCommaExistsOrCanExist(@NotNull PsiElement psiElement2, @NotNull CodeStyleSettings settings2) {
        return TrailingCommaContextKt.commaExistsOrMayExist(TrailingCommaContext.Companion.create(psiElement2), CodeStyleUtilsKt.getKotlinCustomSettings(settings2));
    }

    public final boolean trailingCommaExists(@NotNull KtElement commaOwner2) {
        boolean bl;
        KtElement ktElement = commaOwner2;
        if (ktElement instanceof KtFunctionLiteral) {
            KtParameterList ktParameterList = ((KtFunctionLiteral)commaOwner2).getValueParameterList();
            bl = (ktParameterList != null ? ktParameterList.getTrailingComma() : null) != null;
        } else if (ktElement instanceof KtWhenEntry) {
            bl = ((KtWhenEntry)commaOwner2).getTrailingComma() != null;
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            bl = ((KtDestructuringDeclaration)commaOwner2).getTrailingComma() != null;
        } else {
            PsiElement psiElement2 = this.trailingCommaOrLastElement(commaOwner2);
            bl = psiElement2 != null ? FormatterUtilKt.isComma(psiElement2) : false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PsiElement trailingCommaOrLastElement(@NotNull KtElement commaOwner2) {
        IElementType iElementType;
        PsiElement psiElement2 = this.getLastSignificantChild((PsiElement)commaOwner2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement lastChild = psiElement2;
        IElementType iElementType2 = PsiUtil.getElementType((PsiElement)lastChild);
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.COMMA)) {
            return lastChild;
        }
        boolean withSelf = !RIGHT_BARRIERS.contains(iElementType2);
        iElementType2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments((PsiElement)lastChild, (boolean)withSelf);
        if (iElementType2 == null) return null;
        IElementType it = iElementType = iElementType2;
        boolean bl = false;
        if (LEFT_BARRIERS.contains(PsiUtil.getElementType((PsiElement)it))) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        IElementType iElementType3 = iElementType;
        IElementType iElementType4 = iElementType3;
        if (iElementType4 == null) return null;
        PsiElement psiElement3 = this.takeIfIsNotError((PsiElement)iElementType4);
        return psiElement3;
    }

    public final boolean lineBreakIsMissing(@NotNull KtElement commaOwner2) {
        if (!this.trailingCommaExists(commaOwner2)) {
            return false;
        }
        PsiElement first2 = this.elementBeforeFirstElement(commaOwner2);
        PsiElement psiElement2 = first2;
        boolean bl = psiElement2 != null && (psiElement2 = PsiUtilsKt.nextLeaf((PsiElement)psiElement2, (boolean)true)) != null ? !FormatterUtilKt.isLineBreak(psiElement2) : false;
        if (bl) {
            return true;
        }
        PsiElement last = this.elementAfterLastElement(commaOwner2);
        PsiElement psiElement3 = last;
        return psiElement3 != null && (psiElement3 = PsiUtilsKt.prevLeaf((PsiElement)psiElement3, (boolean)true)) != null ? !FormatterUtilKt.isLineBreak(psiElement3) : false;
    }

    @Nullable
    public final PsiElement elementBeforeFirstElement(@NotNull KtElement commaOwner2) {
        Object object;
        KtElement ktElement = commaOwner2;
        if (ktElement instanceof KtParameterList) {
            PsiElement parent2 = ((KtParameterList)commaOwner2).getParent();
            object = parent2 instanceof KtFunctionLiteral ? ((KtFunctionLiteral)parent2).getLBrace() : ((KtParameterList)commaOwner2).getLeftParenthesis();
        } else if (ktElement instanceof KtWhenEntry) {
            PsiElement $this$cast$iv = ((KtWhenEntry)commaOwner2).getParent();
            boolean $i$f$cast = false;
            PsiElement psiElement2 = $this$cast$iv;
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
            }
            object = ((KtWhenExpression)psiElement2).getOpenBrace();
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            object = ((KtDestructuringDeclaration)commaOwner2).getLPar();
        } else {
            PsiElement psiElement3 = commaOwner2.getFirstChild();
            object = psiElement3 != null ? this.takeIfIsNotError(psiElement3) : null;
        }
        return object;
    }

    @Nullable
    public final PsiElement elementAfterLastElement(@NotNull KtElement commaOwner2) {
        Object object;
        KtElement ktElement = commaOwner2;
        if (ktElement instanceof KtParameterList) {
            PsiElement parent2 = ((KtParameterList)commaOwner2).getParent();
            object = parent2 instanceof KtFunctionLiteral ? ((KtFunctionLiteral)parent2).getArrow() : ((KtParameterList)commaOwner2).getRightParenthesis();
        } else if (ktElement instanceof KtWhenEntry) {
            object = ((KtWhenEntry)commaOwner2).getArrow();
        } else if (ktElement instanceof KtDestructuringDeclaration) {
            object = ((KtDestructuringDeclaration)commaOwner2).getRPar();
        } else {
            PsiElement psiElement2 = commaOwner2.getLastChild();
            object = psiElement2 != null ? this.takeIfIsNotError(psiElement2) : null;
        }
        return object;
    }

    private final PsiElement takeIfIsNotError(PsiElement $this$takeIfIsNotError) {
        PsiElement psiElement2;
        PsiElement it = psiElement2 = $this$takeIfIsNotError;
        boolean bl = false;
        return !PsiTreeUtil.hasErrorElements((PsiElement)it) ? psiElement2 : null;
    }

    private final PsiElement getLastSignificantChild(PsiElement $this$lastSignificantChild) {
        PsiElement psiElement2 = $this$lastSignificantChild;
        return psiElement2 instanceof KtWhenEntry ? ((KtWhenEntry)$this$lastSignificantChild).getArrow() : (psiElement2 instanceof KtDestructuringDeclaration ? ((KtDestructuringDeclaration)$this$lastSignificantChild).getRPar() : $this$lastSignificantChild.getLastChild());
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{(IElementType)KtTokens.RBRACKET, (IElementType)KtTokens.RPAR, (IElementType)KtTokens.RBRACE, (IElementType)KtTokens.GT, (IElementType)KtTokens.ARROW};
        RIGHT_BARRIERS = TokenSet.create((IElementType[])iElementTypeArray);
        iElementTypeArray = new IElementType[]{(IElementType)KtTokens.LBRACKET, (IElementType)KtTokens.LPAR, (IElementType)KtTokens.LBRACE, (IElementType)KtTokens.LT};
        LEFT_BARRIERS = TokenSet.create((IElementType[])iElementTypeArray);
    }
}

