/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0003\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/ProjectCodeStyleImporter;", "", "()V", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "codeStyleStr", "", "", "predefinedCodeStyle", "Lorg/jetbrains/kotlin/idea/formatter/KotlinPredefinedCodeStyle;", "kotlin.formatter"})
public final class ProjectCodeStyleImporter {
    @NotNull
    public static final ProjectCodeStyleImporter INSTANCE = new ProjectCodeStyleImporter();

    private ProjectCodeStyleImporter() {
    }

    public final boolean apply(@NotNull Project project, @Nullable String codeStyleStr) {
        boolean bl;
        String string2 = codeStyleStr;
        if (Intrinsics.areEqual((Object)string2, (Object)"obsolete")) {
            this.apply(project, KotlinObsoleteCodeStyle.Companion.getINSTANCE());
            bl = true;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"official")) {
            this.apply(project, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void apply(@NotNull Project project, @NotNull KotlinPredefinedCodeStyle predefinedCodeStyle) {
        CodeStyleSettings customSettings = CodeStyle.getSettings((Project)project);
        if (Intrinsics.areEqual((Object)predefinedCodeStyle.getCodeStyleId(), (Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults(customSettings))) {
            return;
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        CodeStyleSettings projectSettingsUpdated = CodeStyle.usesOwnSettings((Project)project) ? settingsManager.cloneSettings(customSettings) : CodeStyle.getDefaultSettings();
        predefinedCodeStyle.apply(projectSettingsUpdated);
        CodeStyle.setMainProjectSettings((Project)project, (CodeStyleSettings)projectSettingsUpdated);
        settingsManager.notifyCodeStyleSettingsChanged();
    }
}

