/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;

public abstract class NodeAlignmentStrategy
extends CommonAlignmentStrategy {
    private static final NodeAlignmentStrategy NULL_STRATEGY = NodeAlignmentStrategy.fromTypes(AlignmentStrategy.wrap(null, (IElementType[])new IElementType[0]));

    public static NodeAlignmentStrategy getNullStrategy() {
        return NULL_STRATEGY;
    }

    public static NodeAlignmentStrategy fromTypes(AlignmentStrategy strategy) {
        return new AlignmentStrategyWrapper(strategy);
    }

    @Override
    @Nullable
    public abstract Alignment getAlignment(@NotNull ASTNode var1);

    private static class AlignmentStrategyWrapper
    extends NodeAlignmentStrategy {
        private final AlignmentStrategy internalStrategy;

        public AlignmentStrategyWrapper(@NotNull AlignmentStrategy internalStrategy) {
            this.internalStrategy = internalStrategy;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull ASTNode node2) {
            ASTNode parent2 = node2.getTreeParent();
            if (parent2 != null) {
                return this.internalStrategy.getAlignment(parent2.getElementType(), node2.getElementType());
            }
            return this.internalStrategy.getAlignment(node2.getElementType());
        }
    }
}

