/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.similarity;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesProvider;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.findUsages.similarity.KotlinSimilarityFeaturesExtractor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0017J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/similarity/KotlinUsageSimilarityFeaturesProvider;", "Lcom/intellij/usages/similarity/features/UsageSimilarityFeaturesProvider;", "()V", "collectFeaturesForFunctionSignature", "Lcom/intellij/usages/similarity/bag/Bag;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "context", "Lcom/intellij/psi/PsiElement;", "getContext", "element", "getFeatures", "usage", "toFeature", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.idea"})
public final class KotlinUsageSimilarityFeaturesProvider
implements UsageSimilarityFeaturesProvider {
    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public Bag getFeatures(@NotNull PsiElement usage) {
        Bag features = new Bag();
        if (!Registry.is((String)"similarity.find.usages.kotlin.clustering.enable")) {
            return features;
        }
        PsiElement context2 = this.getContext(usage);
        if (context2 instanceof KtParameter || context2 instanceof KtFunction) {
            void $this$parentOfType$iv;
            PsiElement psiElement2 = context2;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
            if (ktFunction != null) {
                KtFunction it = ktFunction;
                boolean bl = false;
                features.addAll(this.collectFeaturesForFunctionSignature(it, context2));
            }
        } else if (context2 != null) {
            features.addAll(new KotlinSimilarityFeaturesExtractor(usage, context2).getFeatures());
        }
        return features;
    }

    private final Bag collectFeaturesForFunctionSignature(KtFunction function2, PsiElement context2) {
        Bag bag;
        Bag $this$collectFeaturesForFunctionSignature_u24lambda_u242 = bag = new Bag();
        boolean bl = false;
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("OVERRIDE: " + function2.hasModifier(KtTokens.OVERRIDE_KEYWORD));
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("NAME: " + function2.getName());
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("FUNCTION_CLASS: " + Reflection.getOrCreateKotlinClass(function2.getClass()));
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("RETURN_TYPE: " + this.toFeature(function2.getTypeReference()));
        $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("RECEIVER_TYPE_REFERENCE: " + (function2.getReceiverTypeReference() != null));
        Iterable $this$forEach$iv = function2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl2 = false;
            $this$collectFeaturesForFunctionSignature_u24lambda_u242.add("PARAMETER_TYPE: " + (Intrinsics.areEqual((Object)it, (Object)context2) ? "USAGE: " : "") + this.toFeature(it.getTypeReference()));
        }
        return bag;
    }

    /*
     * WARNING - void declaration
     */
    private final String toFeature(KtTypeReference typeReference2) {
        String string2;
        Object object = typeReference2;
        if (object != null && (object = object.getText()) != null) {
            void $this$filterNotTo$iv$iv;
            Object $this$filterNot$iv = object;
            boolean $i$f$filterNot = false;
            CharSequence charSequence2 = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int j = 0; j < $this$filterNotTo$iv$iv.length(); ++j) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(j);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string3 = ((StringBuilder)destination$iv$iv).toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"filterNotTo(StringBuilder(), predicate).toString()");
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public final PsiElement getContext(@NotNull PsiElement element3) {
        return PsiTreeUtil.findFirstParent((PsiElement)element3, (boolean)false, KotlinUsageSimilarityFeaturesProvider::getContext$lambda$4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getContext$lambda$4(PsiElement e) {
        if (e instanceof KtStatementExpression) return true;
        PsiElement psiElement2 = e;
        if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof KtBlockExpression) return true;
        if (!(e instanceof KtImportDirective)) return false;
        return true;
    }
}

