/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindPropertyUsagesDialog
extends JavaFindUsagesDialog<KotlinPropertyFindUsagesOptions> {
    private StateRestoringCheckBox readAccesses;
    private StateRestoringCheckBox writeAccesses;
    private StateRestoringCheckBox searchForBase;
    private StateRestoringCheckBox overrideUsages;
    private StateRestoringCheckBox expectedUsages;
    private StateRestoringCheckBox searchInOverridingMethods;
    private static final boolean disableComponentAndDestructionSearchDefault = false;
    private static final String optionName = "kotlin.disable.search.component.and.destruction";

    public KotlinFindPropertyUsagesDialog(PsiElement element3, Project project, KotlinPropertyFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super(element3, project, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @NotNull
    protected KotlinPropertyFindUsagesOptions getFindUsagesOptions() {
        return (KotlinPropertyFindUsagesOptions)this.myFindUsagesOptions;
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbToSkipResultsWhenOneUsage;
    }

    public void calcFindUsagesOptions(KotlinPropertyFindUsagesOptions options2) {
        super.calcFindUsagesOptions((JavaFindUsagesOptions)options2);
        options2.isReadAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses);
        options2.isWriteAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses);
        options2.isSearchForBaseAccessors = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.searchForBase);
        options2.isSearchInOverridingMethods = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.searchInOverridingMethods);
        options2.setSearchOverrides(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.overrideUsages));
        if (this.expectedUsages != null) {
            options2.setSearchExpected(this.expectedUsages.isSelected());
        }
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        KotlinPropertyFindUsagesOptions options2 = this.getFindUsagesOptions();
        this.readAccesses = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.property.readers.checkbox", new Object[0]), options2.isReadAccess, findWhatPanel, true);
        this.writeAccesses = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.property.writers.checkbox", new Object[0]), options2.isWriteAccess, findWhatPanel, true);
        return findWhatPanel;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        Utils.configureLabelComponent(coloredComponent, (KtNamedDeclaration)this.getPsiElement());
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        KtNamedDeclaration property2 = (KtNamedDeclaration)this.getPsiElement();
        if (property2.hasModifier(KtTokens.OVERRIDE_KEYWORD) || property2.hasModifier(KtTokens.OPEN_KEYWORD) || property2 instanceof KtParameter && !((KtParameter)property2).hasValOrVar()) {
            this.searchForBase = this.createCheckbox(JavaBundle.message((String)"find.options.include.accessors.base.checkbox", (Object[])new Object[0]), this.getFindUsagesOptions().isSearchForBaseAccessors, true);
            JPanel decoratedCheckbox = new ComponentPanelBuilder((JComponent)this.searchForBase).withComment(JavaBundle.message((String)"find.options.include.accessors.base.checkbox.comment", (Object[])new Object[0])).createPanel();
            decoratedCheckbox.setAlignmentX(0.0f);
            optionsPanel.add(decoratedCheckbox);
        }
        if (property2 instanceof KtParameter) {
            this.searchInOverridingMethods = this.addCheckboxToPanel(JavaBundle.message((String)"find.options.search.overriding.methods.checkbox", (Object[])new Object[0]), this.getFindUsagesOptions().isSearchInOverridingMethods, optionsPanel, true);
        }
        boolean isAbstract = property2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean isOpen = property2.hasModifier(KtTokens.OPEN_KEYWORD);
        if (isOpen || isAbstract) {
            this.overrideUsages = this.addCheckboxToPanel(isAbstract ? KotlinBundle.message("find.declaration.implementing.properties.checkbox", new Object[0]) : KotlinBundle.message("find.declaration.overriding.properties.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        boolean isActual = PsiUtilsKt.hasActualModifier((KtModifierListOwner)property2);
        KotlinPropertyFindUsagesOptions options2 = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinBundle.message("find.usages.checkbox.name.expected.properties", new Object[0]), options2.getSearchExpected(), optionsPanel, false);
        }
        if (KotlinFindPropertyUsagesDialog.isDataClassConstructorProperty(property2)) {
            JCheckBox dataClassComponentCheckBox = new JCheckBox(KotlinBundle.message("find.usages.checkbox.text.fast.data.class.component.search", new Object[0]));
            dataClassComponentCheckBox.setToolTipText(KotlinBundle.message("find.usages.tool.tip.text.disable.search.for.data.class.components.and.destruction.declarations.project.wide.setting", new Object[0]));
            Project project = property2.getProject();
            dataClassComponentCheckBox.setSelected(KotlinFindPropertyUsagesDialog.getDisableComponentAndDestructionSearch(project));
            optionsPanel.add(dataClassComponentCheckBox);
            dataClassComponentCheckBox.addActionListener(___ -> KotlinFindPropertyUsagesDialog.setDisableComponentAndDestructionSearch(project, dataClassComponentCheckBox.isSelected()));
        }
    }

    protected void update() {
        this.setOKActionEnabled(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses) || KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses));
    }

    public static boolean getDisableComponentAndDestructionSearch(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(optionName, false);
    }

    public static void setDisableComponentAndDestructionSearch(Project project, boolean value2) {
        PropertiesComponent.getInstance((Project)project).setValue(optionName, value2, false);
    }

    private static boolean isDataClassConstructorProperty(KtNamedDeclaration declaration2) {
        PsiElement parent2;
        if (declaration2 instanceof KtParameter && (parent2 = declaration2.getParent()) instanceof KtParameterList && (parent2 = parent2.getParent()) instanceof KtPrimaryConstructor && (parent2 = parent2.getParent()) instanceof KtClass) {
            return ((KtClass)parent2).isData();
        }
        return false;
    }
}

