/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindFunctionUsagesDialog
extends FindMethodUsagesDialog {
    private StateRestoringCheckBox expectedUsages;

    public KotlinFindFunctionUsagesDialog(PsiMethod method, Project project, KotlinFunctionFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super((PsiElement)method, project, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @NotNull
    protected KotlinFunctionFindUsagesOptions getFindUsagesOptions() {
        return (KotlinFunctionFindUsagesOptions)this.myFindUsagesOptions;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        coloredComponent.append(KotlinSearchUsagesSupport.Companion.formatJavaOrLightMethod((PsiMethod)this.myPsiElement));
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = super.createFindWhatPanel();
        if (findWhatPanel != null) {
            Utils.renameCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.implementing.methods.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.declaration.implementing.methods.checkbox", new Object[0]));
            Utils.renameCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.overriding.methods.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.declaration.overriding.methods.checkbox", new Object[0]));
        }
        return findWhatPanel;
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        PsiElement element3;
        super.addUsagesOptions(optionsPanel);
        if (!Utils.renameCheckbox(optionsPanel, JavaBundle.message((String)"find.options.include.overloaded.methods.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.declaration.include.overloaded.methods.checkbox", new Object[0]))) {
            this.addCheckboxToPanel(KotlinBundle.message("find.declaration.include.overloaded.methods.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        KtNamedDeclaration function2 = (element3 = LightClassUtilsKt.getUnwrapped((PsiElement)this.getPsiElement())) instanceof KtNamedDeclaration ? (KtNamedDeclaration)element3 : (KtDeclaration)((KtLightMethod)element3).getKotlinOrigin();
        boolean isActual = function2 != null && PsiUtilsKt.hasActualModifier((KtModifierListOwner)function2);
        KotlinFunctionFindUsagesOptions options2 = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinBundle.message("find.usages.checkbox.name.expected.functions", new Object[0]), options2.getSearchExpected(), optionsPanel, false);
        }
    }

    public void calcFindUsagesOptions(JavaMethodFindUsagesOptions options2) {
        super.calcFindUsagesOptions(options2);
        KotlinFunctionFindUsagesOptions kotlinOptions = (KotlinFunctionFindUsagesOptions)options2;
        if (this.expectedUsages != null) {
            kotlinOptions.setSearchExpected(this.expectedUsages.isSelected());
        }
    }
}

