/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindClassUsagesDialog
extends FindClassUsagesDialog {
    private StateRestoringCheckBox constructorUsages;
    private StateRestoringCheckBox derivedClasses;
    private StateRestoringCheckBox derivedTraits;
    private StateRestoringCheckBox expectedUsages;
    private static final Key<KtClassOrObject> ORIGINAL_CLASS = Key.create((String)"ORIGINAL_CLASS");

    public KotlinFindClassUsagesDialog(KtClassOrObject classOrObject, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super((PsiElement)KotlinFindClassUsagesDialog.getRepresentingPsiClass(classOrObject), project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @NotNull
    private static PsiClass getRepresentingPsiClass(@NotNull KtClassOrObject classOrObject) {
        KtClass klass2;
        KtLightClass lightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)classOrObject);
        if (lightClass != null) {
            return lightClass;
        }
        PsiElementFactory factory2 = PsiElementFactory.getInstance((Project)classOrObject.getProject());
        String name2 = classOrObject.getName();
        if (name2 == null || name2.isEmpty()) {
            name2 = KotlinBundle.message("find.usages.class.name.anonymous", new Object[0]);
        }
        PsiClass javaClass = classOrObject instanceof KtClass ? (!(klass2 = (KtClass)classOrObject).isInterface() ? factory2.createClass(name2) : (klass2.isAnnotation() ? factory2.createAnnotationType(name2) : factory2.createInterface(name2))) : factory2.createClass(name2);
        javaClass.getModifierList().setModifierProperty("final", !(classOrObject instanceof KtClass) || !KotlinSearchUsagesSupport.Companion.isInheritable((KtClass)classOrObject));
        javaClass.putUserData(ORIGINAL_CLASS, (Object)classOrObject);
        return javaClass;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = super.createFindWhatPanel();
        assert (findWhatPanel != null);
        Utils.renameCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.methods.usages.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.declaration.functions.usages.checkbox", new Object[0]));
        Utils.renameCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.fields.usages.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.declaration.properties.usages.checkbox", new Object[0]));
        Utils.removeCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.implementing.classes.checkbox", (Object[])new Object[0]));
        Utils.removeCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.derived.interfaces.checkbox", (Object[])new Object[0]));
        Utils.removeCheckbox(findWhatPanel, JavaBundle.message((String)"find.what.derived.classes.checkbox", (Object[])new Object[0]));
        this.derivedClasses = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.derived.classes.checkbox", new Object[0]), this.getFindUsagesOptions().isDerivedClasses, findWhatPanel, true);
        this.derivedTraits = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.derived.interfaces.checkbox", new Object[0]), this.getFindUsagesOptions().isDerivedInterfaces, findWhatPanel, true);
        this.constructorUsages = this.addCheckboxToPanel(KotlinBundle.message("find.declaration.constructor.usages.checkbox", new Object[0]), this.getFindUsagesOptions().getSearchConstructorUsages(), findWhatPanel, true);
        return findWhatPanel;
    }

    @NotNull
    protected KotlinClassFindUsagesOptions getFindUsagesOptions() {
        return (KotlinClassFindUsagesOptions)super.getFindUsagesOptions();
    }

    @Nullable
    private KtClassOrObject getOriginalClass() {
        PsiElement klass2 = LightClassUtilsKt.getUnwrapped((PsiElement)this.getPsiElement());
        if (klass2 == null) {
            return null;
        }
        return klass2 instanceof KtClassOrObject ? (KtClassOrObject)klass2 : (KtClassOrObject)klass2.getUserData(ORIGINAL_CLASS);
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        KtClassOrObject klass2 = this.getOriginalClass();
        boolean isActual = klass2 != null && PsiUtilsKt.hasActualModifier((KtModifierListOwner)klass2);
        KotlinClassFindUsagesOptions options2 = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel(KotlinBundle.message("find.usages.checkbox.name.expected.classes", new Object[0]), options2.getSearchExpected(), optionsPanel, false);
        }
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        KtClassOrObject originalClass = this.getOriginalClass();
        if (originalClass != null) {
            coloredComponent.append(KotlinSearchUsagesSupport.Companion.formatClass(originalClass));
        }
    }

    protected void update() {
        super.update();
        if (!this.isOKActionEnabled() && (this.constructorUsages.isSelected() || this.derivedTraits.isSelected() || this.derivedClasses.isSelected())) {
            this.setOKActionEnabled(true);
        }
    }

    public void calcFindUsagesOptions(JavaClassFindUsagesOptions options2) {
        super.calcFindUsagesOptions(options2);
        KotlinClassFindUsagesOptions kotlinOptions = (KotlinClassFindUsagesOptions)options2;
        kotlinOptions.setSearchConstructorUsages(this.constructorUsages.isSelected());
        kotlinOptions.isDerivedClasses = this.derivedClasses.isSelected();
        kotlinOptions.isDerivedInterfaces = this.derivedTraits.isSelected();
        if (this.expectedUsages != null) {
            kotlinOptions.setSearchExpected(this.expectedUsages.isSelected());
        }
    }
}

