/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.idea.formatter.DocumentUtilsKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "isGlobalPreviousDollarInString", "", "kotlinLTTyped", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "Companion", "KotlinTypedHandlerTokenSets", "kotlin.idea"})
public final class KotlinTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean kotlinLTTyped;
    private boolean isGlobalPreviousDollarInString;
    @NotNull
    private static final Key<Integer> PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY = Key.create((String)"PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY");

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (!(file2 instanceof KtFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        char c2 = c;
        if (c2 == ')') {
            KotlinTypedHandler.Companion.dataClassValParameterInsert(project, editor2, file2, true);
        } else if (c2 == '<') {
            this.kotlinLTTyped = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.shouldAutoCloseAngleBracket(editor2.getCaretModel().getOffset(), editor2);
            KotlinTypedHandler.Companion.autoPopupParameterInfo(project, editor2);
        } else if (c2 == '>') {
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.handleKotlinGTInsert(editor2)) {
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (c2 == '{') {
            int offset2 = editor2.getCaretModel().getOffset();
            if (offset2 == 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator iterator = editor2.getHighlighter().createIterator(offset2 - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || !KotlinTypedHandlerTokenSets.INSTANCE.getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER().contains(iterator.getTokenType())) {
                AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor2, null);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            int tokenBeforeBraceOffset = iterator.getStart();
            Document document = editor2.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiElement leaf = file2.findElementAt(offset2);
            if (leaf != null) {
                ASTNode nonWhitespaceSibling;
                PsiElement parent2 = leaf.getParent();
                if (parent2 != null && KotlinTypedHandlerTokenSets.INSTANCE.getCONTROL_FLOW_EXPRESSIONS().contains(parent2.getNode().getElementType()) && (nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)leaf.getNode())) != null && nonWhitespaceSibling.getStartOffset() == tokenBeforeBraceOffset) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)"{", (boolean)false, (boolean)true);
                    TypedHandler.indentBrace((Project)project, (Editor)editor2, (char)'{');
                    return TypedHandlerDelegate.Result.STOP;
                }
                if (Intrinsics.areEqual((Object)leaf.getText(), (Object)"}") && parent2 instanceof KtFunctionLiteral && document.getLineNumber(offset2) == document.getLineNumber(parent2.getTextRange().getStartOffset())) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)"{} ", (boolean)false, (boolean)false);
                    editor2.getCaretModel().moveToOffset(offset2 + 1);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        } else if (c2 == '.') {
            KotlinTypedHandler.Companion.autoPopupMemberLookup(project, editor2);
        } else if (c2 == ':') {
            KotlinTypedHandler.Companion.autoPopupCallableReferenceLookup(project, editor2);
        } else if (c2 == '[') {
            KotlinTypedHandler.Companion.autoPopupParameterInfo(project, editor2);
        } else if (c2 == '@') {
            KotlinTypedHandler.Companion.autoPopupAt(project, editor2);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        block29: {
            block30: {
                boolean isSimpleLongTemplateEntry;
                LeafPsiElement $this$safeAs$iv;
                PsiElement previousElement;
                int offset2;
                Integer previousDollarInStringOffset;
                block32: {
                    block31: {
                        LeafPsiElement leafPsiElement;
                        block28: {
                            if (!(file2 instanceof KtFile)) {
                                return TypedHandlerDelegate.Result.CONTINUE;
                            }
                            previousDollarInStringOffset = null;
                            if (this.isGlobalPreviousDollarInString) {
                                this.isGlobalPreviousDollarInString = false;
                                previousDollarInStringOffset = (Integer)editor2.getUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY);
                            }
                            editor2.putUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY, null);
                            if (this.kotlinLTTyped) {
                                this.kotlinLTTyped = false;
                                LtGtTypingUtils.handleKotlinAutoCloseLT(editor2);
                                return TypedHandlerDelegate.Result.STOP;
                            }
                            if (c != ',' && c != ')') break block28;
                            KotlinTypedHandler.Companion.dataClassValParameterInsert(project, editor2, file2, false);
                            break block29;
                        }
                        if (c != '{' || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) break block30;
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
                        offset2 = editor2.getCaretModel().getOffset();
                        previousElement = file2.findElementAt(offset2 - 1);
                        if (!(previousElement instanceof LeafPsiElement) || ((LeafPsiElement)previousElement).getElementType() != KtTokens.LONG_TEMPLATE_ENTRY_START) break block29;
                        PsiElement psiElement2 = file2.findElementAt(offset2);
                        if (psiElement2 == null) break block31;
                        PsiElement psiElement3 = psiElement2;
                        boolean $i$f$safeAs = false;
                        LeafPsiElement leafPsiElement2 = $this$safeAs$iv;
                        if (!(leafPsiElement2 instanceof LeafPsiElement)) {
                            leafPsiElement2 = null;
                        }
                        if ((leafPsiElement = (LeafPsiElement)leafPsiElement2) == null) break block31;
                        LeafPsiElement it = $i$f$safeAs = leafPsiElement;
                        boolean bl = false;
                        Object object = $this$safeAs$iv = Intrinsics.areEqual((Object)it.getElementType(), (Object)KtTokens.IDENTIFIER) ? $i$f$safeAs : null;
                        if ($this$safeAs$iv != null) break block32;
                    }
                    boolean bl = false;
                    editor2.getDocument().insertString(offset2, (CharSequence)"}");
                    return TypedHandlerDelegate.Result.STOP;
                }
                LeafPsiElement identifier2 = $this$safeAs$iv;
                PsiElement lastInLongTemplateEntry = ((LeafPsiElement)previousElement).getParent().getLastChild();
                boolean bl = isSimpleLongTemplateEntry = lastInLongTemplateEntry instanceof LeafPsiElement && ((LeafPsiElement)lastInLongTemplateEntry).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_END && lastInLongTemplateEntry.getParent().getTextLength() == identifier2.getTextLength() + 3;
                if (!isSimpleLongTemplateEntry) {
                    boolean isAfterTypedDollar;
                    boolean bl2 = isAfterTypedDollar = previousDollarInStringOffset != null && previousDollarInStringOffset == offset2 - 1;
                    if (isAfterTypedDollar) {
                        editor2.getDocument().insertString(offset2, (CharSequence)"}");
                        return TypedHandlerDelegate.Result.STOP;
                    }
                }
                break block29;
            }
            if (c == ':') {
                if (org.jetbrains.kotlin.idea.editor.KotlinTypedHandler$Companion.autoIndentCase$default(Companion, editor2, project, file2, KtClassOrObject.class, false, 16, null) || org.jetbrains.kotlin.idea.editor.KotlinTypedHandler$Companion.autoIndentCase$default(Companion, editor2, project, file2, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '.') {
                if (org.jetbrains.kotlin.idea.editor.KotlinTypedHandler$Companion.autoIndentCase$default(Companion, editor2, project, file2, KtQualifiedExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '|') {
                if (org.jetbrains.kotlin.idea.editor.KotlinTypedHandler$Companion.autoIndentCase$default(Companion, editor2, project, file2, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '&') {
                if (org.jetbrains.kotlin.idea.editor.KotlinTypedHandler$Companion.autoIndentCase$default(Companion, editor2, project, file2, KtOperationReferenceExpression.class, false, 16, null)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
            } else if (c == '$') {
                int offset3 = editor2.getCaretModel().getOffset();
                PsiElement element3 = file2.findElementAt(offset3);
                if (element3 instanceof LeafPsiElement && ((LeafPsiElement)element3).getElementType() == KtTokens.REGULAR_STRING_PART) {
                    editor2.putUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY, (Object)offset3);
                    this.isGlobalPreviousDollarInString = true;
                }
            } else if (c == '(' && KotlinTypedHandler.Companion.autoIndentCase(editor2, project, file2, KtPropertyAccessor.class, false)) {
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler$KotlinTypedHandlerTokenSets;", "", "()V", "CONTROL_FLOW_EXPRESSIONS", "Lcom/intellij/psi/tree/TokenSet;", "getCONTROL_FLOW_EXPRESSIONS", "()Lcom/intellij/psi/tree/TokenSet;", "SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER", "getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER", "kotlin.idea"})
    private static final class KotlinTypedHandlerTokenSets {
        @NotNull
        public static final KotlinTypedHandlerTokenSets INSTANCE = new KotlinTypedHandlerTokenSets();
        @NotNull
        private static final TokenSet CONTROL_FLOW_EXPRESSIONS;
        @NotNull
        private static final TokenSet SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER;

        private KotlinTypedHandlerTokenSets() {
        }

        @NotNull
        public final TokenSet getCONTROL_FLOW_EXPRESSIONS() {
            return CONTROL_FLOW_EXPRESSIONS;
        }

        @NotNull
        public final TokenSet getSUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER() {
            return SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.IF, KtNodeTypes.ELSE, KtNodeTypes.FOR, KtNodeTypes.WHILE, KtNodeTypes.TRY};
            CONTROL_FLOW_EXPRESSIONS = TokenSet.create((IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{(IElementType)KtTokens.RPAR, (IElementType)KtTokens.ELSE_KEYWORD, (IElementType)KtTokens.TRY_KEYWORD};
            SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER = TokenSet.create((IElementType[])iElementTypeArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\b\b\u0002\u0010\u0012\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0018\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\tH\u0002J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandler$Companion;", "", "()V", "PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "autoIndentCase", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "klass", "Ljava/lang/Class;", "forFirstElement", "autoPopupAt", "", "autoPopupCallableReferenceLookup", "autoPopupMemberLookup", "autoPopupParameterInfo", "dataClassValParameterInsert", "beforeType", "endsWith", "chars", "", "offset", "text", "", "isLabelCompletion", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final void autoPopupParameterInfo(Project project, Editor editor2) {
            int offset2 = editor2.getCaretModel().getOffset();
            if (offset2 == 0) {
                return;
            }
            HighlighterIterator iterator = editor2.getHighlighter().createIterator(offset2 - 1);
            IElementType tokenType = iterator.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType) || tokenType == KtTokens.REGULAR_STRING_PART || tokenType == KtTokens.OPEN_QUOTE || tokenType == KtTokens.CHARACTER_LITERAL) {
                return;
            }
            AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor2, null);
        }

        private final void autoPopupMemberLookup(Project project, Editor editor2) {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, arg_0 -> Companion.autoPopupMemberLookup$lambda$0((Function1)new Function1<PsiFile, Boolean>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiFile file2) {
                    int offset2 = this.$editor.getCaretModel().getOffset();
                    PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
                    if (psiElement2 == null) {
                        return false;
                    }
                    PsiElement lastToken = psiElement2;
                    IElementType elementType = lastToken.getNode().getElementType();
                    if (elementType == KtTokens.DOT || elementType == KtTokens.SAFE_ACCESS) {
                        return true;
                    }
                    if (elementType == KtTokens.REGULAR_STRING_PART && lastToken.getTextRange().getStartOffset() == offset2 - 1) {
                        PsiElement prevSibling2 = lastToken.getParent().getPrevSibling();
                        return prevSibling2 instanceof KtSimpleNameStringTemplateEntry;
                    }
                    return false;
                }
            }, arg_0));
        }

        private final boolean isLabelCompletion(CharSequence chars, int offset2) {
            return this.endsWith(chars, offset2, "this@") || this.endsWith(chars, offset2, "return@") || this.endsWith(chars, offset2, "break@") || this.endsWith(chars, offset2, "continue@");
        }

        private final void autoPopupAt(Project project, Editor editor2) {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, arg_0 -> Companion.autoPopupAt$lambda$1((Function1)new Function1<PsiFile, Boolean>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiFile file2) {
                    int offset2 = this.$editor.getCaretModel().getOffset();
                    CharSequence chars = this.$editor.getDocument().getCharsSequence();
                    PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
                    if (psiElement2 == null || (psiElement2 = psiElement2.getNode()) == null || (psiElement2 = psiElement2.getElementType()) == null) {
                        return false;
                    }
                    PsiElement lastNodeType = psiElement2;
                    return lastNodeType == KDocTokens.TEXT || lastNodeType == KtTokens.AT && org.jetbrains.kotlin.idea.editor.KotlinTypedHandler$Companion.access$isLabelCompletion(KotlinTypedHandler.Companion, chars, offset2);
                }
            }, arg_0));
        }

        private final void autoPopupCallableReferenceLookup(Project project, Editor editor2) {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, arg_0 -> Companion.autoPopupCallableReferenceLookup$lambda$2((Function1)new Function1<PsiFile, Boolean>(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiFile file2) {
                    int offset2 = this.$editor.getCaretModel().getOffset();
                    PsiElement psiElement2 = file2.findElementAt(offset2 - 1);
                    if (psiElement2 == null) {
                        return false;
                    }
                    PsiElement lastElement = psiElement2;
                    return lastElement.getNode().getElementType() == KtTokens.COLONCOLON;
                }
            }, arg_0));
        }

        private final boolean endsWith(CharSequence chars, int offset2, String text2) {
            return offset2 < text2.length() ? false : Intrinsics.areEqual((Object)((Object)chars.subSequence(offset2 - text2.length(), offset2)).toString(), (Object)text2);
        }

        private final void dataClassValParameterInsert(Project project, Editor editor2, PsiFile file2, boolean beforeType) {
            if (!KotlinEditorOptions.getInstance().isAutoAddValKeywordToDataClassParameters()) {
                return;
            }
            Document document = editor2.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            int commaOffset = editor2.getCaretModel().getOffset();
            if (!beforeType) {
                --commaOffset;
            }
            if (commaOffset < 1) {
                return;
            }
            PsiElement psiElement2 = file2.findElementAt(commaOffset);
            if (psiElement2 == null) {
                return;
            }
            PsiElement elementOnCaret = psiElement2;
            boolean contextMatched = false;
            PsiElement parentElement = elementOnCaret.getParent();
            if (parentElement instanceof KtParameterList && (parentElement = parentElement.getParent()) instanceof KtPrimaryConstructor && (parentElement = parentElement.getParent()) instanceof KtClass) {
                PsiElement klassElement = parentElement;
                boolean bl = contextMatched = ((KtClass)klassElement).isData() || ((KtClass)klassElement).hasModifier(KtTokens.INLINE_KEYWORD);
            }
            if (!contextMatched) {
                return;
            }
            PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementOnCaret);
            KtParameter ktParameter = psiElement3 instanceof KtParameter ? (KtParameter)psiElement3 : null;
            if (ktParameter == null) {
                return;
            }
            KtParameter leftElement = ktParameter;
            KtTypeReference ktTypeReference = leftElement.getTypeReference();
            if (ktTypeReference == null) {
                return;
            }
            KtTypeReference typeReference2 = ktTypeReference;
            if (leftElement.hasValOrVar()) {
                return;
            }
            if (typeReference2.getTextLength() == 0) {
                return;
            }
            document.insertString(leftElement.getTextOffset(), (CharSequence)"val ");
        }

        private final boolean autoIndentCase(Editor editor2, Project project, PsiFile file2, Class<?> klass2, boolean forFirstElement) {
            int offset2 = editor2.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
            PsiElement currElement = file2.findElementAt(offset2 - 1);
            if (currElement != null) {
                PsiElement prevLeaf2 = PsiTreeUtil.prevLeaf((PsiElement)currElement);
                if (!(!forFirstElement || prevLeaf2 instanceof PsiWhiteSpace && ((PsiWhiteSpace)prevLeaf2).textContains('\n'))) {
                    return false;
                }
                PsiElement parent2 = currElement.getParent();
                if (klass2.isInstance(parent2)) {
                    int curElementLength = currElement.getText().length();
                    if (offset2 < curElementLength) {
                        return false;
                    }
                    if (forFirstElement) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, offset2 - curElementLength);
                    } else {
                        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                        if (document != null) {
                            DocumentUtilsKt.adjustLineIndent(document, project, offset2);
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        static /* synthetic */ boolean autoIndentCase$default(Companion companion, Editor editor2, Project project, PsiFile psiFile2, Class clazz, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return companion.autoIndentCase(editor2, project, psiFile2, clazz, bl);
        }

        private static final boolean autoPopupMemberLookup$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean autoPopupAt$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean autoPopupCallableReferenceLookup$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$isLabelCompletion(Companion $this, CharSequence chars, int offset2) {
            return $this.isLabelCompletion(chars, offset2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

